import os
import json
from flask import g, current_app, request, jsonify, session, send_from_directory, make_response
from apps.inves_manage import api_manage, pro_url
# from apps.utils.commons import login_required
from apps.util import verify_token
from apps.util import login_required
from apps.utils.response_code import RET
from apps.models import *
from apps.utils.read_json import open_type
from datetime import datetime, timedelta
from sqlalchemy import extract, or_, and_
from sqlalchemy.sql import func
import datetime
import filetype
import time
from apps.utils.forms import *
from werkzeug.datastructures import CombinedMultiDict


# 获取筛选条件
@api_manage.route("/getFiled", methods=["GET"])
@login_required
def get_filed():
    try:
        zone = Zone.query.filter_by(statu=1)

        cates = zone.filter_by(sid=1).all()  # 类别
        levels = zone.filter_by(sid=2).all()  # 级别
        # options: [{value: "选项1", label: "无数据"}, {value: "选项2", label: "3333"}],

        data = {"cate": [{"label": i.name, "value": i.nid} for i in cates],  # [i.name for i in cates],
                "level": [{"label": i.name, "value": i.nid} for i in levels],  # [i.name for i in levels],
                "indu": [{"label": "高端装备", "value": 1}, {"label": "新材料", "value": 2},
                         {"label": "新一代信息技术", "value": 3}, {"label": "现代服务业", "value": 4}],
                "status": [{"label": "未上报", "value": 1}, {"label": "审核通过", "value": 2},
                           {"label": "审核驳回", "value": 3}, {"label": "正在审核", "value": 4}]
                }
        data["cate"].insert(0, {"label": "请选择", "value": ""})
        data["level"].insert(0, {"label": "请选择", "value": ""})
        data["indu"].insert(0, {"label": "请选择", "value": ""})
        data["status"].insert(0, {"label": "请选择", "value": ""})
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 获取园区列表（层级权限）
@api_manage.route("/listOfGarden", methods=["POST"])
@login_required
def list_garden():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id

    req_dict = request.get_json()
    key = req_dict.get("key")
    indu = req_dict.get("indu")
    level = req_dict.get("level")
    cate = req_dict.get("cate")
    status = req_dict.get("status")
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")

    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        user = User.query.get(user_id)  # 获取当前用户
        role = user.role  # 获取角色
        unit = user.unit  # 用户机构
        section = user.section  # 用户部门

        garden = Garden.query.filter_by()
        # garden = garden.filter(Garden.cluster.like("%{}%".format(indu)))
        if indu:
            garden = garden.filter(Garden.cluster.like("%{}%".format(indu)))
        if level:
            garden = garden.filter_by(level=level)
        if cate:
            garden = garden.filter_by(cate=cate)
        if status:
            garden = garden.filter_by(status=status)
        if key:
            garden = garden.filter(Garden.name.like("%{}%".format(key)))
        if role.role[0] == "1":  # 机构领导（看全部）
            maxnum = garden.filter(or_(Garden.unit == unit, Garden.up_unit == unit)).count()
            gardens = garden.filter(or_(Garden.unit == unit, Garden.up_unit == unit)).paginate(page, perpage).items
            data = [{"id": i.id,
                     "name": i.name,
                     "address": i.address,
                     "level": i.level,
                     "cate": i.cate,
                     "charge": i.charge,
                     "phone": i.phone,
                     "uperson": i.uperson if i.uperson else "",
                     "unit": i.up_unit,
                     "status": i.status if i.status else ""} for i in gardens]
            data = {"data_lis": data, "maxnum": maxnum}
            return jsonify(code=RET.OK, msg="查询成功", data=data)
        if role.role[0] == "2":  # 部门领导（看部门），自己部门，上报给自己机构的
            # print("===========")
            gardens = garden.filter(
                or_(Garden.up_unit == unit, and_(Garden.unit == unit, Garden.section == section))).paginate(page,
                                                                                                            perpage).items

            maxnum = garden.filter(
                or_(Garden.up_unit == unit, and_(Garden.unit == unit, Garden.section == section))).count()
            # print(gardens)
            data = [{"id": i.id,
                     "name": i.name,
                     "address": i.address,
                     "level": i.level,
                     "cate": i.cate,
                     "charge": i.charge,
                     "phone": i.phone,
                     "uperson": i.uperson if i.uperson else "",
                     "unit": i.up_unit,
                     "status": i.status if i.status else ""} for i in gardens]
            data = {"data_lis": data, "maxnum": maxnum}
            return jsonify(code=RET.OK, msg="查询成功", data=data)
        if role.role[0] == "3":  # 自己看自己,+上报给自己机构的
            gardens = garden.filter(or_(Garden.user == user_id, Garden.up_unit == unit))
            maxnum = gardens.count()
            # print(gardens)
            gardens = gardens.paginate(page, perpage).items
            # print(gardens)
            data = [{"id": i.id,
                     "name": i.name,
                     "address": i.address,
                     "level": i.level,
                     "cate": i.cate,
                     "charge": i.charge,
                     "phone": i.phone,
                     "uperson": i.uperson if i.uperson else "",
                     "unit": i.up_unit,
                     "status": i.status if i.status else ""} for i in gardens]
            data = {"data_lis": data, "maxnum": maxnum}
            return jsonify(code=RET.OK, msg="查询成功", data=data)
        else:
            return jsonify(code=RET.DATAERR, msg="参数错误")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 园区新增
@api_manage.route("/addGarden", methods=["POST"])
@login_required
def add_garden():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        role = user.role.role

        if not role:
            return jsonify(code=RET.OK, msg="无权限查看此内容")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    role = user.role
    if role.role[5] != "1":
        return jsonify(code=RET.REQERR, msg="暂无权限")

    req_dict = request.get_json()
    # 基本信息*
    name = req_dict.get("name")  # 园区姓名
    level = req_dict.get("level")  # 园区级别
    charge = req_dict.get("charge")  # 园区负责人
    phone = req_dict.get("phone")  # 园区联系电话
    cate = req_dict.get("cate")  # 园区类型
    address = req_dict.get("address")  # 园区地址
    cluster = req_dict.get("cluster")  # 产业集群（多选）[]
    area = req_dict.get("area")  # 占地面积(平方公里)
    acreage = req_dict.get("acreage")  # 规划面积（平方公里）

    gdp = req_dict.get("gdp")  # GDP(亿元)
    # 土地信息
    land_code = req_dict.get("land_code")  # 土地位置/编号
    land_property = req_dict.get("land_property")  # 土地性质
    land_range = req_dict.get("land_range")  # 土地范围
    land_size = req_dict.get("land_size")  # 土地面积/平方公里
    indu_appeal = req_dict.get("indu_appeal")  # 产业诉求
    # 楼宇信息
    build_name = req_dict.get("build_name")  # 楼宇名称
    build_add = req_dict.get("build_add")  # 楼宇地址
    build_size = req_dict.get("build_size")  # 楼宇面积/平方公里
    build_appeal = req_dict.get("build_appeal")  # 楼宇诉求
    # 厂房信息
    plant_add = req_dict.get("plant_add")  # 厂房位置
    plant_size = req_dict.get("plant_size")  # 厂房面积
    plant_condition = req_dict.get("plant_condition")  # 厂房条件

    # 投资成本
    resident_ele_one = req_dict.get("resident_ele_one")  # 居民用电（一档）（元/度）
    resident_ele_two = req_dict.get("resident_ele_two")  # 居民用电（二档）（元/度）
    resident_ele_thr = req_dict.get("resident_ele_thr")  # 居民用电（三档）（元/度）
    comm_ele_one = req_dict.get("comm_ele_one")  # 商业用电（峰段）（元/度）
    comm_ele_two = req_dict.get("comm_ele_two")  # 商业用电（平段）（元/度）
    comm_ele_thr = req_dict.get("comm_ele_thr")  # 商业用电（谷段）（元/度）
    indu_ele_one = req_dict.get("indu_ele_one")  # 工业用电（峰段）（元/度）
    indu_ele_two = req_dict.get("indu_ele_two")  # 工业用电（平段）（元/度）
    indu_ele_thr = req_dict.get("indu_ele_thr")  # 工业用电（谷段）（元/度）
    resident_water_one = req_dict.get("resident_water_one")  # 居民用水（一档）（元/吨）
    resident_water_two = req_dict.get("resident_water_two")  # 居民用水（二档）（元/吨）
    resident_water_thr = req_dict.get("resident_water_thr")  # 居民用水（三档）（元/吨）
    comm_water = req_dict.get("comm_water")  # 商业用水（元/吨）
    indu_water = req_dict.get("indu_water")  # 工业用水（元/吨）
    special_water = req_dict.get("special_water")  # 特种用水（元/吨）
    resident_natgas_one = req_dict.get("resident_natgas_one")  # 居民用气（一档）（元/m³）
    resident_natgas_two = req_dict.get("resident_natgas_two")  # 居民用气（二档）（元/m³）
    resident_natgas_thr = req_dict.get("resident_natgas_thr")  # 居民用气（三档）（元/m³）
    sewage = req_dict.get("sewage")  # 污水处理（元/吨）
    wagelevel = req_dict.get("wagelevel")  # 最低工资标准（元/月）
    worker = req_dict.get("worker")  # 普通员工（元/月）
    middlemag = req_dict.get("middlemag")  # 中级管理人员（元/月）
    highmag = req_dict.get("highmag")  # 高层管理人员（元/月）
    # 环境配套
    dis_freight = req_dict.get("dis_freight")  # 距离货运站距离
    dis_rail = req_dict.get("dis_rail")  # 距离高铁站
    dis_port = req_dict.get("dis_port")  # 距离港口距离
    dis_air = req_dict.get("dis_air")  # 距离机场距离
    road_trans = req_dict.get("road_trans")  # 公路运输
    rail_trans = req_dict.get("rail_trans")  # 铁路运输
    live_facility = req_dict.get("live_facility")  # 园区生活配套
    market = req_dict.get("market")  # 百货商场
    hotel_bus = req_dict.get("hotel_bus")  # 酒店商务
    medical = req_dict.get("medical")  # 医疗机构
    education = req_dict.get("education")  # 学校教育

    induenterprise = req_dict.get("induenterprise")  # 规模以上企业
    innovate = req_dict.get("innovate")  # 科研机构
    base = req_dict.get("base")  # 双创基地
    carrier = req_dict.get("carrier")  # 产业载体

    if not all([name, level, charge, phone, cate, address, cluster, area, acreage]):
        return jsonify(code=RET.PARAMERR, msg="基本信息请填完整")
    cluster = ",".join(cluster)
    try:
        user = User.query.get(user_id)
        unit = user.unit
        section = user.section

        garden = Garden(unit=unit, section=section, user=user_id, name=name, level=level, charge=charge, phone=phone,
                        cate=cate, address=address, cluster=cluster, area=area, acreage=acreage, gdp=gdp,
                        land_code=land_code, land_property=land_property, land_range=land_range, land_size=land_size,
                        indu_appeal=indu_appeal, build_name=build_name, build_add=build_add, build_size=build_size,
                        build_appeal=build_appeal, plant_add=plant_add, plant_size=plant_size,
                        plant_condition=plant_condition)
        if resident_ele_one:
            garden.resident_ele_one = resident_ele_one
        if resident_ele_two:
            garden.resident_ele_two = resident_ele_two
        if resident_ele_thr:
            garden.resident_ele_thr = resident_ele_thr
        if comm_ele_one:
            garden.comm_ele_one = comm_ele_one
        if comm_ele_two:
            garden.comm_ele_two = comm_ele_two
        if comm_ele_thr:
            garden.comm_ele_thr = comm_ele_thr
        if indu_ele_one:
            garden.indu_ele_one = indu_ele_one
        if indu_ele_two:
            garden.indu_ele_two = indu_ele_two
        if indu_ele_thr:
            garden.indu_ele_thr = indu_ele_thr
        if resident_water_one:
            garden.resident_water_one = resident_water_one
        if resident_water_two:
            garden.resident_water_two = resident_water_two
        if resident_water_thr:
            garden.resident_water_thr = resident_water_thr
        if comm_water:
            garden.comm_water = comm_water
        if indu_water:
            garden.indu_water = indu_water
        if special_water:
            garden.special_water = special_water
        if resident_natgas_one:
            garden.resident_natgas_one = resident_natgas_one
        if resident_natgas_two:
            garden.resident_natgas_two = resident_natgas_two
        if resident_natgas_thr:
            garden.resident_natgas_thr = resident_natgas_thr
        if sewage:
            garden.sewage = sewage
        if wagelevel:
            garden.wagelevel = wagelevel
        if worker:
            garden.worker = worker
        if middlemag:
            garden.middlemag = middlemag
        if highmag:
            garden.highmag = highmag
        if dis_freight:
            garden.dis_freight = dis_freight
        if dis_rail:
            garden.dis_rail = dis_rail
        if dis_port:
            garden.dis_port = dis_port
        if dis_air:
            garden.dis_air = dis_air
        if road_trans:
            garden.road_trans = road_trans
        if rail_trans:
            garden.rail_trans = rail_trans
        if live_facility:
            garden.live_facility = live_facility
        if market:
            garden.market = market
        if hotel_bus:
            garden.hotel_bus = hotel_bus
        if medical:
            garden.medical = medical
        if education:
            garden.education = education
        if induenterprise:
            garden.induenterprise = induenterprise
        if innovate:
            garden.innovate = innovate
        if base:
            garden.base = base
        if carrier:
            garden.carrier = carrier
        db.session.add(garden)
        db.session.commit()
        garden_id = garden.id
        return jsonify(code=RET.OK, msg="添加成功", id=garden_id)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 园区审核
@api_manage.route("/passGarden", methods=["POST"])
@login_required
def pass_garden():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id

    try:
        user = User.query.get(user_id)
        role = user.role
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    if role.role[4] != "1":
        return jsonify(code=RET.REQERR, msg="暂无权限")
    req_dict = request.get_json()
    id = req_dict.get("id")  # 园区id
    advice = req_dict.get("advice")  # 1通过，2驳回
    if not all([id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        garden = Garden.query.get(id)
        if advice == 1:
            garden.status = "审核通过"
            db.session.commit()
            return jsonify(code=RET.OK, msg="已通过")
        else:
            garden.status = "审核驳回"
            db.session.commit()
            return jsonify(code=RET.OK, msg="已驳回")
    except Exception as e:
        db.session.rollabck()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")


# 园区上报
@api_manage.route("/sendGarden", methods=["POST"])
@login_required
def send_garden():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        role = user.role
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
    if role.role[4] != "1":
        return jsonify(code=RET.REQERR, msg="暂无权限")
    req_dict = request.get_json()
    id = req_dict.get("id")  # 园区id
    org = req_dict.get("org")  # 待上报机构名

    if not all([id, org]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        garden = Garden.query.get(id)
        garden.uperson = user.name
        garden.up_unit = org
        garden.status = "正在审核"
        db.session.commit()
        return jsonify(code=RET.OK, msg="上报成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")


# 园区修改
@api_manage.route("/editGarden", methods=["POST"])
@login_required
def edit_garden():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id

    user = User.query.get(user_id)
    role = user.role
    if role.role[5] != "1":
        return jsonify(code=RET.REQERR, msg="暂无权限")
    req_dict = request.get_json()
    id = req_dict.get("id")  # 园区id
    name = req_dict.get("name")  # 园区姓名
    level = req_dict.get("level")  # 园区级别
    charge = req_dict.get("charge")  # 园区负责人
    phone = req_dict.get("phone")  # 园区联系电话
    cate = req_dict.get("cate")  # 园区类型
    address = req_dict.get("address")  # 园区地址
    cluster = req_dict.get("cluster")  # 产业集群（多选）
    # 园区信息
    area = req_dict.get("area")  # 占地面积(平方公里)
    acreage = req_dict.get("acreage")  # 规划面积（平方公里）
    gdp = req_dict.get("gdp")  # GDP(亿元)
    # 土地信息
    land_code = req_dict.get("land_code")  # 土地位置/编号
    land_property = req_dict.get("land_property")  # 土地性质
    land_range = req_dict.get("land_range")  # 土地范围
    land_size = req_dict.get("land_size")  # 土地面积/平方公里
    indu_appeal = req_dict.get("indu_appeal")  # 产业诉求
    # 楼宇信息
    build_name = req_dict.get("build_name")  # 楼宇名称
    build_add = req_dict.get("build_add")  # 楼宇地址
    build_size = req_dict.get("build_size")  # 楼宇面积/平方公里
    build_appeal = req_dict.get("build_appeal")  # 楼宇诉求
    # 厂房信息
    plant_add = req_dict.get("plant_add")  # 厂房位置
    plant_size = req_dict.get("plant_size")  # 厂房面积
    plant_condition = req_dict.get("plant_condition")  # 厂房条件

    # 投资成本
    resident_ele_one = req_dict.get("resident_ele_one")  # 居民用电（一档）（元/度）
    resident_ele_two = req_dict.get("resident_ele_two")  # 居民用电（二档）（元/度）
    resident_ele_thr = req_dict.get("resident_ele_thr")  # 居民用电（三档）（元/度）
    comm_ele_one = req_dict.get("comm_ele_one")  # 商业用电（峰段）（元/度）
    comm_ele_two = req_dict.get("comm_ele_two")  # 商业用电（平段）（元/度）
    comm_ele_thr = req_dict.get("comm_ele_thr")  # 商业用电（谷段）（元/度）
    indu_ele_one = req_dict.get("indu_ele_one")  # 工业用电（峰段）（元/度）
    indu_ele_two = req_dict.get("indu_ele_two")  # 工业用电（平段）（元/度）
    indu_ele_thr = req_dict.get("indu_ele_thr")  # 工业用电（谷段）（元/度）
    resident_water_one = req_dict.get("resident_water_one")  # 居民用水（一档）（元/吨）
    resident_water_two = req_dict.get("resident_water_two")  # 居民用水（二档）（元/吨）
    resident_water_thr = req_dict.get("resident_water_thr")  # 居民用水（三档）（元/吨）
    comm_water = req_dict.get("comm_water")  # 商业用水（元/吨）
    indu_water = req_dict.get("indu_water")  # 工业用水（元/吨）
    special_water = req_dict.get("special_water")  # 特种用水（元/吨）
    resident_natgas_one = req_dict.get("resident_natgas_one")  # 居民用气（一档）（元/m³）
    resident_natgas_two = req_dict.get("resident_natgas_two")  # 居民用气（二档）（元/m³）
    resident_natgas_thr = req_dict.get("resident_natgas_thr")  # 居民用气（三档）（元/m³）
    sewage = req_dict.get("sewage")  # 污水处理（元/吨）
    wagelevel = req_dict.get("wagelevel")  # 最低工资标准（元/月）
    worker = req_dict.get("worker")  # 普通员工（元/月）
    middlemag = req_dict.get("middlemag")  # 中级管理人员（元/月）
    highmag = req_dict.get("highmag")  # 高层管理人员（元/月）
    # 环境配套
    dis_freight = req_dict.get("dis_freight")  # 距离货运站距离
    dis_rail = req_dict.get("dis_rail")  # 距离高铁站
    dis_port = req_dict.get("dis_port")  # 距离港口距离
    dis_air = req_dict.get("dis_air")  # 距离机场距离
    road_trans = req_dict.get("road_trans")  # 公路运输
    rail_trans = req_dict.get("rail_trans")  # 铁路运输
    live_facility = req_dict.get("live_facility")  # 园区生活配套
    market = req_dict.get("market")  # 百货商场
    hotel_bus = req_dict.get("hotel_bus")  # 酒店商务
    medical = req_dict.get("medical")  # 医疗机构
    education = req_dict.get("education")  # 学校教育

    induenterprise = req_dict.get("induenterprise")  # 规模以上企业
    innovate = req_dict.get("innovate")  # 科研机构
    base = req_dict.get("base")  # 双创基地
    carrier = req_dict.get("carrier")  # 产业载体

    if not all([name, level, charge, phone, cate, address, cluster, area, acreage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    cluster = ",".join(cluster)
    try:
        garden = Garden.query.get(id)
        garden.name = name
        garden.level = level
        garden.charge = charge
        garden.phone = phone
        garden.cate = cate
        garden.address = address
        garden.cluster = cluster
        garden.area = area
        garden.acreage = acreage
        garden.gdp = gdp
        garden.land_code = land_code
        garden.land_property = land_property
        garden.land_range = land_range
        garden.land_size = land_size
        garden.indu_appeal = indu_appeal
        garden.build_name = build_name
        garden.build_add = build_add
        garden.build_size = build_size
        garden.build_appeal = build_appeal
        garden.plant_add = plant_add
        garden.plant_size = plant_size
        garden.plant_condition = plant_condition

        if resident_ele_one:
            garden.resident_ele_one = resident_ele_one
        if resident_ele_two:
            garden.resident_ele_two = resident_ele_two
        if resident_ele_thr:
            garden.resident_ele_thr = resident_ele_thr
        if comm_ele_one:
            garden.comm_ele_one = comm_ele_one
        if comm_ele_two:
            garden.comm_ele_two = comm_ele_two
        if comm_ele_thr:
            garden.comm_ele_thr = comm_ele_thr
        if indu_ele_one:
            garden.indu_ele_one = indu_ele_one
        if indu_ele_two:
            garden.indu_ele_two = indu_ele_two
        if indu_ele_thr:
            garden.indu_ele_thr = indu_ele_thr
        if resident_water_one:
            garden.resident_water_one = resident_water_one
        if resident_water_two:
            garden.resident_water_two = resident_water_two
        if resident_water_thr:
            garden.resident_water_thr = resident_water_thr
        if comm_water:
            garden.comm_water = comm_water
        if indu_water:
            garden.indu_water = indu_water
        if special_water:
            garden.special_water = special_water
        if resident_natgas_one:
            garden.resident_natgas_one = resident_natgas_one
        if resident_natgas_two:
            garden.resident_natgas_two = resident_natgas_two
        if resident_natgas_thr:
            garden.resident_natgas_thr = resident_natgas_thr
        if sewage:
            garden.sewage = sewage
        if wagelevel:
            garden.wagelevel = wagelevel
        if worker:
            garden.worker = worker
        if middlemag:
            garden.middlemag = middlemag
        if highmag:
            garden.highmag = highmag
        if dis_freight:
            garden.dis_freight = dis_freight
        if dis_rail:
            garden.dis_rail = dis_rail
        if dis_port:
            garden.dis_port = dis_port
        if dis_air:
            garden.dis_air = dis_air
        if road_trans:
            garden.road_trans = road_trans
        if rail_trans:
            garden.rail_trans = rail_trans
        if live_facility:
            garden.live_facility = live_facility
        if market:
            garden.market = market
        if hotel_bus:
            garden.hotel_bus = hotel_bus
        if medical:
            garden.medical = medical
        if education:
            garden.education = education
        if induenterprise:
            garden.induenterprise = induenterprise
        if innovate:
            garden.innovate = innovate
        if base:
            garden.base = base
        if carrier:
            garden.carrier = carrier
        db.session.commit()
        return jsonify(code=RET.OK, msg="修改成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 园区查看
@api_manage.route("/detailGarden", methods=["POST"])
# @login_required
def detail_garden():
    req_dict = request.get_json()
    id = req_dict.get('id')  # 园区id

    if not all([id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        garden = Garden.query.get(id)
        if garden:
            data = {"id": garden.id,
                    "name": garden.name,
                    "level": garden.level,
                    "charge": garden.charge,
                    "phone": garden.phone,
                    "cate": garden.cate,
                    "address": garden.address,
                    "cluster": garden.cluster,
                    "area": garden.area,
                    "acreage": garden.acreage,

                    "gdp": garden.gdp,
                    "land_code": garden.land_code if garden.land_code else "-",
                    "land_property": garden.land_property if garden.land_property else "-",
                    "land_range": garden.land_range if garden.land_range else "-",
                    "land_size": garden.land_size if garden.land_size else "-",
                    "indu_appeal": garden.indu_appeal if garden.indu_appeal else "-",
                    "build_name": garden.build_name if garden.build_name else "-",
                    "build_add": garden.build_add if garden.build_add else "-",
                    "build_size": garden.build_size if garden.build_size else "-",
                    "build_appeal": garden.build_appeal if garden.build_appeal else "-",
                    "plant_add": garden.plant_add if garden.plant_add else "-",
                    "plant_size": garden.plant_size if garden.plant_size else "-",
                    "plant_condition": garden.plant_condition if garden.plant_condition else "-",

                    "resident_ele_one": garden.resident_ele_one if garden.resident_ele_one else "-",
                    "resident_ele_two": garden.resident_ele_two if garden.resident_ele_two else "-",
                    "resident_ele_thr": garden.resident_ele_thr if garden.resident_ele_thr else "-",
                    "comm_ele_one": garden.comm_ele_one if garden.comm_ele_one else "-",
                    "comm_ele_two": garden.comm_ele_two if garden.comm_ele_two else "-",
                    "comm_ele_thr": garden.resident_ele_thr if garden.comm_ele_thr else "-",
                    "indu_ele_one": garden.indu_ele_one if garden.indu_ele_one else "-",
                    "indu_ele_two": garden.indu_ele_two if garden.indu_ele_two else "-",
                    "indu_ele_thr": garden.indu_ele_thr if garden.indu_ele_thr else "-",
                    "resident_water_one": garden.resident_water_one if garden.resident_water_one else "-",
                    "resident_water_two": garden.resident_water_two if garden.resident_water_two else "-",
                    "resident_water_thr": garden.resident_water_thr if garden.resident_water_thr else "-",
                    "comm_water": garden.comm_water if garden.comm_water else "-",
                    "indu_water": garden.indu_water if garden.indu_water else "-",
                    "special_water": garden.special_water if garden.special_water else "-",
                    "resident_natgas_one": garden.resident_natgas_one if garden.resident_natgas_one else "-",
                    "resident_natgas_two": garden.resident_natgas_two if garden.resident_natgas_two else "-",
                    "resident_natgas_thr": garden.resident_natgas_thr if garden.resident_natgas_thr else "-",
                    "sewage": garden.sewage if garden.sewage else "-",
                    "wagelevel": garden.wagelevel if garden.wagelevel else "-",
                    "worker": garden.worker if garden.worker else "-",
                    "middlemag": garden.middlemag if garden.middlemag else "-",
                    "highmag": garden.highmag if garden.highmag else "-",
                    "dis_freight": garden.dis_freight if garden.dis_freight else "-",
                    "dis_rail": garden.dis_rail if garden.dis_rail else "-",
                    "dis_port": garden.dis_port if garden.dis_port else "-",
                    "dis_air": garden.dis_air if garden.dis_air else "-",
                    "road_trans": garden.road_trans if garden.road_trans else "-",
                    "rail_trans": garden.rail_trans if garden.rail_trans else "-",
                    "live_facility": garden.live_facility if garden.live_facility else "-",
                    "market": garden.market if garden.market else "-",
                    "hotel_bus": garden.hotel_bus if garden.hotel_bus else "-",
                    "medical": garden.medical if garden.medical else "-",
                    "education": garden.education if garden.education else "-",
                    "induenterprise": garden.induenterprise if garden.induenterprise else "-",
                    "innovate": garden.innovate if garden.innovate else "-",
                    "base": garden.base if garden.base else "-",
                    "carrier": garden.carrier if garden.carrier else "-",

                    }
            return jsonify(code=RET.OK, msg="查询成功", data=data)
        return jsonify(code=RET.OK, msg="没有文件", data=False)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# TODO 文件操作等由于路径十分混乱，删除
@api_manage.route("/downModel", methods=["GET"])
# @login_required
def down_model():
    '''带中文名本地文件下载'''
    # filename = request.args.get('indu_name') + ".xlsx"
    filename = "××园区调研问卷附表.xlsx"
    # http://127.0.0.1:5000/api/manage/downModel
    url = pro_url + "/model/" + filename
    return jsonify(code=RET.OK, msg='下载成功', url=url, filename=filename)


# # 规模下载 二进制文件流
# @api_manage.route("/downFilewa", methods=["GET"])
# # @login_required
# def down_filewa():
#     '''带中文名本地文件下载'''
#     # filename = request.args.get('indu_name') + ".xlsx"
#     filename = "全国省市区信息.xlsx"
#     # http://127.0.0.1:5000/api/manage/downModel
#     directory = os.getcwd() + "/apps/static/files/"  # 文件目录
#     response = make_response(send_from_directory(directory, filename, as_attachment=True))
#     response.headers["Content-Disposition"] = "attachment; filename={}".format(filename.encode().decode('latin-1'))
#     return response
''''''


# 检查是否有文件
@api_manage.route("/checkFile", methods=["POST"])
def check_file():
    req_dict = request.get_json()
    id = req_dict.get('id')  # 园区id

    if not id:
        return jsonify(code=RET.PARAMERR, msg="数据不完整")

    try:
        garden = Garden.query.get(id)
        if garden.url_file:
            return jsonify(code=RET.OK, msg="已有文件", data=True)
        return jsonify(code=RET.OK, msg="没有文件", data=False)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 上传文件，限制大小16M，提示5M
@api_manage.route("/upFile", methods=["POST"])
def up_file():
    # user_id = g.user_id
    req_dict = request.form.to_dict()
    id = req_dict.get('id')  # 园区id
    file = request.files.get('file')
    if not file:
        return jsonify(code=RET.NODATA, msg="文件未上传")

    # 文件从request,files获取，这里使用CombinedMultiDict把form和file的数据组合起来，一起验证
    form = UploadFormFile(CombinedMultiDict([request.form, request.files]))
    if not form.validate():
        return jsonify(code=RET.DATAERR, msg=form.errors)

    # 保存到本地服务器
    image_name = file.filename
    url = image_name

    # 保存文件名到数据库中
    try:
        garden = Garden.query.filter_by(id=id).first()
        # 删除原文件
        if garden.url_file:
            filename = str(garden.url_file)
            path = os.getcwd() + "/apps/static/files/" + filename
            os.unlink(path)
            # 保存新文件
            file.save('./apps/static/files/{}'.format(image_name))
            # 提交新文件名
            garden.url_file = url
            db.session.commit()
            return jsonify(code=RET.OK, msg="保存成功")
        file.save('./apps/static/files/{}'.format(image_name))
        garden.url_file = url
        db.session.commit()
        return jsonify(code=RET.OK, msg="保存成功")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="保存文件失败")


# # 上传文件，限制大小16M，提示5M
# @api_manage.route("/upFile", methods=["POST"])
# def up_file():
#     # user_id = g.user_id
#     req_dict = request.form.to_dict()
#     id = req_dict.get('id')  # 园区id
#     file = request.files.get('file')
#     print(file.filename)
#     if not file:
#         return jsonify(code = RET.NODATA, msg = "文件未上传")
#
#     # 文件从request,files获取，这里使用CombinedMultiDict把form和file的数据组合起来，一起验证
#     form = UploadFormFile(CombinedMultiDict([request.form, request.files]))
#     if not form.validate():
#         return jsonify(code =RET.DATAERR, msg=form.errors)
#
#     # 保存到本地服务器
#     image_name = file.filename
#     url = image_name
#
#     # 保存文件名到数据库中
#     try:
#         garden = Garden.query.filter_by(id=id).first()
#         # 删除原文件
#         filename = str(garden.url_file)
#         path = os.getcwd() + "/apps/static/files/" + filename
#         os.unlink(path)
#         # 保存新文件
#         file.save('./apps/static/files/{}'.format(image_name))
#         # 提交新文件名
#         garden.url_file = url
#         db.session.commit()
#     except Exception as e:
#         db.session.rollback()
#         current_app.logger.error(e)
#         return jsonify(code =RET.DBERR, msg ="保存文件失败")
#
#     return jsonify(code =RET.OK, msg ="保存成功")


# 文件下载
@api_manage.route("/downFile", methods=["POST"])
# @login_required
def down_file():
    req_dict = request.get_json()
    id = req_dict.get('id')  # 园区id
    # id = 1  # 园区id
    try:
        garden = Garden.query.get(id)
        if garden.url_file:
            filename = str(garden.url_file)
            url = pro_url + "/files/" + filename
            return jsonify(code=RET.OK, msg="上传成功", url=url, filename=filename)
            # directory = os.getcwd() + "/apps/static/files/"  # 文件目录
            # response = make_response(send_from_directory(directory, filename, as_attachment=True))
            # response.headers["Content-Disposition"] = "attachment; filename={}".format(
            #     filename.encode().decode('latin-1'))
            # return response
        return jsonify(code=RET.OK, msg="暂无文件")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# @api_manage.route("/downFile", methods=["POST"])
# # @login_required
# def down_file():
#     req_dict = request.get_json()
#     id = req_dict.get('id')  # 园区id
#     # id = 1  # 园区id
#     try:
#         garden = Garden.query.get(id)
#         if garden.url_file:
#             filename = str(garden.url_file)
#             directory = os.getcwd() + "/apps/static/files/"  # 文件目录
#             response = make_response(send_from_directory(directory, filename, as_attachment=True))
#             response.headers["Content-Disposition"] = "attachment; filename={}".format(
#                 filename.encode().decode('latin-1'))
#             return response
#         return jsonify(code=RET.OK, msg="暂无文件")
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 资料上传
@api_manage.route("/upDoc", methods=["POST"])
@login_required
def up_doc():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id

    req_dict = request.form.to_dict()
    id = req_dict.get('id')  # 园区id
    size = req_dict.get("size")  # 文件大小
    file = request.files.get('file')

    if not file:
        return jsonify(code=RET.NODATA, msg="文件未上传")

    # # 文件从request,files获取，这里使用CombinedMultiDict把form和file的数据组合起来，一起验证
    # form = UploadFormFile(CombinedMultiDict([request.form, request.files]))
    # if not form.validate():
    #     return jsonify(code=RET.DATAERR, msg=form.errors)

    # 保存到本地服务器
    image_name = "{}".format(int(time.time())) + file.filename

    # 保存文件名到数据库中
    try:
        user = User.query.get(user_id)
        garden = Garden.query.get(id)
        gfile = Gfile(name=image_name, size=size, uperson=user.real_name, cate=1)
        db.session.add(gfile)
        file.save('./apps/static/projectfile/{}'.format(image_name))
        garden.document.append(gfile)
        db.session.commit()
        file_id = gfile.id
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="保存文件失败")
    data = {"filename": image_name, "uperson": user.real_name, "id": file_id}
    return jsonify(code=RET.OK, msg="保存成功", data=data)


# 获取园区资料列表
@api_manage.route("/listDoc", methods=["POST"])
# @login_required
def list_doc():
    # user_id = g.user_id
    req_dict = request.get_json()
    id = req_dict.get('id')  # 园区id
    try:
        garden = Garden.query.get(id)
        docs = garden.document
        data = [{"id": i.id,
                 "filename": i.name[10:],
                 "size": i.size,
                 "uperson": i.uperson
                 } for i in docs if i.cate == 1]
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        # db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="服务器错误")


# # 获取园区资料列表
# @api_manage.route("/listDoc", methods=["POST"])
# # @login_required
# def list_doc():
#     # user_id = g.user_id
#     req_dict = request.form.to_dict()
#     id = req_dict.get('id')  # 园区id
#     try:
#         garden = Garden.query.get(id)
#         docs = garden.document
#         data = [{"id": i.id,
#                  "filename": i.name,
#                  "size": i.size,
#                  "uperson": i.uperson
#                  } for i in docs if i.cate == 1]
#         return jsonify(code=RET.OK, msg="查询成功", data=data)
#     except Exception as e:
#         # db.session.rollback()
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="保存文件失败")


# 文件下载
@api_manage.route("/downDoc", methods=["POST"])
# @login_required
def down_doc():
    req_dict = request.get_json()
    id = req_dict.get('id')  # 文件id
    try:
        gfile = Gfile.query.get(id)
        if gfile:
            filename = str(gfile.name)
            url = pro_url + "/projectfile/" + filename
            return jsonify(code=RET.OK, msg="查找成功", filename=filename, url=url)
        return jsonify(code=RET.DATAERR, msg="参数错误")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# # 文件下载
# @api_manage.route("/downDoc", methods=["POST"])
# # @login_required
# def down_doc():
#     req_dict = request.get_json()
#     id = req_dict.get('id')  # 文件id
#     try:
#         gfile = Gfile.query.get(id)
#         if gfile:
#             filename = str(gfile.name)
#             directory = os.getcwd() + "/apps/static/projectfile/"  # 文件目录
#             response = make_response(send_from_directory(directory, filename, as_attachment=True))
#             response.headers["Content-Disposition"] = "attachment; filename={}".format(
#                 filename.encode().decode('latin-1'))
#             return response
#         return jsonify(code=RET.DATAERR, msg="参数错误")
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库查询错误")

''''''


# 文件删除
@api_manage.route("/deleteDoc", methods=["POST"])
# @login_required
def delete_doc():
    req_dict = request.get_json()
    id = req_dict.get('id')  # 文件id
    try:
        gfile = Gfile.query.get(id)
        if gfile:
            db.session.delete(gfile)
            db.session.commit()
            return jsonify(code=RET.OK, msg="删除成功")
        return jsonify(code=RET.DATAERR, msg="参数错误")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 图片上传
@api_manage.route("/upImage", methods=["POST"])
@login_required
def up_image():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id

    req_dict = request.form.to_dict()
    id = req_dict.get('id')  # 园区id
    file = request.files.get('file')
    if not file:
        return jsonify(code=RET.NODATA, msg="文件未上传")

    # 保存到本地服务器
    image_name = "{}".format((int(time.time()))) + file.filename
    # 保存文件名到数据库中
    try:
        user = User.query.get(user_id)
        garden = Garden.query.get(id)
        gfile = Gfile(name=image_name, uperson=user.real_name, cate=2)
        db.session.add(gfile)
        file.save('./apps/static/image/{}'.format(image_name))
        garden.document.append(gfile)
        db.session.commit()
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="保存文件失败")
    image_id = gfile.id
    data = {"filename": image_name, "uperson": user.real_name, "id": image_id}
    return jsonify(code=RET.OK, msg="保存成功", data=data)


# 获取园区图片列表
@api_manage.route("/listImage", methods=["POST"])
# @login_required
def list_img():
    # user_id = g.user_id
    req_dict = request.get_json()
    id = req_dict.get('id')  # 园区id
    try:
        garden = Garden.query.get(id)
        docs = garden.document
        data = [{"id": i.id,
                 "url": pro_url + "/image/" + i.name,
                 } for i in docs if i.cate == 2]
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        # db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
