# from flask import current_app, request, jsonify
# from apps.atlas import api_atlas
# from sqlalchemy import extract, or_, and_
# from sqlalchemy.sql import func
# from apps.models import *
# from apps.util import login_required, verify_token
# from apps.utils.response_code import RET
# from datetime import datetime, timedelta
#
#
# # 行业分类自定义层级信息全部获取(2020-11-3)
# @api_atlas.route('/get_fields', methods=['GET'])
# @login_required
# def get_fields():
#     '''获取左侧导航信息一览，两级导航'''
#     try:
#         # 获取一级行业
#         fields = Industry.query.filter_by(fid=0, statu=1).all()
#         print(fields)
#         data = []
#         for field in fields:
#             df = {"id": field.nid,
#                   "cate": "1",
#                   "label": field.name,
#                   "children": []}
#             childs = Industry.query.filter_by(fid=field.nid, statu=1).all()
#             for child in childs:
#                 df["children"].append({"id": child.nid,
#                                        "label": child.name,
#                                        "cate": "2"})
#             data.append(df)
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据异常")
#     return jsonify(code=RET.OK, msg="获取成功", navleftdata=data)
#
#
# # 二级行业收藏状态获取
# @api_atlas.route('/inducollect/<id>', methods=['GET'])
# @login_required
# def inducollect(id):
#     '''获取当前用户对二级行业的收藏状态'''
#     token = request.headers["token"]
#     user = verify_token(token)
#     user_id = user.id  # 用户id
#     try:
#         user = User.query.get(user_id)  # 获取关注列表
#         industrys = user.industry
#         if industrys:
#             indu_ids = [indu.id for indu in user.industry]
#         else:
#             indu_ids = []
#         if int(id) in indu_ids:
#             return jsonify(code=RET.OK, msg="查询成功", collect="1")
#         else:
#             return jsonify(code=RET.OK, msg="查询成功", collect="2")
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库查询错误")
#
#
# # 行业业收藏与取消
# @api_atlas.route('/industry/collect', methods=['POST'])
# @login_required
# def indu_collect():
#     '''企业收藏与状态取消'''
#     token = request.headers["token"]
#     user = verify_token(token)
#     user_id = user.id  # 用户id
#
#     req_dict = request.get_json()
#     _id = req_dict.get("id")  # 二级行业id
#     collect = req_dict.get("collect")  # 关注状态(1是，2否)
#     # 校验参数完整性
#     if not all([_id, collect]):
#         return jsonify(code=RET.PARAMERR, msg="参数不完整")
#     try:
#         if collect == "2":  # 未关注，我要关注
#             user = User.query.get(user_id)
#             indu = Industry.query.filter_by(nid=_id).first()
#             user.industry.append(indu)
#             db.session.commit()
#             return jsonify(code=RET.OK, msg="收藏成功", collect="1")
#         elif collect == "1":  # 已关注，我要取关
#             user = User.query.get(user_id)
#             indu = Industry.query.filter_by(nid=_id).first()
#             user.industry.remove(indu)
#             db.session.commit()
#             return jsonify(code=RET.OK, msg="取消收藏", collect="2")
#         else:
#             return jsonify(code=RET.DATAERR, msg="参数异常")
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库查询错误")
#
#
# # 太原市企业条件选择导航(类型，资质，上市，融资，时间，注册资本，区县选择)
# @api_atlas.route('/industry/field', methods=['GET'])
# # @login_required
# def field():
#     '''太原市企业条件选择导航获取'''
#     try:
#         property = Propertyty.query.filter_by(statu=1)
#         typy = property.filter_by(sid=1, statu=1).all()
#         qualificat = property.filter_by(sid=2, statu=1).all()
#         quoted = property.filter_by(sid=3, statu=1).all()
#         financ = property.filter_by(sid=4, statu=1).all()
#         # options: [{ value: "选项1", label: "无数据" },{ value: "选项2", label: "3333" }],
#         data = {"entype": [{"label": i.name, "value": i.nid} for i in typy],
#                 "qualificat": [{"label": i.name, "value": i.nid} for i in qualificat],
#                 "quoted": [{"label": i.name, "value": i.nid} for i in quoted],
#                 "financ": [{"label": i.name, "value": i.nid} for i in financ],
#                 "buildate": [{"label": "1-3年", "value": 1}, {"label": "3-5年", "value": 2},
#                              {"label": "5-8年", "value": 3}, {"label": "8-10年", "value": 4},
#                              {"label": "10-15年", "value": 5}, {"label": "15年以上", "value": 6}],
#                 "capital": [{"label": "100万以内", "value": 1}, {"label": "100万-500万", "value": 2},
#                             {"label": "500万-1000万", "value": 3}, {"label": "1000万-5000万", "value": 4},
#                             {"label": "5000万-1亿", "value": 5}, {"label": "1亿以上", "value": 6}],
#                 "district": [{"label": "小店区", "value": "小店区"}, {"label": "迎泽区", "value": "迎泽区"},
#                              {"label": "杏花岭区", "value": "杏花岭区"}, {"label": "尖草坪区", "value": "尖草坪区"},
#                              {"label": "万柏林区", "value": "万柏林区"}, {"label": "晋源区", "value": "晋源区"},
#                              {"label": "清徐县", "value": "清徐县"}, {"label": "阳曲县", "value": "阳曲县"},
#                              {"label": "娄烦县", "value": "娄烦县"}, {"label": "古交市", "value": "古交市"}],
#                 # "district": [{"label": "小店区", "value": ""}, {"label": "迎泽区", "value": 2},
#                 #              {"label": "杏花岭区", "value": 3}, {"label": "尖草坪区", "value": 4},
#                 #              {"label": "万柏林区", "value": 5}, {"label": "晋源区", "value": 6},
#                 #              {"label": "清徐县", "value": 7}, {"label": "阳曲县", "value": 8},
#                 #              {"label": "娄烦县", "value": 9}, {"label": "古交市", "value": 10}]
#                 }
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库查询错误")
#     return jsonify(code=RET.OK, msg="获取成功", options=data)
#
#
# # 行业信息总览
# @api_atlas.route('/industry/overview', methods=['POST'])
# # @login_required
# def overview():
#     '''太原市行业信息总览'''
#     req_dict = request.get_json()
#     inid = req_dict.get("inid")  # 行业id
#     cate = req_dict.get("cate")  # 行业等级,（高端设备等五个为"1",子行业为"2"）
#
#     entype = req_dict.get("entype")  # 企业类型id
#     qualificat = req_dict.get("qualificat")  # 企业资质id
#     capital = req_dict.get("capital")  # 注册资本id
#     quoted = req_dict.get("quoted")  # 上市板块
#     district = req_dict.get("district")  # 太原市下区县
#     yearid = req_dict.get("yearid")  # 成立时间年限id
#     roundid = req_dict.get("roundid")  # 融资轮次id(天使/种子，1)（PreA/A+,2）（PreB/B+,3）(C轮以上，4)（收并购，5）（战略投资，6）（其他，7）
#     product = req_dict.get("product")  # 产业产品选择
#
#     # 校验参数完整性
#     if not all([inid, cate]):
#         return jsonify(code=RET.PARAMERR, msg="参数不完整")
#
#     try:
#         if cate == "1":
#             company = Company.query.filter_by(f_type=inid, city="太原市")
#         else:
#             company = Company.query.filter_by(c_type=inid, city="太原市")
#         # 企业类型
#         if entype:
#             company = company.filter_by(entypeid=entype)
#         # 企业资质
#         if qualificat:
#             if qualificat == 1:
#                 company = company.filter_by(high_new=1)
#             if qualificat == 2:
#                 company = company.filter_by(tbe=1)
#             if qualificat == 3:
#                 company = company.filter_by(quoted_company=1)
#             if qualificat == 4:
#                 company = company.filter_by(sxonhun=1)
#             if qualificat == 5:
#                 company = company.filter_by(isfive=1)
#             if qualificat == 6:
#                 company = company.filter_by(unicorn=1)
#             if qualificat == 7:
#                 company = company.filter_by(dengl=1)
#             if qualificat == 8:
#                 company = company.filter_by(zjtg=1)
#             if qualificat == 9:
#                 company = company.filter_by(scale=1)
#             if qualificat == 10:
#                 company = company.filter_by(serve=1)
#         # 注册资本
#         if capital:
#             company = company.filter_by(capital_id=capital)
#         # 上市板块
#         if quoted:
#             company = company.filter_by(public_id=quoted)
#         # 区域选择
#         if district:
#             company = company.filter_by(district=district)
#         # 成立时间id
#         if yearid:
#             company = company.filter_by(yearid=yearid)
#         # 融资轮次
#         if roundid:
#             company = company.filter_by(roundid=roundid)
#         if product:
#             company = Company.query.filter(Company.product_all.like("%{}%".format(product)))
#         coms = company.count()  # 企业总数
#         capital = round(float(company.with_entities(func.sum(Company.capital_nums)).scalar() if company.with_entities(
#             func.sum(Company.capital_nums)).scalar() else 0) / 10000, 2)  # 注册资本单位万
#         taking = round(float(company.with_entities(func.sum(Company.takingn)).scalar() if company.with_entities(
#             func.sum(Company.takingn)).scalar() else 0) / 10000, 2)  # 营收
#         profit = round(float(company.with_entities(func.sum(Company.profit)).scalar() if company.with_entities(
#             func.sum(Company.profit)).scalar() else 0) / 10000, 2)  # 利润
#         # profit = "0"  # 利润
#         pnums = round(float(company.with_entities(func.sum(Company.bao_num)).scalar() if company.with_entities(
#             func.sum(Company.bao_num)).scalar() else 0))  # 参保人数
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库查询错误")
#
#     data = {"coms": str(coms) + "户", "capital": str(capital) + "亿", "taking": str(taking) + "亿",
#             "pnums": str(pnums) + "人", "profit": str(profit) + "亿"}
#
#     return jsonify(code=RET.OK, msg="获取成功", data=data)
#
#
# # 太原市企业年度柱状图
# @api_atlas.route('/industry/statistics', methods=['POST'])
# # @login_required
# def statistics():
#     '''太原市企业年度柱状图'''
#     req_dict = request.get_json()
#     inid = req_dict.get("inid")  # 行业id
#     cate = req_dict.get("cate")  # 行业等级,（高端设备等五个为"1",子行业为"2"）
#
#     entype = req_dict.get("entype")  # 企业类型id
#     qualificat = req_dict.get("qualificat")  # 企业资质id
#     capital = req_dict.get("capital")  # 注册资本id
#     quoted = req_dict.get("quoted")  # 上市板块
#     district = req_dict.get("district")  # 太原市下区县
#     yearid = req_dict.get("yearid")  # 成立时间年限id
#     roundid = req_dict.get("roundid")  # 融资轮次id(天使/种子，1)（PreA/A+,2）（PreB/B+,3）(C轮以上，4)（收并购，5）（战略投资，6）（其他，7）
#     product = req_dict.get("product")  # 产业产品选择
#
#     # 校验参数完整性
#     if not all([inid, cate]):
#         return jsonify(code=RET.PARAMERR, msg="参数不完整")
#
#     try:
#         if cate == "1":
#             company = Company.query.filter_by(f_type=inid, city="太原市")
#         else:
#             company = Company.query.filter_by(c_type=inid, city="太原市")
#         # 企业类型
#         if entype:
#             company = company.filter_by(entypeid=entype)
#         # 企业资质
#         if qualificat:
#             if qualificat == 1:
#                 company = company.filter_by(high_new=1)
#             if qualificat == 2:
#                 company = company.filter_by(tbe=1)
#             if qualificat == 3:
#                 company = company.filter_by(public_sector=1)
#             if qualificat == 4:
#                 company = company.filter_by(sxonhun=1)
#             if qualificat == 5:
#                 company = company.filter_by(isfive=1)
#             if qualificat == 6:
#                 company = company.filter_by(unicorn=1)
#             if qualificat == 7:
#                 company = company.filter_by(dengl=1)
#             if qualificat == 8:
#                 company = company.filter_by(zjtg=1)
#             if qualificat == 9:
#                 company = company.filter_by(scale=1)
#             if qualificat == 10:
#                 company = company.filter_by(serve=1)
#         # 注册资本
#         if capital:
#             company = company.filter_by(capital_id=capital)
#         # 上市板块
#         if quoted:
#             company = company.filter_by(public_id=quoted)
#         # 区域选择
#         if district:
#             company = company.filter_by(district=district)
#         # 成立时间id
#         if yearid:
#             company = company.filter_by(yearid=yearid)
#         # 融资轮次
#         if roundid:
#             company = company.filter_by(roundid=roundid)
#         if product:
#             company = company.filter(Company.product_all.like("%{}%".format(product)))
#         yearn = datetime.now().year
#         data = {"register": [], "cpital": []}
#         for year in [str(y) for y in range(yearn - 4, yearn + 1)]:
#             data["register"].append(
#                 {"year": year, "value": company.filter(extract("year", Company.build_date) == year).count()})
#             v = company.filter(extract("year", Company.build_date) == year).with_entities(
#                 func.sum(Company.capital_nums)).scalar()
#             data["cpital"].append({"year": year, "value": round(float(v), 2) if v else 0})
#
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库查询错误")
#
#     return jsonify(code=RET.OK, msg="获取成功", data=data)
#
#
# # 太原市创新资源机构类型筛选条件
# @api_atlas.route('/innovate/fields', methods=['GET'])
# def org_field():
#     '''创新资源机构列表'''
#     # data = {"class": [{"label": "高等院校", "value": 1}, {"label": "科研机构", "value": 2},
#     #                   {"label": "创新平台", "value": 3}, {"label": "产业服务平台", "value": 4}],
#     #         "college": [{"label": "全部", "value": ""}, {"label": "211工程院校", "value": 1},
#     #                     {"label": "普通本科", "value": 2}, {"label": "高职高专", "value": 3}],
#     #         "scenice": [],
#     #         "creative": [{"label": "全部", "value": ""}, {"label": "工程技术中心", "value": 1},
#     #                      {"label": "国际科技合作基地", "value": 2},
#     #                      {"label": "企业技术中心", "value": 3}, {"label": "双创基地", "value": 4},
#     #                      {"label": "院士工作站", "value": 5}, {"label": "质量检测与测量中心", "value": 6},
#     #                      {"label": "重点实验室", "value": 7}],
#     #         "induserve": [{"label": "全部", "value": ""}, {"label": "产业联盟", "value": 1},
#     #                       {"label": "公共服务平台", "value": 2}, {"label": "行业协会", "value": 3}]
#     #         }
#
#     data = {"class": [{"label": "高等院校", "value": 1}, {"label": "科研机构", "value": 2},
#                       {"label": "创新平台", "value": 3}, {"label": "产业服务平台", "value": 4}],
#             "college": [{"label": "全部", "value": ""}, {"label": "211工程院校", "value": 1},
#                         {"label": "普通本科", "value": 2}, {"label": "高职高专", "value": 3}],
#             "scenice": [],
#             "creative": [{"label": "全部", "value": ""}, {"label": "工程技术中心", "value": 1},
#                          {"label": "国际科技合作基地", "value": 2},
#                          {"label": "企业技术中心", "value": 3}, {"label": "双创基地", "value": 4},
#                          {"label": "重点实验室", "value": 7}],
#             "induserve": [{"label": "全部", "value": ""}, {"label": "产业联盟", "value": 1},
#                           {"label": "公共服务平台", "value": 2}, {"label": "行业协会", "value": 3},
#                           {"label": "院士工作站", "value": 4}, {"label": "质量检测与测量中心", "value": 5}]
#             }
#
#     return jsonify(code=RET.OK, msg="查询成功", options=data)
#
#
# # 太原市创新资源机构分布图
# @api_atlas.route('/innovate/distribute', methods=['POST'])
# # @login_required
# def innovate_distribute():
#     '''创新资源机构分布'''
#     req_dict = request.get_json()
#     inid = req_dict.get("inid")  # 行业id
#     cate = req_dict.get("cate")  # 行业等级,（高端设备等五个为"1",子行业为"2"）
#     district = req_dict.get("district")  # 区县
#
#     # 校验参数完整性
#     if not all([inid, cate]):
#         return jsonify(code=RET.PARAMERR, msg="参数不完整")
#     try:
#         name = Industry.query.filter_by(nid=inid).first().oname  # 真名
#         orgs = Orgs.query.with_entities(Orgs.category).distinct().all()
#         category = [i[0] for i in orgs]  # 拿到类型的无重复值
#         data = []
#         if cate == "1":  # f_type
#             if district:
#                 orgs = Orgs.query.filter_by(admin=district).filter(Orgs.navigator.like("%{}%".format(name)))
#             else:
#                 orgs = Orgs.query.filter(Orgs.navigator.like("%{}%".format(name)))
#             for cate in category:
#                 nums = orgs.filter_by(category=cate).count()
#                 data.append({"label": cate, "value": nums})
#         else:
#             if district:
#                 orgs = Orgs.query.filter_by(admin=district).filter(Orgs.navigat.like("%{}%".format(name)))
#             else:
#                 orgs = Orgs.query.filter(Orgs.navigat.like("%{}%".format(name)))
#             for cate in category:
#                 nums = orgs.filter_by(category=cate).count()
#                 data.append({"label": cate, "value": nums})
#         return jsonify(code=RET.OK, msg="查询成功", data=data)
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库查询错误")
#
#
# # 太原市创新资源机构列表（高等院校和告高职转告合并，高职专高作为第二分类，合并两个表）
# @api_atlas.route('/innovate/orgs', methods=['POST'])
# # @login_required
# def orgs():
#     '''创新资源机构列表'''
#     req_dict = request.get_json()
#     inid = req_dict.get("inid")  # 行业id
#     cate = req_dict.get("cate")  # 行业等级,（高端设备等五个为"1",子行业为"2"）
#
#     cateone = req_dict.get("cateone")  # 机构类型id. 高等院校1,科研机构2，创新平台3，产业服务平台4
#     catetwo = req_dict.get("catetwo")  # 机构类型2 id
#     product = req_dict.get("product")  # 产品
#
#     page = req_dict.get("page")  # 分页页码
#     perpage = req_dict.get("perpage")  # 分页大小
#
#     # 校验参数完整性
#     if not all([inid, cate, cateone, page, perpage]):
#         return jsonify(code=RET.PARAMERR, msg="参数不完整")
#
#     name = Industry.query.filter_by(nid=inid).first().oname
#
#     if cateone == 1:  # 高等院校
#         try:
#             if cate == "1":
#                 college = College.query.filter(College.navigator.like("%{}%".format(name)))
#             else:
#                 college = College.query.filter(College.navigat.like("%{}%".format(name)))
#             if catetwo:
#                 college = college.filter_by(cateid=catetwo)
#             if product:
#                 college = college.filter(College.research.like("%{}%".format(product)))
#             size = college.count()
#             college = college.paginate(page, perpage).items
#
#             data = {"df": [{"id": i.id,
#                             "name": i.name,
#                             "cate": i.category,
#                             "cateone": cateone} for i in college],
#                     "size": size}
#             return jsonify(code=RET.OK, msg="查询成功", data=data)
#         except Exception as e:
#             current_app.logger.error(e)
#             return jsonify(code=RET.DATAERR, msg="参数错误")
#     elif cateone == 2:  # 科研机构
#         if cate == "1":
#             scientific = Scientific.query.filter(Scientific.navigator.like("%{}%".format(name)))
#         else:
#             scientific = Scientific.query.filter(Scientific.navigat.like("%{}%".format(name)))
#         if product:
#             scientific = scientific.filter(Scientific.research.like("%{}%".format(product)))
#         size = scientific.count()
#         scientific = scientific.paginate(page, perpage).items
#         data = {"df": [{"id": i.id,
#                         "name": i.name,
#                         "cate": "科研机构",
#                         "cateone": cateone} for i in scientific],
#                 "size": size}
#         return jsonify(code=RET.OK, msg="查询成功", data=data)
#     elif cateone == 3:  # 创新平台3
#         if cate == "1":
#             lab = Lab.query.filter(Lab.navigator.like("%{}%".format(name)))
#         else:
#             lab = Lab.query.filter(Lab.navigat.like("%{}%".format(name)))
#         if catetwo:
#             lab = lab.filter_by(cateid=catetwo)
#         if product:
#             lab = lab.filter(Lab.research.like("%{}%".format(product)))
#         size = lab.count()
#         lab = lab.paginate(page, perpage).items
#         data = {"df": [{"id": i.id,
#                         "name": i.name,
#                         "cate": i.cate,
#                         "cateone": cateone} for i in lab],
#                 "size": size}
#         return jsonify(code=RET.OK, msg="查询成功", data=data)
#     elif cateone == 4:  # 产业服务平台
#         if cate == "1":
#             platform = Platform.query.filter(Platform.navigator.like("%{}%".format(name)))
#         else:
#             platform = Platform.query.filter(Platform.navigat.like("%{}%".format(name)))
#         if catetwo:
#             platform = platform.filter_by(cateid=catetwo)
#         if product:
#             platform = platform.filter(Platform.research.like("%{}%".format(product)))
#         size = platform.count()
#         platform = platform.paginate(page, perpage).items
#         data = {"df": [{"id": i.id,
#                         "name": i.name,
#                         "cate": i.cate,
#                         "cateone": cateone} for i in platform],
#                 "size": size}
#         return jsonify(code=RET.OK, msg="查询成功", data=data)
#
#     else:
#         return jsonify(code=RET.PARAMERR, msg="参数错误")
#
#
# # 产业发展图谱资源机构页面的散点图地图
# @api_atlas.route('/orgs/sdmap', methods=['POST'])
# # @login_required
# def orgs_sdmap():
#     req_dict = request.get_json()
#     inid = req_dict.get("inid")  # 行业id
#     cate = req_dict.get("cate")  # 行业等级,（高端设备等五个为"1",子行业为"2"）
#
#     cateone = req_dict.get("cateone")  # 机构类型id. 高等院校1,科研机构2，创新平台3，产业服务平台4
#     catetwo = req_dict.get("catetwo")  # 机构类型2 id
#     product = req_dict.get("product")  # 产品
#
#     page = req_dict.get("page")  # 分页页码
#     perpage = req_dict.get("perpage")  # 分页大小
#
#     # 校验参数完整性
#     if not all([inid, cate, cateone]):
#         return jsonify(code=RET.PARAMERR, msg="参数不完整")
#
#     name = Industry.query.filter_by(nid=inid).first().oname
#
#     if cateone == 1:  # 高等院校
#         try:
#             if cate == "1":
#                 college = College.query.filter(College.navigator.like("%{}%".format(name)))
#             else:
#                 college = College.query.filter(College.navigat.like("%{}%".format(name)))
#             if catetwo:
#                 college = college.filter_by(cateid=catetwo)
#             if product:
#                 college = college.filter(College.research.like("%{}%".format(product)))
#
#             college = college.paginate(page, perpage).items
#
#             data = [{"id": com.id,
#                      "name": com.name,
#                      "jwd": {"lng": com.lng,  # 园区地址出的经纬度
#                              "lat": com.lat}
#                      } for com in college]
#
#             return jsonify(code=RET.OK, msg="查询成功", data=data)
#         except Exception as e:
#             current_app.logger.error(e)
#             return jsonify(code=RET.DATAERR, msg="参数错误")
#     elif cateone == 2:  # 科研机构
#         if cate == "1":
#             scientific = Scientific.query.filter(Scientific.navigator.like("%{}%".format(name)))
#         else:
#             scientific = Scientific.query.filter(Scientific.navigat.like("%{}%".format(name)))
#         if product:
#             scientific = scientific.filter(Scientific.research.like("%{}%".format(product)))
#
#         scientific = scientific.paginate(page, perpage).items
#         data = [{"id": com.id,
#                  "name": com.name,
#                  "jwd": {"lng": com.lng,  # 园区地址出的经纬度
#                          "lat": com.lat}
#                  } for com in scientific]
#         return jsonify(code=RET.OK, msg="查询成功", data=data)
#     elif cateone == 3:  # 创新平台3
#         if cate == "1":
#             lab = Lab.query.filter(Lab.navigator.like("%{}%".format(name)))
#         else:
#             lab = Lab.query.filter(Lab.navigat.like("%{}%".format(name)))
#         if catetwo:
#             lab = lab.filter_by(cateid=catetwo)
#         if product:
#             lab = lab.filter(Lab.research.like("%{}%".format(product)))
#
#         lab = lab.paginate(page, perpage).items
#         data = [{"id": com.id,
#                  "name": com.name,
#                  "jwd": {"lng": com.lng,  # 园区地址出的经纬度
#                          "lat": com.lat}
#                  } for com in lab]
#
#         return jsonify(code=RET.OK, msg="查询成功", data=data)
#     elif cateone == 4:  # 产业服务平台
#         if cate == "1":
#             platform = Platform.query.filter(Platform.navigator.like("%{}%".format(name)))
#         else:
#             platform = Platform.query.filter(Platform.navigat.like("%{}%".format(name)))
#         if catetwo:
#             platform = platform.filter_by(cateid=catetwo)
#         if product:
#             platform = platform.filter(Platform.research.like("%{}%".format(product)))
#
#         platform = platform.paginate(page, perpage).items
#         data = [{"id": com.id,
#                  "name": com.name,
#                  "jwd": {"lng": com.lng,  # 园区地址出的经纬度
#                          "lat": com.lat}
#                  } for com in platform]
#
#         return jsonify(code=RET.OK, msg="查询成功", data=data)
#
#     else:
#         return jsonify(code=RET.PARAMERR, msg="参数错误")
#
#
# # 太原园区列表及所有园区的数量及面积（默认全部）
# @api_atlas.route('/carrier/garden', methods=['POST'])
# # @login_required
# def garden():
#     '''创新资源机构列表'''
#     req_dict = request.get_json()
#     inid = req_dict.get("inid")  # 行业id
#     cate = req_dict.get("cate")  # 行业等级,（高端设备等五个为"1",子行业为"2"）
#
#     page = req_dict.get("page")  # 分页页码
#     perpage = req_dict.get("perpage")  # 分页大小
#
#     keyword = req_dict.get("keyword")  # 搜索园区姓名
#     level = req_dict.get("level")  # 园区级别
#
#     # 校验参数完整性
#     if not all([page, perpage]):
#         return jsonify(code=RET.PARAMERR, msg="参数不完整")
#
#     try:
#         if inid:
#             name = Industry.query.filter_by(nid=inid).first().oname  # 获取导航对应的真名
#             if cate == "1":
#                 induzone = Induzone.query.filter(Induzone.navigator.like("%{}%".format(name)))
#             else:
#                 induzone = Induzone.query.filter(Induzone.navigat.like("%{}%".format(name)))
#         else:
#             induzone = Induzone.query.filter_by()
#         if keyword:
#             induzone = induzone.filter(Induzone.name.like("%{}%".format(keyword)))  # 查询词
#         if level:
#             induzone = induzone.filter_by(level=level)  # 园区级别筛选
#         # count = induzone.count()  # 园区总数
#         count_x = induzone.filter_by(cate="行政区").count()  # 园区总数
#         count_y = induzone.filter_by(cate="产业园区").count()  # 产业园区总数
#         # areas = induzone.with_entities(func.sum(Induzone.area)).scalar()  # 园区总面积
#         size = induzone.count()  # 分页总数
#         induzone = induzone.paginate(page, perpage).items
#
#         data = {"garden": [{"id": i.id,
#                             "name": i.name,
#                             "level": i.level if i.level else "",
#                             "cate": i.cate if i.cate else "",
#                             "cluster": i.cluster if i.cluster else ""} for i in induzone],
#                 "size": size,
#                 # "df": {"count": count,
#                 #        "areas": round(areas, 2) if areas else "-"},
#                 "df": {"count_x": count_x,  # 行政区数
#                        "count_y": count_y}  # 园区数
#                 }
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库查询错误")
#
#     return jsonify(code=RET.OK, msg="查询成功", data=data)
#
#
# # 太原园区列表及所有园区的数量及面积（默认全部）
# @api_atlas.route('/carrier/gardens', methods=['POST'])
# def gardens():
#     '''创新资源机构列表'''
#     req_dict = request.get_json()
#     inid = req_dict.get("inid")  # 行业id
#     cate = req_dict.get("cate")  # 行业等级,（高端设备等五个为"1",子行业为"2"）
#
#     page = req_dict.get("page")  # 分页页码
#     perpage = req_dict.get("perpage")  # 分页大小
#
#     keyword = req_dict.get("keyword")  # 搜索园区姓名
#     level = req_dict.get("level")  # 园区级别
#     clasify = req_dict.get("clasify")  # 园区类别，行政区、产业园区
#     # 校验参数完整性
#     if not all([page, perpage, clasify]):
#         return jsonify(code=RET.PARAMERR, msg="参数不完整")
#
#     try:
#         if inid:
#             name = Industry.query.filter_by(nid=inid).first().oname  # 获取导航对应的真名
#             if cate == "1":
#                 induzone = Induzone.query.filter(Induzone.navigator.like("%{}%".format(name)))
#             else:
#                 induzone = Induzone.query.filter(Induzone.navigat.like("%{}%".format(name)))
#         else:
#             induzone = Induzone.query.filter_by()
#         if level:
#             induzone = induzone.filter_by(level=level)  # 园区级别筛选
#
#         count_x = induzone.filter_by(cate="行政区").count()  # 园区总数
#         count_y = induzone.filter_by(cate="产业园区").count()  # 产业园区总数
#
#         if clasify == "行政区":
#             induzone = induzone.filter_by(cate="行政区")
#         elif clasify == "产业园区":
#             induzone = induzone.filter_by(cate="产业园区")
#
#         if keyword:
#             # induzone = induzone.filter(Induzone.name.like("%{}%".format(keyword)))  # 查询词
#             induzone = Induzone.query.filter(Induzone.name.like("%{}%".format(keyword)))  # 查询词
#         size = induzone.count()  # 分页总数
#         induzone = induzone.paginate(page, perpage).items
#
#         data = {"garden": [{"id": i.id,
#                             "name": i.name,  # 园区名
#                             "level": i.level if i.level else "",  # 园区级别
#                             "cate": i.cate if i.cate else "",  # 园区类型
#                             "cluster": i.cluster if i.cluster else "",  # 产业集群
#                             "address": i.address if i.address else "",  # 园区地址
#                             "area": str(i.area) + "平方公里" if i.area else "",  # 园区面积
#                             } for i in induzone],
#                 "size": size,
#                 "df": {"count_x": count_x,  # 行政区数
#                        "count_y": count_y}  # 园区数
#                 }
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库查询错误")
#
#     return jsonify(code=RET.OK, msg="查询成功", data=data)
#
#
# # 产业发展图谱产业载体园区的散点图地图(2020-11-7)
# @api_atlas.route('/zone/sdmap', methods=['POST'])
# # @login_required
# def zone_sdmap():
#     req_dict = request.get_json()
#     inid = req_dict.get("inid")  # 行业id
#     cate = req_dict.get("cate")  # 行业等级,（高端设备等五个为"1",子行业为"2"）
#
#     page = req_dict.get("page")  # 分页页码
#     perpage = req_dict.get("perpage")  # 分页大小
#
#     keyword = req_dict.get("keyword")  # 搜索园区姓名
#     level = req_dict.get("level")  # 园区级别
#     clasify = req_dict.get("clasify")  # 园区类别，行政区、产业园区
#     # 校验参数完整性
#     if not all([page, perpage]):
#         return jsonify(code=RET.PARAMERR, msg="参数不完整")
#
#     try:
#         if inid:
#             name = Industry.query.filter_by(nid=inid).first().oname  # 获取导航对应的真名
#             if cate == "1":
#                 induzone = Induzone.query.filter(Induzone.navigator.like("%{}%".format(name)))
#             else:
#                 induzone = Induzone.query.filter(Induzone.navigat.like("%{}%".format(name)))
#         else:
#             induzone = Induzone.query.filter_by()
#         if keyword:
#             induzone = induzone.filter(Induzone.name.like("%{}%".format(keyword)))  # 查询词
#         if level:
#             induzone = induzone.filter_by(level=level)  # 园区级别筛选
#         if clasify == "行政区":
#             induzone = induzone.filter_by(cate="行政区")
#         elif clasify == "产业园区":
#             induzone = induzone.filter_by(cate="产业园区")
#         induzone = induzone.paginate(page, perpage).items
#
#         data = [{"id": com.id,
#                  "name": com.name,
#                  "jwd": {"lng": com.lng,  # 园区地址出的经纬度
#                          "lat": com.lat}
#                  } for com in induzone]
#
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库查询错误")
#
#     return jsonify(code=RET.OK, msg="查询成功", data=data)
#
#
# '''产业下企业、资源机构及园区的色块图、散点图'''
#
#
# # 按数量进行颜色的选择
# def jisuan(num):
#     if num >= 0 and num <= 10:
#         return "#72D4F1"
#     if num > 10 and num <= 30:
#         return "#00BAF6"
#     if num > 30 and num <= 50:
#         return "#4F9FFF"
#     if num > 50 and num <= 100:
#         return "#4265F6"
#     if num > 100 and num <= 200:
#         return "#0052d6"
#     if num > 200:
#         return "#0245AE"
#
#
# # 产业发展图谱企业页面太原市的色块图地图(2020-11-7)
# @api_atlas.route('/enterprise/piecemap', methods=['POST'])
# # @login_required
# def enterprise_piecemap():
#     '''获取太原市下区县企业数量色块图'''
#     req_dict = request.get_json()
#     inid = req_dict.get("inid")  # 行业id
#     cate = req_dict.get("cate")  # 行业等级,
#
#     if cate != "1":
#         return jsonify(code=RET.PARAMERR, msg="参数错误")
#     try:
#         district = Company.query.filter_by(city="太原市").with_entities(Company.district).distinct().all()
#         # print(district)
#         district = [i[0] for i in district]  # 拿到区县的无重复值
#         company = Company.query.filter_by(city="太原市", f_type=inid)
#         # 太原市经纬度
#         tyjwd = [112.549, 37.957]
#         df = list()
#         for dis in district:
#             data_district = company.filter_by(district=dis)
#             com = Company.query.filter_by(city="太原市", district=dis).first()
#             df.append({"name": dis,
#                        "value": data_district.count(),
#                        "jwd": {"lng": com.d_lng, "lat": com.d_lat},  # 区县的经纬度
#                        "color": jisuan(data_district.count())})
#         data = {"ty": tyjwd, "df": df}
#         return jsonify(code=RET.OK, msg="查询成功", data=data)
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库查询错误")
#
#
# # 企业坐标图例
# def get_color(s):
#     iphost = "http://39.100.39.50:8006"
#     # iphost = "192.168.1.127:5000"
#     if s == "上游":
#         return "{}/static/legend/red.png".format(iphost)
#     if s == "中游":
#         return "{}/static/legend/bule.png".format(iphost)
#     if s == "下游":
#         return "{}/static/legend/yellow.png".format(iphost)
#     return "{}/static/legend/green.png".format(iphost)
#
#
# # 产业发展图谱企业页面的散点图地图(2020-11-7)
# @api_atlas.route('/enterprise/sdmap', methods=['POST'])
# # @login_required
# def enterprise_sdmap():
#     '''产业发展图谱企业页面的散点图地图,1级导航必须有区县，2级导航可有可无'''
#     req_dict = request.get_json()
#     inid = req_dict.get("inid")  # 行业id
#     cate = req_dict.get("cate")  # 行业等级,
#     district = req_dict.get("district")  # 区县
#     product = req_dict.get("product")  # 产品
#
#     try:
#         if cate != "2" and district == "":
#             return jsonify(code=RET.PARAMERR, msg="参数错误le")
#         if cate == "1":  # 一级导航
#             company = Company.query.filter_by(city="太原市", f_type=inid)
#             if product:
#                 company = company.filter(Company.product_all.like("%{}%".format(product)))
#             if district:
#                 company = company.filter_by(district=district)
#             company = company.all()
#             data = []
#             for com in company:
#                 data.append({"id": com.id,
#                              "name": com.company_name,
#                              "jwd": {"lng": com.lng,  # 企业地址出的经纬度
#                                      "lat": com.lat},
#                              "stream": get_color(com.stream)})  # 上下中游
#             return jsonify(code=RET.OK, msg="查询成功", data=data)
#         if cate == "2":  # 二级导航
#             company = Company.query.filter_by(city="太原市", c_type=inid)
#             if product:
#                 company = company.filter(Company.product_all.like("%{}%".format(product)))
#             if district:
#                 company = company.filter_by(district=district)
#             company = company.all()
#             data = []
#             for com in company:
#                 data.append({"id": com.id,
#                              "name": com.company_name,
#                              "jwd": {"lng": com.lng,  # 企业地址出的经纬度
#                                      "lat": com.lat},
#                              "stream": get_color(com.stream)})  # 上下中游
#             return jsonify(code=RET.OK, msg="查询成功", data=data)
#         else:
#             return jsonify(code=RET.PARAMERR, msg="参数错误")
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库查询错误")
#
# # # 产业发展图谱资源机构页面的散点图地图
# # @api_atlas.route('/orgs/sdmap', methods=['POST'])
# # # @login_required
# # def orgs_sdmap():
# #     '''产业发展图谱资源机构页面的散点图地图'''
# #     req_dict = request.get_json()
# #     inid = req_dict.get("inid")  # 行业id
# #     cate = req_dict.get("cate")  # 行业等级,
# #     district = req_dict.get("district")  # 区县
# #     product = req_dict.get("product")  # 产品-research
# #
# #     try:
# #         name = Industry.query.filter_by(nid=inid, statu=1).first().oname
# #         if cate == "1":
# #             orgs = Orgs.query.filter(Orgs.navigator.like("%{}%".format(name)))
# #         else:
# #             orgs = Orgs.query.filter(Orgs.navigat.like("%{}%".format(name)))
# #         if product:
# #             orgs = Orgs.query.filter(Orgs.research.like("%{}%".format(product)))
# #         if district:
# #             orgs = orgs.filter_by(admin=district)
# #         orgs = orgs.all()
# #         data = []
# #         for com in orgs:
# #             data.append({"id": com.id,
# #                          "name": com.name,
# #                          "jwd": {"lng": com.lng,  # 园区地址出的经纬度
# #                                  "lat": com.lat}
# #                          })
# #
# #     except Exception as e:
# #         current_app.logger.error(e)
# #         return jsonify(code=RET.DBERR, msg="数据库查询错误")
# #     return jsonify(code=RET.OK, msg="查询成功", data=data)
#
# #
# # # 产业发展图谱产业载体园区的散点图地图(2020-11-7)
# # @api_atlas.route('/zone/sdmap', methods=['POST'])
# # # @login_required
# # def zone_sdmap():
# #     '''产业发展图谱产业载体页面的散点图地图'''
# #     req_dict = request.get_json()
# #     inid = req_dict.get("inid")  # 行业id
# #     cate = req_dict.get("cate")  # 行业等级,
# #     district = req_dict.get("district")  # 区县
# #
# #     try:
# #         name = Industry.query.filter_by(nid=inid, statu=1).first().oname
# #         if cate == "1":
# #             induzone = Induzone.query.filter(Induzone.navigator.like("%{}%".format(name)))
# #         else:
# #             induzone = Induzone.query.filter(Induzone.navigat.like("%{}%".format(name)))
# #         if district:
# #             induzone = induzone.filter_by(region=district)
# #
# #         induzone = induzone.all()
# #
# #         data = []
# #         for com in induzone:
# #             data.append({"id": com.id,
# #                          "name": com.name,
# #                          "jwd": {"lng": com.lng,  # 园区地址出的经纬度
# #                                  "lat": com.lat}
# #                          })
# #
# #     except Exception as e:
# #         current_app.logger.error(e)
# #         return jsonify(code=RET.DBERR, msg="数据库查询错误")
# #     return jsonify(code=RET.OK, msg="查询成功", data=data)
