import re

import requests
from flask import current_app, request, jsonify
from apps.view_radar import api_radar
from apps.models import *
from sqlalchemy import extract, or_, and_
from sqlalchemy.sql import func
from apps.util import login_required, create_token, verify_token
from apps.utils.response_code import RET
from datetime import datetime
import datetime
from apps import db, constants, redis_store
from apps.utils.neo4j_conn import conn_neo4j

from apps.view_xiaocx import api_xiaocx


# 首页搜索
from apps.utils.vxconfig import WxConfig


@api_xiaocx.route('/IndexSearch', methods=['POST'])
# @login_required
def index_search():
    req_dict = request.get_json()
    carrier_type = req_dict.get("carrier_type")  # 载体类型 1地块，2楼宇，3厂房，4园区，5项目
    carrier_name = req_dict.get("carrier_name")  # 载体名称
    district = req_dict.get("district")  # 所属区县
    industry = req_dict.get("industry")  # 产业类型
    investment_volume_list = req_dict.get("investment_volume_list")  # 投资额区间 [1, 0-0.5]

    nature = req_dict.get("nature")  # 土地性质
    area = req_dict.get("area")  # 土地面积 [10, 20 ]

    build_area = req_dict.get("build_area")  # 建筑面积 [0, 10000]
    rent_money = req_dict.get("rent_money")  # 租金 [0, 1.5]

    zone_level = req_dict.get("zone_level")  # 园区级别

    page = req_dict.get("page")  # page
    perpage = req_dict.get("perpage")  # perpage
    data = []
    try:
        if carrier_type == 1:
            land_obj_list = CarrierLand.query.filter(
                CarrierLand.land_name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                CarrierLand.land_nature == nature if nature else text(''),
                CarrierLand.total_area > float(area[0]) if area[0] else text(''),
                CarrierLand.total_area <= float(area[1]) if area[1] else text(''),
            ).paginate(page, perpage).items

            data = [{
                "id": land_obj.id,
                "name": land_obj.land_name,
                "district": land_obj.district_name,
                "nature": land_obj.land_nature,
                "area": land_obj.total_area,
                "lng": land_obj.lng,
                "lat": land_obj.lat,
            } for land_obj in land_obj_list]

        if carrier_type == 2:
            build_obj_list = CarrierBuild.query.filter(
                CarrierBuild.build_name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                CarrierBuild.attract_status == industry if industry else text(''),
                CarrierBuild.build_area > build_area[0] if build_area[0] else text(''),
                CarrierBuild.build_area <= build_area[1] if build_area[1] else text(''),
                CarrierBuild.rent_money > rent_money[0] if rent_money[0] else text(''),
                CarrierBuild.rent_money <= rent_money[1] if rent_money[1] else text('')
            ).paginate(page, perpage).items

            data = [{
                "id": build_obj.id,
                "name": build_obj.build_name,
                "district": build_obj.district_name,
                "rent": build_obj.rent_money,
                "area": build_obj.build_area,
                "lng": build_obj.lng,
                "lat": build_obj.lat,
            } for build_obj in build_obj_list]

        if carrier_type == 3:
            factory_obj_list = CarrierFactory.query.filter(
                CarrierFactory.factory_name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                CarrierFactory.attract_status == industry if industry else text(''),
                CarrierFactory.factory_area > build_area[0] if build_area[0] else text(''),
                CarrierFactory.factory_area <= build_area[1] if build_area[1] else text('')
            ).paginate(page, perpage).items

            data = [{
                "id": factory_obj.id,
                "name": factory_obj.factory_name,
                "district": factory_obj.district_name,
                "attract_industry": factory_obj.attract_status,
                "area": factory_obj.factory_area,
                "lng": factory_obj.lng,
                "lat": factory_obj.lat,
            } for factory_obj in factory_obj_list]

        if carrier_type == 4:  # 园区
            zone_obj_list = Induzone.query.filter(
                Induzone.name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                Induzone.navigat == industry if industry else text(''),
                Induzone.level == zone_level if zone_level else text('')
            ).paginate(page, perpage).items

            data = [{
                "id": zone_obj.id,
                "name": zone_obj.name,
                "phone": zone_obj.phone,
                "industry_position": zone_obj.industry_position,
                "district": zone_obj.district,
                "lng": zone_obj.lng,
                "lat": zone_obj.lat,
            } for zone_obj in zone_obj_list]

        if carrier_type == 5:  # 项目
            project_obj_list = Project.query.filter(
                Project.name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                Project.district == district if district else text(''),
                Project.industry == industry if industry else text(''),

                Project.money > float(investment_volume_list[0]) * 10000 if investment_volume_list[0] else text(''),
                Project.money <= float(investment_volume_list[1]) * 10000 if investment_volume_list[1] else text(''),
            ).paginate(page, perpage).items

            data = [{
                "id": project_obj.id,
                "name": project_obj.name,
                "district": project_obj.district,
                "money": project_obj.money,
                "attract_industry": project_obj.attract_industry,
                # "lng": project_obj.lng,
                # "lat": project_obj.lat,
            } for project_obj in project_obj_list]
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="查询出错！")
    return jsonify(code=RET.OK, data=data, msg='数据查询成功！')


# 推介会列表
@api_xiaocx.route('/IntroductionMeet', methods=['POST'])
# @login_required
def introduction_meet():
    req_dict = request.get_json()
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")

    try:
        meet_obj_list = IntroductionMeet.query.paginate(page, perpage).items
        meet_count = IntroductionMeet.query.count()

        data = [{
            "id": meet_obj.id,
            "name": meet_obj.name,
            "time": meet_obj.time,
            "organizer": meet_obj.organizer,
            "img_url": meet_obj.img_url,
            # "info": meet_obj.info,
        } for meet_obj in meet_obj_list]

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="查询出错！")
    return jsonify(code=RET.OK, data={"data": data, "size": meet_count}, msg='数据查询成功！')


# 推介会详情
@api_xiaocx.route('/MeetDetail', methods=['POST'])
# @login_required
def meet_detail():
    req_dict = request.get_json()
    _id = req_dict.get("id")

    try:
        meet_obj = IntroductionMeet.query.get(_id)
        data = {
            "name": meet_obj.name,
            "time": meet_obj.time,
            "organizer": meet_obj.organizer,
            "video_url": meet_obj.video_url,
            "info": meet_obj.info
        }

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="查询出错！")
    return jsonify(code=RET.OK, data=data, msg='数据查询成功！')


# 招商资讯列表
@api_xiaocx.route('/Information', methods=['POST'])
# @login_required
def information():
    req_dict = request.get_json()
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")

    try:
        inform_obj_list = InvestmentInformation.query.paginate(page, perpage).items
        inform_count = InvestmentInformation.query.count()

        data = [{
            "name": inform_obj.name,
            "time": inform_obj.time,
            "source": inform_obj.source,
            "info": inform_obj.content,
        } for inform_obj in inform_obj_list]

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="查询出错！")
    return jsonify(code=RET.OK, data={"data": data, "size": inform_count}, msg='数据查询成功！')


# 招商资讯详情/最新一条时id传空
@api_xiaocx.route('/InformationDetail', methods=['POST'])
# @login_required
def information_detail():
    req_dict = request.get_json()
    _id = req_dict.get("id")

    try:
        if _id:
            inform_obj = InvestmentInformation.query.get(_id)
        else:  # 最新一条
            inform_obj = InvestmentInformation.query.order_by(
                InvestmentInformation.id.desc()
                ).all()[-1]

        data = {
            "name": inform_obj.name,
            "time": inform_obj.time,
            "source": inform_obj.source,
            "info": inform_obj.content,
        }
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="查询出错！")
    return jsonify(code=RET.OK, data=data, msg='数据查询成功！')


# 重点企业列表
@api_xiaocx.route('/CompanyList', methods=['POST'])
# @login_required
def company_list():
    req_dict = request.get_json()
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")

    try:
        company_obj_list = Company.query.paginate(page, perpage).items
        company_count = Company.query.count()
        data = [{
            "id": company_obj.id,
            "name": company_obj.company_name
        } for company_obj in company_obj_list]

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="查询出错！")
    return jsonify(code=RET.OK, data={"data": data, "size": company_count}, msg='数据查询成功！')


# 重点企业详情
@api_xiaocx.route('/CompanyDetail', methods=['POST'])
# @login_required
def company_detail():
    req_dict = request.get_json()
    _id = req_dict.get("id")

    try:
        company_obj = Company.query.get(_id)
        data = {
            "company_name": company_obj.company_name,
            "chain_master": company_obj.chain_master,
            "district": company_obj.district,
            "lng": company_obj.lng,
            "lat": company_obj.lat,
            "address": company_obj.address,
            "telephone": company_obj.telephone,
            "company_info": company_obj.company_info,
            "c_name": company_obj.c_name,
            "zizhi": list(filter(len, [
                '是否高新技术企业' if company_obj.high_new == '1' else '',
                '是否科技型中小企业' if company_obj.tbe == '1' else '',
                '是否为省级民营科技企业' if company_obj.tbe_sjmy == '1' else '',
                '是否为有融资企业' if company_obj.fianacing == '1' else '',
                '是否上市企业' if company_obj.quoted_company == '1' else '',
                '是否为有专利企业' if company_obj.patent == '1' else '',
                '是否山西民营100强' if company_obj.sxmon == '1' else '',
                '是否为山西专精特新企业' if company_obj.zjtg == '1' else '',
                '是否为国家级专精特新小巨人企业' if company_obj.zjtg_gjjxjr == '1' else '',
                '是否为省级专精特新小巨人企业' if company_obj.zjtg_sjxjr == '1' else '',
                '独角兽企业' if company_obj.unicorn == '1' else '',
                '瞪羚' if company_obj.dengl == '1' else '',
                '是否中国500强' if company_obj.isfive == '1' else '',
                '是否山西100强' if company_obj.sxonhun == '1' else '',
                '规模以上企业' if company_obj.scale == '1' else '',
                '限额以上服务业' if company_obj.serve == '1' else ''
            ]))
        }

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="查询出错！")
    return jsonify(code=RET.OK, data=data, msg='数据查询成功！')


# 详情
# @api_xiaocx.route('/ZaitiDetail', methods=['POST'])
# # @login_required
# def zaiti_detail():
#     req_dict = request.get_json()
#     flag = req_dict.get("flag")  # 1地块，2楼宇，3厂房，4园区， 5项目
#     _id = req_dict.get("id")
#
#     try:
#         if flag == 1:
#             land_obj = CarrierLand.query.get(_id)
#             data = {
#                 "name": land_obj.name,
#                 "lng": land_obj.lng,
#                 "lat": land_obj.lat,
#                 "district": land_obj.district,
#                 "location": land_obj.location,
#                 "nature": land_obj.nature,
#                 "plot_ratio": land_obj.plot_ratio,
#                 "develop_degree": land_obj.develop_degree,
#                 "linkman": land_obj.linkman,
#                 "telephone": land_obj.telephone
#             }
#
#         if flag == 2:
#             build_obj = ZaitiBuild.query.get(_id)
#             data = {
#                 "name": build_obj.name,
#                 "lng": build_obj.lng,
#                 "lat": build_obj.lat,
#                 "district": build_obj.district,
#                 "address": build_obj.address,
#                 "build_area": build_obj.build_area,
#                 "attract_industry": build_obj.attract_industry,
#                 "rent": build_obj.rent,
#                 "linkman": build_obj.linkman,
#                 "telephone": build_obj.telephone
#             }
#
#         if flag == 3:
#             factory_obj = ZaitiFactory.query.get(_id)
#             data = {
#                 "name": factory_obj.name,
#                 "lng": factory_obj.lng,
#                 "lat": factory_obj.lat,
#                 "district": factory_obj.district,
#                 "address": factory_obj.address,
#                 "land_area": factory_obj.land_area,
#                 "build_area": factory_obj.build_area,
#                 "empty_area": factory_obj.empty_area,
#                 "factory_structure": factory_obj.factory_structure,
#                 "width": factory_obj.width,
#                 "high": factory_obj.high,
#                 "attract_industry": factory_obj.attract_industry,
#                 "rent": factory_obj.rent,
#                 "linkman": factory_obj.linkman,
#                 "telephone": factory_obj.telephone
#             }
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.SESSIONERR, msg="查询出错！")
#     return jsonify(code=RET.OK, data=data, msg='数据查询成功！')

""""""


# 投资咨询
@api_xiaocx.route('/Consultation', methods=['POST'])
# @login_required
def consultation():
    req_dict = request.get_json()
    project_name = req_dict.get("project_name")
    investor = req_dict.get("investor")
    investor_place = req_dict.get("investor_place")
    project_type = req_dict.get("project_type")
    investment_volume = req_dict.get("investment_volume")
    basic_information = req_dict.get("basic_information")
    land_area = req_dict.get("land_area")
    linkman = req_dict.get("linkman")
    link_mobile = req_dict.get("link_mobile")

    try:
        cons_obj = CustomerConsultation()
        cons_obj.project_name = project_name
        cons_obj.investor = investor
        cons_obj.investor_place = investor_place
        cons_obj.project_type = project_type
        cons_obj.investment_volume = investment_volume
        cons_obj.basic_information = basic_information
        cons_obj.land_area = land_area
        cons_obj.linkman = linkman
        cons_obj.link_mobile = link_mobile
        cons_obj.flag = 0
        db.session.add(cons_obj)
        db.session.commit()
    except Enterprise as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="查询出错！")
    return jsonify(code=RET.OK, msg='保存成功！')


# 投资咨询信息列表
@api_xiaocx.route('/ConsultationList', methods=['POST'])
# @login_required
def consultation_list():
    req_dict = request.get_json()
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")
    try:
        cons_obj_list = CustomerConsultation.query.paginate(page, perpage).items
        cons_count = CustomerConsultation.query.count()
        data = [{
            "project_name": cons_obj.project_name,
            "investor": cons_obj.investor,
            "investor_place": cons_obj.investor_place,
            "project_type": cons_obj.project_type,
            "investment_volume": cons_obj.investment_volume,
            "basic_information": cons_obj.basic_information,
            "land_area": cons_obj.land_area,
            "linkman": cons_obj.linkman,
            "link_mobile": cons_obj.link_mobile,
            "flag": cons_obj.flag,
            "reply_content": cons_obj.reply_content,
        } for cons_obj in cons_obj_list]

    except Enterprise as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="查询出错！")
    return jsonify(code=RET.OK, data={"data": data, "size": cons_count}, msg='查询成功！')


# 投资咨询详情
@api_xiaocx.route('/ConsultationDetail', methods=['POST'])
# @login_required
def consultation_detail():
    req_dict = request.get_json()
    _id = req_dict.get("id")
    try:
        cons_obj = CustomerConsultation.query.get(_id)
        data = {
            "project_name": cons_obj.project_name,
            "investor": cons_obj.investor,
            "investor_place": cons_obj.investor_place,
            "project_type": cons_obj.project_type,
            "investment_volume": cons_obj.investment_volume,
            "basic_information": cons_obj.basic_information,
            "land_area": cons_obj.land_area,
            "linkman": cons_obj.linkman,
            "link_mobile": cons_obj.link_mobile,
            "flag": cons_obj.flag,
            "reply_content": cons_obj.reply_content
        }
    except Enterprise as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="查询出错！")
    return jsonify(code=RET.OK, data=data, msg='查询成功！')


# 回复投资咨询
@api_xiaocx.route('/ReplyConsultation', methods=['POST'])
# @login_required
def reply_consultation():
    req_dict = request.get_json()
    reply_content = req_dict.get("reply_content")
    _id = req_dict.get("id")
    try:
        cons_obj = CustomerConsultation.query.get(_id)
        cons_obj.reply_content = reply_content
        db.session.commit()

    except Enterprise as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="回复信息保存出错！")
    return jsonify(code=RET.OK, msg='回复信息保存成功。')


# 收藏载体
@api_xiaocx.route('/CollectionCarrier', methods=['POST'])
# @login_required
def collection_carrier():
    req_dict = request.get_json()
    _id = req_dict.get("id")
    flag = req_dict.get("flag")  # 1地块，2楼宇，3厂房，4园区，5项目，6企业
    token = request.headers["token"]

    user_obj = verify_token(token)
    if flag == 1:
        user_obj.carrier_land.append(_id)
    elif flag == 2:
        user_obj.carrier_build.append(_id)
    elif flag == 3:
        user_obj.carrier_factory.append(_id)
    elif flag == 4:
        user_obj.carrier_factory.append(_id)
    elif flag == 5:
        user_obj.carrier_build.append(_id)
    elif flag == 6:
        user_obj.carrier_build.append(_id)
    else:
        pass






# 微信授权
@api_xiaocx.route("/WeChatLogin", methods=["POST"])
def wechat_login():
    '''
    用户验证码登录，用户存在，直接登陆，不存在就后台注册
    :return:
    '''
    # 参数获取与校验
    req_dict = request.get_json()
    code = req_dict.get('code')  # 微信登录code

    # 校验参数完整性
    if not all([code]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    app_id = 'wx1c081c352a9de7d9'
    app_secret = '5d0976f00a0f068deffa40d6a9383655'

    # url = u'https://api.weixin.qq.com/sns/oauth2/access_token'
    url = u'https://api.weixin.qq.com/sns/jscode2session'
    params = {
        'appid': app_id,
        'secret': app_secret,
        'js_code': code,
        'grant_type': 'authorization_code'
    }
    res = requests.get(url, params=params).json()

    # user_info_url = u'https://api.weixin.qq.com/sns/userinfo'
    # params1 = {
    #     'access_token': res.get("access_token"),
    #     'openid': res.get("openid")
    # }
    # uinfo = requests.get(user_info_url, params=params1).json()
    try:
        openid = res["openid"]
        unionid = res["unionid"]
    except:
        return None

    try:
        user = User.query.filter_by(vxopenid=openid, vxunionid=unionid).first()
        if user:
            # 若成功保存登录状态
            token = create_token(user.id)
            return jsonify(code=RET.OK, msg="登录成功", data={"token": token, "flag": user.flag})
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="appid,secreat异常")

    time = datetime.now()
    current_app.logger.error(
        '++++++++++++++++++++++++++++登录日志>>>{}:{}通过使用微信登录成功了！+++++++++++++++++++++++=++'.format(time, user))

    # return jsonify(code=RET.USERERR, msg="授权成功", user_info=uinfo)
    return jsonify(code=RET.USERERR, msg="授权成功")


# vx登陆后绑定手机号
# @api_xiaocx.route("/BindMobile", methods=["POST"])
# def bind_mobile():
#     '''
#     绑定已有账号
#     :return:
#     '''
#     req_dict = request.get_json()
#     openid = req_dict.get("openid")  # vxopenid
#     unionid = req_dict.get("unionid")  # vxunionid
#     mobile = req_dict.get('mobile')  # 手机号
#     sms_code = req_dict.get("sms_code")  # 验证码
#
#     # 校验参数完整性
#     if not all([openid, unionid, mobile, sms_code]):
#         return jsonify(code=RET.PARAMERR, msg="参数不完整")
#
#     # 校验手机号格式
#     if not re.match(r"1[23456789]\d{9}$", mobile):
#         return jsonify(code=RET.PARAMERR, msg="手机号格式错误")
#
#     # 获取短信验证码
#     try:
#         real_sms_code = redis_store.get('sms_code_{}'.format(mobile)).decode()
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="redis数据库异常")
#
#     # 获取用户
#     try:
#         user = User.query.filter_by(mobile=mobile).first()
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="获取用户信息失败")
#
#     # 判断用户填写短信验证码是否一致
#     if real_sms_code != sms_code:
#         return jsonify(code=RET.DATAERR, msg="短信验证码错误")
#     # 删除redis中的短信验证码，防止重复校验
#     try:
#         redis_store.delete("sms_code_{}".format(mobile))
#     except Exception as e:
#         current_app.logger.error(e)
#
#     try:
#         if user:
#             user.vxopenid = openid
#             user.vxunionid = unionid
#             db.session.commit()
#             if user.status != 1:
#                 jsonify(code=RET.OK, msg="绑定成功，当前用户被禁止登录,请联系管理员")
#         else:
#             user = User(name=mobile, mobile=mobile, vxopenid=openid, vxunionid=unionid, flag=1, status=1)
#             # user.password = password
#             db.session.add(user)
#             db.session.commit()
#     except Exception as e:
#         # 表示操作失败，回滚数据库操作
#         db.session.rollback()
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库异常")
#
#     # 若成功保存登录状态
#     token = create_token(user.id)
#     return jsonify(code=RET.OK, msg="绑定成功，登录成功", data={"token": token, "flag": user.flag})