import re

import requests
from dateutil.relativedelta import relativedelta
from flask import request, current_app, jsonify

from apps.models import *
from apps.utils.response_code import RET
import datetime
from apps.view_choose import api_address

from apps.view_choose.common import Common
from apps.util import verify_token

"""产业地图页面"""


# 展示中间右半部分载体面积
@api_address.route("/ShowArea", methods=["POST"])
def show_area():
    req_dic = request.get_json()
    district_name = req_dic['district_name']

    token = request.headers['token']

    # district_name = get_district_name(token, district_name)

    area_data = []
    # 今年的1月1号
    current_year = datetime.datetime.now().strftime('%Y-01-01 00:00:00')
    # 今年今天的前一天凌晨
    # current_day = (datetime.datetime.now() - relativedelta(days=1)).strftime('%Y-%m-%d 00:00:00')
    # current_day = datetime.datetime.now().strftime('%Y-%m-%d 00:00:00')
    current_day = str(datetime.datetime.now())
    # 去年的1月1号
    last_year = (datetime.datetime.now() - relativedelta(years=1)).strftime('%Y-01-01 00:00:00')
    # 去年今天的前一天凌晨
    # last_year_day = (datetime.datetime.now() - relativedelta(days=1) - relativedelta(years=1)).strftime(
    # last_year_day = (datetime.datetime.now() - relativedelta(years=1)).strftime('%Y-%m-%d 00:00:00')
    last_year_day = str(datetime.datetime.now() - relativedelta(years=1))
    com = Common()

    try:
        # 获取土地总面积
        area_obj_list = com.get_total_land_area('', '', district_name, '', '')
        total_area = sum([float(area_obj.total_area if area_obj.total_area else 0) for area_obj in area_obj_list])
        # print(total_area)

        # 获取工业用地面积
        gong_area_obj_list = com.get_total_land_area('', '', district_name, '工业用地', '')
        gong_total_area = round(sum([float(area_obj.total_area if area_obj.total_area else 0) for area_obj in gong_area_obj_list]), 2)
        # print(gong_total_area)

        # 获取商业用地面积
        shang_area_obj_list = com.get_total_land_area('', '', district_name, '商服用地', '')
        shang_total_area = round(sum([float(area_obj.total_area if area_obj.total_area else 0) for area_obj in shang_area_obj_list]), 2)
        # print(shang_total_area)

        # 其他用地
        other_area = round((total_area - gong_total_area - shang_total_area), 2)
        area_dic = {"industrial": gong_total_area, "business": shang_total_area, "other": other_area}
        # print(area_dic)
        area_data.append(area_dic)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='土地数据查询错误！')

    try:
        # 获取今年厂房总面积
        current_area_obj_list = com.get_total_factory_area(current_year, current_day, district_name)
        current_total_area = round(sum([float(area_obj.factory_area if area_obj.factory_area else 0) for area_obj in current_area_obj_list]), 2)
        # print(current_total_area)
        # 获取去年厂房总面积
        last_area_obj_list = com.get_total_factory_area(last_year, last_year_day, district_name)
        last_total_area = round(sum([float(area_obj.factory_area if area_obj.factory_area else 0) for area_obj in last_area_obj_list]), 2)
        # print(last_total_area)
        # 计算同比
        if last_total_area != 0:
            total_area_rate = round(((current_total_area - last_total_area) / last_total_area) * 100, 2)
        else:
            total_area_rate = 0

        # 获取当年当期总闲置厂房面积
        current_empty_area_obj_list = com.get_empty_factory_area(current_year, current_day, '', district_name)
        factory_current_empty_area = round(
            sum([float(area_obj.empty_area if area_obj.empty_area else 0) for area_obj in current_empty_area_obj_list]), 2)
        factory_current_total_area = round(
            sum([float(area_obj.factory_area if area_obj.factory_area else 0) for area_obj in current_empty_area_obj_list]), 2)
        # print(factory_current_empty_area)

        # 获取去年当期总闲置厂房面积
        last_empty_area_obj_list = com.get_empty_factory_area(last_year, last_year_day, '', district_name)
        factory_last_empty_area = round(sum([float(area_obj.empty_area if area_obj.empty_area else 0) for area_obj in last_empty_area_obj_list]), 2)
        factory_last_total_area = round(sum([float(area_obj.factory_area if area_obj.factory_area else 0) for area_obj in last_empty_area_obj_list]), 2)
        # print(factory_last_empty_area)
        # 计算总闲置面积同比
        if factory_last_empty_area != 0:
            factory_empty_rate = round(((factory_current_empty_area - factory_last_empty_area) / factory_last_empty_area) * 100, 2)
        else:
            factory_empty_rate = 0

        # 计算今年总闲置率
        if current_total_area != 0:
            total_empty_rate = round((factory_current_empty_area / current_total_area) * 100, 2)
        else:
            total_empty_rate = 0

        # 今年的闲置率
        if factory_current_total_area != 0:
            current_factory_empty_rate = round((factory_current_empty_area / factory_current_total_area) * 100, 2)
        else:
            current_factory_empty_rate = 0
        # 去年的闲置率
        if factory_last_total_area != 0:
            last_factory_empty_rate = round((factory_last_empty_area / factory_last_total_area) * 100, 2)
        else:
            last_factory_empty_rate = 0
        # 计算闲置率的同比
        if last_factory_empty_rate != 0:
            empty_rate = round(((current_factory_empty_rate - last_factory_empty_rate) / last_factory_empty_rate) * 100, 2)
        else:
            empty_rate = 0
        area_data.append({
            # 厂房总建筑面积
            "factory_total_area": current_total_area,
            "factory_total_area_rate": total_area_rate,
            # 厂房总闲置面积
            "factory_empty_area": factory_current_empty_area,
            "factory_empty_rate": factory_empty_rate,
            # 闲置率
            "current_factory_empty_rate": total_empty_rate,
            "empty_rate": empty_rate
        })
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='厂房数据查询错误！')

    try:
        # 获取今年楼宇总面积
        com = Common()
        current_area_obj_list = com.get_total_build_area(current_year, current_day, district_name)
        current_total_area = round(sum([float(area_obj.build_area if area_obj.build_area else 0) for area_obj in current_area_obj_list]), 2)
        # print(current_total_area)
        # 获取去年厂房总面积
        last_area_obj_list = com.get_total_build_area(last_year, last_year_day, district_name)
        last_total_area = round(sum([float(area_obj.build_area if area_obj.build_area else 0) for area_obj in last_area_obj_list]), 2)
        # print(last_total_area)
        # 计算同比
        if last_total_area != 0:
            total_area_rate = round(((current_total_area - last_total_area) / last_total_area) * 100, 2)
        else:
            total_area_rate = 0

        # 获取当年当期总闲置厂房面积
        current_empty_area_obj_list = com.get_empty_build_area(current_year, current_day, '', district_name)
        build_current_empty_area = round(
            sum([float(area_obj.empty_area if area_obj.empty_area else 0) for area_obj in current_empty_area_obj_list]), 2)
        build_current_total_area = round(
            sum([float(area_obj.total_area if area_obj.total_area else 0) for area_obj in current_empty_area_obj_list]), 2)
        # print(build_current_empty_area)
        # 获取去年当期总闲置厂房面积
        last_empty_area_obj_list = com.get_empty_build_area(last_year, last_year_day, '', district_name)
        build_last_empty_area = round(sum([float(area_obj.empty_area if area_obj.empty_area else 0) for area_obj in last_empty_area_obj_list]), 2)
        build_last_total_area = round(sum([float(area_obj.total_area if area_obj.total_area else 0) for area_obj in last_empty_area_obj_list]), 2)
        # print(build_last_empty_area)
        if build_last_empty_area != 0:
            build_empty_rate = round(((build_current_empty_area - build_last_empty_area) / build_last_empty_area) * 100, 2)
        else:
            build_empty_rate = 0

        # 计算今年总闲置率
        if current_total_area != 0:
            total_empty_rate = (round((build_current_empty_area / current_total_area) * 100, 2))
        else:
            total_empty_rate = 0

        # 今年的闲置率
        if build_current_total_area != 0:
            current_build_empty_rate = round((build_current_empty_area / build_current_total_area) * 100, 2)
        else:
            current_build_empty_rate = 0
        # 去年的闲置率
        if build_last_total_area != 0:
            last_build_empty_rate = round((build_last_empty_area / build_last_total_area) * 100, 2)
        else:
            last_build_empty_rate = 0
        # 计算楼宇闲置率同比
        if last_build_empty_rate != 0:
            build_rate = round(((current_build_empty_rate - last_build_empty_rate) / last_build_empty_rate) * 100, 2)
        else:
            build_rate = 0
        area_data.append({

            # 楼宇总建筑面积
            "build_total_area": current_total_area,
            "total_area_rate": total_area_rate,
            # 楼宇总闲置面积
            "build_empty_area": build_current_empty_area,
            "build_empty_rate": build_empty_rate,
            # 闲置率
            "current_build_empty_rate": total_empty_rate,
            "build_rate": build_rate
        })
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='楼宇数据查询错误！')
    return jsonify(code=RET.OK, data=area_data, msg='数据查询成功！')


# 展示右边部分水电热暖气数据
@api_address.route("/ShowCarrierEnergy", methods=["GET"])
def carrier_energy():
    try:
        energy_obj = CarrierEnergy.query.get(1)
        data = {
            "electric_data": {"electric_one": energy_obj.electric_one,
                              "electric_two": energy_obj.electric_two,
                              "electric_three": energy_obj.electric_three,
                              "business_electric_feng": energy_obj.business_electric_feng,
                              "business_electric_ping": energy_obj.business_electric_ping,
                              "business_electric_gu": energy_obj.business_electric_gu,
                              "industrial_electric_feng": energy_obj.industrial_electric_feng,
                              "industrial_electric_ping": energy_obj.industrial_electric_ping,
                              "industrial_electric_gu": energy_obj.industrial_electric_gu},
            "water_data": {"life_water_one": energy_obj.life_water_one,
                           "life_water_two": energy_obj.life_water_two,
                           "life_water_three": energy_obj.life_water_three,
                           "business_water": energy_obj.business_water,
                           "industrial_water": energy_obj.industrial_water,
                           "special_water": energy_obj.special_water},
            "gas_data": {"life_gas_one": energy_obj.life_gas_one,
                         "life_gas_two": energy_obj.life_gas_two,
                         "life_gas_three": energy_obj.life_gas_three}
        }
        return jsonify(code=RET.OK, data=data, msg='数据查询成功！')
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='数据查询错误！')


# 柱状图数据接口
@api_address.route("/ShowCarrierRate", methods=["POST"])
def month_rate():
    req_dic = request.get_json()
    district_name = req_dic['district_name']

    token = request.headers['token']

    # district_name = get_district_name(token, district_name)
    com = Common()
    data_list = []

    try:
        # 当年产业用地面积
        # upload_time = '2022-01-01 00:00:00'
        upload_time = ''
        if district_name == '晋城市':
            district_name_list = ["沁水县", "高平市", "陵川县", "阳城县",
                                  "泽州县", "城区", "晋城经济技术开发区"]
            for district_name in district_name_list:
                land_area_obj_list = com.get_total_land_area('', '', district_name, '', upload_time)
                land_total_area = sum([float(land_area_obj.total_area if land_area_obj.total_area else 0) for land_area_obj in land_area_obj_list])
                # 闲置楼宇面积
                build_area_obj_list = com.get_empty_build_area('', '', upload_time, district_name)
                build_empty_area = sum([float(build_area.empty_area if build_area.empty_area else 0) for build_area in build_area_obj_list])
                # 闲置厂房面积
                factory_area_obj_list = com.get_empty_factory_area('', '', upload_time, district_name)
                factory_empty_area = sum([float(factory_area.empty_area if factory_area.empty_area else 0) for factory_area in factory_area_obj_list])
                data = {"district_name": district_name,
                        "land_total_area": land_total_area,
                        "build_empty_area": build_empty_area,
                        "factory_empty_area": factory_empty_area}
                data_list.append(data)
            return jsonify(code=RET.OK, data=data_list, msg='数据查询成功！')
        else:
            # 每年的第一季度
            time_one = datetime.datetime.now().strftime('%Y-01-01 00:00:00')
            time_two = datetime.datetime.now().strftime('%Y-04-01 00:00:00')
            # 每年的第二季度
            time_three = datetime.datetime.now().strftime('%Y-04-01 00:00:00')
            time_four = datetime.datetime.now().strftime('%Y-07-01 00:00:00')
            # 每年的第三季度
            time_five = datetime.datetime.now().strftime('%Y-07-01 00:00:00')
            time_six = datetime.datetime.now().strftime('%Y-10-01 00:00:00')
            # 每年的第四季度
            time_seven = datetime.datetime.now().strftime('%Y-10-01 00:00:00')
            # 获取第一季度的产业用地/闲置厂房/闲置楼宇面积数据
            one_land_area_obj_list = com.get_total_land_area(time_one, time_two, district_name, '', '')
            one_land_total_area = sum([float(area_obj.total_area if area_obj.total_area else 0) for area_obj in one_land_area_obj_list])
            one_build_area_obj_list = com.get_empty_build_area(time_one, time_two, '', district_name)
            one_build_total_area = sum([float(area_obj.empty_area if area_obj.empty_area else 0) for area_obj in one_build_area_obj_list])
            one_factory_area_obj_list = com.get_empty_factory_area(time_one, time_two, '', district_name)
            one_factory_total_area = sum([float(area_obj.empty_area if area_obj.empty_area else 0) for area_obj in one_factory_area_obj_list])
            data = {"quarter": "第一季度",
                    "land_total_area": one_land_total_area,
                    "build_total_area": round(one_build_total_area, 2),
                    "factory_total_area": one_factory_total_area
                    }
            data_list.append(data)
            # 获取第二季度的产业用地/闲置厂房/闲置楼宇面积数据
            two_land_area_obj_list = com.get_total_land_area(time_three, time_four, district_name, '', '')
            two_total_area = sum([float(area_obj.total_area if area_obj.total_area else 0) for area_obj in two_land_area_obj_list])
            two_build_area_obj_list = com.get_empty_build_area(time_three, time_four, '', district_name)
            two_build_total_area = sum([float(area_obj.empty_area if area_obj.empty_area else 0) for area_obj in two_build_area_obj_list])
            two_factory_area_obj_list = com.get_empty_factory_area(time_three, time_four, '', district_name)
            two_factory_total_area = sum([float(area_obj.empty_area if area_obj.empty_area else 0) for area_obj in two_factory_area_obj_list])
            data = {"quarter": "第二季度",
                    "land_total_area": two_total_area,
                    "build_total_area": round(two_build_total_area, 2),
                    "factory_total_area": two_factory_total_area
                    }
            data_list.append(data)
            # 获取第三季度的产业用地/闲置厂房/闲置楼宇面积数据
            three_land_area_obj_list = com.get_total_land_area(time_five, time_six, district_name, '', '')
            three_total_area = sum([float(area_obj.total_area if area_obj.total_area else 0) for area_obj in three_land_area_obj_list])
            three_build_area_obj_list = com.get_empty_build_area(time_five, time_six, '', district_name)
            three_build_total_area = sum([float(area_obj.empty_area if area_obj.empty_area else 0) for area_obj in three_build_area_obj_list])
            three_factory_area_obj_list = com.get_empty_factory_area(time_five, time_six, '', district_name)
            three_factory_total_area = sum([float(area_obj.empty_area if area_obj.empty_area else 0) for area_obj in three_factory_area_obj_list])
            data = {"quarter": "第三季度",
                    "land_total_area": three_total_area,
                    "build_total_area": round(three_build_total_area, 2),
                    "factory_total_area": three_factory_total_area
                    }
            data_list.append(data)
            # 获取第四季度的产业用地/闲置厂房/闲置楼宇面积数据
            four_land_area_obj_list = com.get_total_land_area(time_seven, time_one, district_name, '', '')
            four_total_area = sum([float(area_obj.total_area if area_obj.total_area else 0) for area_obj in four_land_area_obj_list])
            four_build_area_obj_list = com.get_empty_build_area(time_seven, time_one, '', district_name)
            four_build_total_area = sum([float(area_obj.empty_area if area_obj.empty_area else 0) for area_obj in four_build_area_obj_list])
            four_factory_area_obj_list = com.get_empty_factory_area(time_seven, time_one, '', district_name)
            four_factory_total_area = sum([float(area_obj.empty_area if area_obj.empty_area else 0) for area_obj in four_factory_area_obj_list])
            data = {"quarter": "第四季度",
                    "land_total_area": four_total_area,
                    "build_total_area": round(four_build_total_area, 2),
                    "factory_total_area": four_factory_total_area
                    }
            data_list.append(data)

            return jsonify(code=RET.OK, data=data_list, msg='数据查询成功！')

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='数据查询错误！')


# 获取贷款市场报价利率
@api_address.route("/GetLoansRate", methods=["GET"])
def get_loans_rate():
    try:
        url = 'http://www.cmbchina.com/CmbWebPubInfo/lpr.aspx?chnl=cdrate'
        html = requests.get(url).text
        table_content_list = re.findall(r'var allData=(.*)', html)
        for table_content in table_content_list:
            table_content = table_content.split(';')[0]
            table_content = table_content.replace("null", "'null'")
            table_content = eval(table_content)
            time_list = [i[0] for i in table_content]
            y1 = [i[1][0] for i in table_content]
            y5 = [i[1][1] for i in table_content]
            data = {"time": time_list, "y1": y1, "y5": y5}
            return jsonify(code=RET.OK, data=data, msg=' 数据获取成功！ ')
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='数据请求错误！')
