import os
import time

import oss2
import requests
import sqlalchemy
import xlrd
import xlwt
from dateutil.relativedelta import relativedelta
from flask import current_app, jsonify, request
from sqlalchemy import and_
import zipfile

from apps.models import *

from apps.models import ProjectManagement
from apps.utils.response_code import RET
from apps.inves_manage import api_manage
from apps.util import verify_token

# 项目管理---项目列表
from apps.inves_manage.siku_view import get_num, upload_daily_picture
from apps.view_choose.choose_view import get_district_name

"""台账管理"""


# 编辑页文件图片删除接口
def file_delete(file_del_list, project_id):
    try:
        if file_del_list:
            for file_id in file_del_list:
                if file_id:
                    file_obj = ProjectFile.query.filter_by(id=file_id, project_manager_id=project_id,
                                                           file_type=1).first()
                    db.session.delete(file_obj)
                    db.session.commit()
        return 'ok'
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return 'error'


# 获取项目列表
@api_manage.route("/SearchProject1", methods=["POST"])
def search_project1():
    req_dic = request.get_json()

    token = request.headers['token']

    project_stalker = req_dic['project_stalker']

    project_name = req_dic['project_name']
    district = req_dic['district']
    development_area = req_dic['development_area']
    investor_name = req_dic['investor_name']
    investor_district = req_dic['investor_district']
    industry = req_dic['industry']
    industry2 = ''
    if '/' in industry:
        industry1 = industry.split('/')[0]
        industry2 = industry.split('/')[1]
    else:
        industry1 = industry
    investment_volume = req_dic['investment_volume']
    project_progress = req_dic['project_progress']
    project_year = req_dic['project_year']
    page = req_dic['page']
    per_page = req_dic['per_page']
    flag = req_dic['flag']

    try:
        user_obj = verify_token(token)
        user_district = get_district_name(token)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")

    try:
        # project_obj = ProjectManagement.query.filter(
        #     ProjectManagement.project_name.like('%{}%'.format(project_name)) if project_name else text(''),
        #     ProjectManagement.project_stalker == project_stalker if project_stalker else text(''),
        #     ProjectManagement.district == district if district else text(''),
        #     ProjectManagement.development_area == development_area if development_area else text(''),
        #     ProjectManagement.investment_volume > investment_volume[0] if investment_volume else text(''),
        #     ProjectManagement.investment_volume <= investment_volume[1] if investment_volume else text(''),
        #     ProjectManagement.investor_district.like('%{}%'.format(investor_district)) if investor_district else text(
        #         ''),
        #     ProjectManagement.industry.like('%{}%'.format(industry1)) if industry1 else text(''),
        #     ProjectManagement.industry2.like('%{}%'.format(industry2)) if industry2 else text(''),
        #     ProjectManagement.investor_name.like('%{}%'.format(investor_name)) if investor_name else text(''),
        #     ProjectManagement.project_progress == project_progress if project_progress else text(''),
        #     ProjectManagement.project_year == project_year if project_year else text(''),
        #     ProjectManagement.is_delete == 0
        # )

        project_obj = ProjectManagement.query.filter(
            ProjectManagement.district == user_district if user_district != '晋城市' else text(''),
            ProjectManagement.sign_time.notin_(['Null', '']) if flag == 2 else text(''),
            ProjectManagement.project_name.like('%{}%'.format(project_name)) if project_name else text(''),
            ProjectManagement.project_stalker == project_stalker if project_stalker else text(''),
            ProjectManagement.project_stalker != '' if flag == 2 else text(''),
            ProjectManagement.district == district if district else text(''),
            ProjectManagement.development_area == development_area if development_area else text(''),
            ProjectManagement.investment_volume > investment_volume[0] if investment_volume else text(''),
            ProjectManagement.investment_volume <= investment_volume[1] if investment_volume else text(''),
            ProjectManagement.investor_district.like('%{}%'.format(investor_district)) if investor_district else text(''),
            ProjectManagement.industry.like('%{}%'.format(industry1)) if industry1 else text(''),
            ProjectManagement.industry2.like('%{}%'.format(industry2)) if industry2 else text(''),
            ProjectManagement.investor_name.like('%{}%'.format(investor_name)) if investor_name else text(''),
            ProjectManagement.project_progress == project_progress if project_progress else text(''),
            ProjectManagement.project_year == project_year if project_year else text(''),
            ProjectManagement.is_delete == 0
        )

        if not project_obj.all():
            return jsonify(code=RET.NODATA, msg='没有符合条件的数据！')
        project_size = project_obj.count()

        project_obj_list = project_obj.order_by(ProjectManagement.upload_time.desc()).paginate(page, per_page).items
        if project_obj_list:
            data = [{
                "id": project_obj.id,
                "project_stalker": project_obj.project_stalker,
                "project_name": project_obj.project_name,
                "district": project_obj.district,
                "development_area": project_obj.development_area,
                "attract_name": project_obj.attract_name,
                "investor_name": project_obj.investor_name,
                "investor_district": project_obj.investor_district,
                "industry": project_obj.industry,
                "investment_volume": project_obj.investment_volume,
                "construction_content": project_obj.construction_content,
                "project_address": project_obj.project_address,
                "project_progress": project_obj.project_progress,
                "project_problem": project_obj.project_problem,
                "project_year": project_obj.project_year
            } for project_obj in project_obj_list]
            return jsonify(code=RET.OK, data={"data": data, "size": project_size, "msg": "数据获取成功！"})

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查询数据库错误！")


# 项目详情
@api_manage.route("/CheckProjectDetail1", methods=["POST"])
def check_project_detail1():
    req_dic = request.get_json()
    project_id = req_dic['project_id']
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")
    if not project_id:
        return jsonify(code=RET.PARAMERR, msg="参数不能为空！")
    try:
        industry = ''
        project_obj = ProjectManagement.query.filter_by(id=project_id, is_delete=0).first()
        if project_obj.industry and project_obj.industry2:
            industry = project_obj.industry + '/' + project_obj.industry2
        if project_obj.industry and not project_obj.industry2:
            industry = project_obj.industry
        project_data = {"id": project_obj.id,
                        "project_stalker": project_obj.project_stalker,  # 项目跟踪
                        "project_name": project_obj.project_name,  # 项目名称
                        "district": project_obj.district,  # 项目所在地
                        "development_area": project_obj.development_area,  # 开发区
                        "attract_name": project_obj.attract_name,  # 引资方名称
                        "investor_name": project_obj.investor_name,  # 投资方名称(万元)
                        "investor_district": project_obj.investor_district,  # 投资方所在地(亩)
                        "industry": industry,
                        "investment_volume": project_obj.investment_volume,  # 总投资额(万元)
                        "construction_content": project_obj.construction_content,  # 建设内容
                        "project_address": project_obj.project_address,  # 项目选址
                        "project_progress": project_obj.project_progress,  # 项目进展
                        "project_problem": project_obj.project_problem,  # 难点情况
                        "project_year": project_obj.project_year,  # 项目年份
                        "upload_unity": project_obj.upload_unity,  # 上传部门
                        "upload_people": project_obj.upload_people,  # 上传人
                        "upload_time": project_obj.upload_time.strftime("%Y-%m-%d %H:%M:%S"),  # 上传时间
                        "project_num": project_obj.project_num,  # 项目编号
                        "project_source": project_obj.project_source,  # 项目来源
                        "project_unity": project_obj.project_unity,  # 项目申报单位
                        "is_development_project": project_obj.is_development_project,  # 是否属于开发区项目
                        # "sign_time": project_obj.sign_time.strftime("%Y/%m/%d") if project_obj.sign_time and project_obj.sign_time != '0000-00-00 00:00:00' else '',  # 签约时间
                        # "start_time": project_obj.start_time.strftime("%Y/%m/%d") if project_obj.start_time and project_obj.start_time != '0000-00-00 00:00:00' else '',  # 开工时间
                        # "end_time": project_obj.end_time.strftime("%Y/%m/%d") if project_obj.end_time and project_obj.end_time != '0000-00-00 00:00:00' else '',  # 竣工时间
                        "sign_time": project_obj.sign_time,
                        # 签约时间
                        "start_time": project_obj.start_time,
                        # 开工时间
                        "end_time": project_obj.end_time,
                        # 竣工时间
                        "investor_rank": project_obj.investor_rank,  # 投资方排名
                        "is_transf_project": project_obj.is_transf_project,  # 是否转型项目
                        "country": project_obj.country,  # 投资方国别
                        "provence": project_obj.provence,  # 投资方省份
                        "city": project_obj.city,  # 投资方市
                        "job_num": project_obj.job_num,  # 带动就业岗位（个）
                        "new_value": project_obj.new_value,  # 新增产值（亿元）
                        "revenue": project_obj.revenue,  # 贡献税收（亿元）
                        "use_land": project_obj.use_land,  # 项目用地情况（亩）
                        "new_land": project_obj.new_land,  # 其中新增用地（亩）
                        "construction_nature": project_obj.construction_nature,  # 建设性质（亩）
                        "is_fixed_investment": project_obj.is_fixed_investment,  # 固定资产投资项目
                        "investment_year": project_obj.investment_year,  # 资金到位本年累计（万元）
                        "investment_history": project_obj.investment_history,  # 资金到位历史累计（万元）
                        "cooperation_way": project_obj.cooperation_way,  # 合作方式
                        "set_project_status": project_obj.set_project_status,  # 项目立项状态
                        "investor_people": project_obj.investor_people,  # 投资方联系人
                        "investor_mobile": project_obj.investor_mobile,  # 投资方电话
                        "investor_address": project_obj.investor_address,  # 投资方联系地址
                        }
        file_obj_list = project_obj.project_files1
        file_data = [{
            "id": file_obj.id,
            "file_url": file_obj.file_url,
            "file_name": file_obj.file_name,
        } for file_obj in file_obj_list]
        return jsonify(code=RET.OK, data={"data": project_data, "file_data": file_data, "msg": "数据获取成功！"})
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="操作失败！数据库查询错误")


# 下载模板
@api_manage.route("/DownloadProjectTemplate", methods=["POST"])
def download_project_template():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")
    project_template = "http://39.100.39.50:8008/aaa_statics/template_file/招商引资项目表.xlsx"
    return jsonify(code=RET.OK, data=project_template, msg="模板下载成功！")


def get_industry_level(industry1, industry2):
    # 判断项目产业
    industry_level = ''
    if industry1 and industry1 == '现代农业':
        industry_level = '第一产业'
    if industry1 and industry1 == '文化旅游产业':
        industry_level = '第三产业'
    if industry2 and industry2 in ["商贸物流", "商务服务业", "房地产", "康养", "其他"]:
        industry_level = '第三产业'
    if industry2 and industry2 in ["煤炭先进产能和安全改造", "电力", "焦化", "冶金", "食品", "纺织",
                                   "轻工", "其他工业技术改造", "节能环保产业", "煤层气产业", "煤化工产业", "新一代信息技术产业",
                                   "高端装备制造业", "新材料产业", "新能源产业", "新能源汽车产业", "生物产业"]:
        industry_level = '第二产业'
    return industry_level


# 批量导入
@api_manage.route("/UploadProjectData2", methods=["POST"])
def upload_project_data2():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
        user_unity = user_obj.belong_organization
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")
    # 上传的文件
    file = request.files['file']
    # print(file.filename)  # 打印文件名

    try:
        f = file.read()  # 文件内容
        data = xlrd.open_workbook(file_contents=f)
        table = data.sheets()[0]
        names = data.sheet_names()  # 返回book中所有工作表的名字
        status = data.sheet_loaded(names[0])  # 检查sheet1是否导入完毕
        print(status)
        nrows = table.nrows  # 获取该sheet中的有效行数
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.THIRDERR, msg="读取文件失败！")

    rep_num = 0
    rep_project_name_list = []
    success_num = 0
    name = ''

    row_list = [table.row_values(i) for i in range(4, nrows)]
    for i in range(0, len(row_list)):
        row_content = row_list[i]
        if not row_content:
            return jsonify(code=RET.NODATA,
                           msg="表格内无有效数据！请尝试 <清空浏览器缓存> 后下载最新模板，根据模板提示信息编辑数据后再次上传。(注：第三行为首行有效数据不能为空、第一行和第二行无法读取。)")
        project_name = row_content[1]  # 项目名称
        # 判断该项目是否已经存在
        project_obj = ProjectManagement.query.filter_by(project_name=project_name, is_delete=0).first()
        if project_obj:
            rep_num += 1
            rep_project_name_list.append(project_name)
            continue
        try:
            project_name = row_content[1]  # 项目名称
            district = row_content[2]  # 项目所在地
            development_area = row_content[3]  # 开发区
            attract_name = row_content[4]  # 引资方名称
            investor_name = row_content[5]  # 投资方名称
            country = row_content[6]  # 投资方国别
            provence = row_content[7]  # 投资方省份
            if provence and not country:
                return jsonify(code=RET.PARAMERR, msg="如选择了省份，请完善国别！")

            city = row_content[8]  # 投资方市
            industry1 = row_content[9]  # 所属行业1
            industry2 = row_content[10]  # 所属行业2
            investment_volume = row_content[11]  # 总投资额(万元)
            construction_content = row_content[12]  # 建设内容
            construction_nature = row_content[13]  # 建设性质（亩）
            project_address = row_content[14]  # 项目选址
            use_land = row_content[15]  # 项目用地情况（亩）
            new_land = row_content[16]  # 其中新增用地（亩）
            set_project_status = row_content[17]  # 项目立项状态
            project_progress = row_content[18]  # 项目进展
            sign_time = row_content[19]  # 签约时间
            y, m, d, h, i, s = xlrd.xldate_as_tuple(sign_time, data.datemode)
            sign_time = "{0}-{1}-{2}".format(y, m, d)
            project_year = ''
            if sign_time:
                project_year = int(sign_time.split('-')[0])

            start_time = row_content[20]  # 开工时间
            y, m, d, h, i, s = xlrd.xldate_as_tuple(start_time, data.datemode)
            start_time = "{0}-{1}-{2}".format(y, m, d)

            end_time = row_content[21]  # 竣工时间
            y, m, d, h, i, s = xlrd.xldate_as_tuple(end_time, data.datemode)
            end_time = "{0}-{1}-{2}".format(y, m, d)

            is_fixed_investment = row_content[22]  # 固定资产投资项目
            investment_year = row_content[23]  # 资金到位本年累计（万元）
            investment_history = row_content[24]  # 资金到位历史累计（万元）
            project_stalker = row_content[25]  # 项目跟踪
            project_stalker_explain = row_content[26]  # 项目跟踪说明
            investor_district = ''
            if provence and city:
                investor_district = provence + "/" + city
            if provence and not city:
                investor_district = provence
            if city and not provence:
                investor_district = city
        except Exception as e:
            # 表示操作失败，回滚数据库操作
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据异常！请尝试 <清空浏览器缓存> 后下载最新模板，根据模板提示信息编辑数据后再次上传。")

        if not project_name:
            return jsonify(code=RET.PARAMERR, msg='项目名称不能为空！')

        # 构造项目编号
        # 按照上传年份 + 县（市、区）、开发区 + 序数词格式生成；县（市、区）、开发区其中编号为：
        # 城区140502、泽州县140525、高平市140581、阳城县140522
        # 陵川县140524、沁水县140521、晋城经济技术开发区140526；
        # 例如2022140502002代表2022年城区的第二个项目；
        prefix_dic = {
            "城区": "140502",
            "泽州县": "140525",
            "高平市": "140581",
            "阳城县": "140522",
            "陵川县": "140524",
            "沁水县": "140521",
            "晋城经济技术开发区": "140526"
        }
        time_strf = datetime.now().strftime("%Y")
        project_num_li = ''
        project_obj_list = ProjectManagement.query.filter_by(is_delete=0).all()
        if project_obj_list:
            project_num_li = [project_obj.project_num for project_obj in project_obj_list if
                              project_obj.project_num.startswith(time_strf + prefix_dic[district])]
        if project_num_li:
            max_project_num = max(project_num_li)[10:]
            num = get_num(max_project_num)
            if num == 'error':
                return 'error'
            project_num = time_strf + prefix_dic[district] + num
        else:
            project_num = time_strf + prefix_dic[district] + '001'
        industry_level = ''
        if industry1 and industry2:
            industry_level = get_industry_level(industry1, industry2)
        if industry1 and not industry2:
            industry_level = get_industry_level(industry1, '')

        try:
            # 写入数据库
            file_time = datetime.now().strftime("%Y-%m-%d %H:%M")
            project_obj = ProjectManagement(
                project_num=project_num,
                project_name=project_name,
                district=district,
                development_area=development_area,
                attract_name=attract_name,
                investor_name=investor_name,
                country=country,
                provence=provence,
                city=city,
                investor_district=investor_district,
                industry=industry1,
                industry2=industry2,
                industry_level=industry_level,
                investment_volume=investment_volume,
                construction_content=construction_content,
                construction_nature=construction_nature,
                project_address=project_address,
                use_land=use_land,
                new_land=new_land,
                set_project_status=set_project_status,
                project_progress=project_progress,
                sign_time=sign_time,
                project_year=project_year,
                start_time=start_time,
                end_time=end_time,
                is_fixed_investment=is_fixed_investment,
                investment_year=investment_year,
                investment_history=investment_history,
                project_stalker=project_stalker,
                project_stalker_explain=project_stalker_explain,
                upload_unity=user_unity,
                upload_people=user_name,
                upload_time=file_time,
                is_delete=0
            )
            db.session.add(project_obj)
            db.session.commit()
            success_num += 1
            continue
        except Exception as e:
            # 表示操作失败，回滚数据库操作
            db.session.rollback()
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库异常")

    if rep_project_name_list and success_num > 0:
        return jsonify(code=RET.OK,
                       msg='上传成功！数据上传 {} 条数据，{}已存在同名项目。'.format(success_num, rep_project_name_list))
    if success_num > 0:
        return jsonify(code=RET.OK,
                       msg='上传成功！数据上传 {} 条数据。'.format(success_num))

    else:
        return jsonify(code=RET.DATAERR, msg='无新数据上传。')


# 批量导出
@api_manage.route("/BatchExportProject5", methods=["POST"])
def batch_export_project5():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")

    req_dic = request.get_json()
    select_id_list = req_dic["select_id_list"]
    # path = './apps/statics/project_file/'
    # pro_path = 'http://39.100.39.50:5050/statics/project_file/'  # 项目路径
    path = './apps/static/project_file/'

    pro_path = 'http://39.100.39.50:5050/static/project_file/'  # 项目路径
    # pro_path = 'http://192.168.1.4:5000/statics/project_file/'  # 项目路径
    if not select_id_list:
        return jsonify(code=RET.PARAMERR, msg="参数不能为空！")
    target_data_list = []
    for select_id in select_id_list:
        try:
            project_obj = ProjectManagement.query.filter_by(id=select_id, is_delete=0).first()
            # 提取数据，写入xslx表格
            data_list = []
            project_num = project_obj.project_num
            data_list.append(project_num)
            project_name = project_obj.project_name
            data_list.append(project_name)
            district = project_obj.district
            data_list.append(district)
            development_area = project_obj.development_area
            data_list.append(development_area)
            attract_name = project_obj.attract_name
            data_list.append(attract_name)
            investor_name = project_obj.investor_name
            data_list.append(investor_name)
            country = project_obj.country
            data_list.append(country)
            provence = project_obj.provence
            data_list.append(provence)
            city = project_obj.city
            data_list.append(city)
            industry = project_obj.industry
            data_list.append(industry)
            industry2 = project_obj.industry2
            data_list.append(industry2)
            investment_volume = project_obj.investment_volume
            data_list.append(investment_volume)
            construction_content = project_obj.construction_content
            data_list.append(construction_content)
            construction_nature = project_obj.construction_nature
            data_list.append(construction_nature)
            project_address = project_obj.project_address
            data_list.append(project_address)
            use_land = project_obj.use_land
            data_list.append(use_land)
            new_land = project_obj.new_land
            data_list.append(new_land)
            set_project_status = project_obj.set_project_status
            data_list.append(set_project_status)
            project_progress = project_obj.project_progress
            data_list.append(project_progress)
            # sign_time = project_obj.sign_time.strftime(
            #     "%Y/%m/%d") if project_obj.sign_time and project_obj.sign_time != '0000-00-00 00:00:00' else ''
            # data_list.append(sign_time)
            # start_time = project_obj.start_time.strftime(
            #     "%Y/%m/%d") if project_obj.start_time and project_obj.start_time != '0000-00-00 00:00:00' else ''
            # data_list.append(start_time)
            # end_time = project_obj.end_time.strftime(
            #     "%Y/%m/%d") if project_obj.end_time and project_obj.end_time != '0000-00-00 00:00:00' else ''
            sign_time = project_obj.sign_time
            data_list.append(sign_time)
            start_time = project_obj.start_time
            data_list.append(start_time)
            end_time = project_obj.end_time
            data_list.append(end_time)
            is_fixed_investment = project_obj.is_fixed_investment
            data_list.append(is_fixed_investment)
            investment_year = project_obj.investment_year
            data_list.append(investment_year)
            investment_history = project_obj.investment_history
            data_list.append(investment_history)
            project_stalker = project_obj.project_stalker
            data_list.append(project_stalker)
            project_stalker_explain = project_obj.project_stalker_explain
            data_list.append(project_stalker_explain)
            target_data_list.append(data_list)
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库查询错误！")
    head_list = ''
    sheet = ''
    try:
        sheet_name_titles = {
            "sheet1": ["项目编号", "项目名称", "项目所在地", "所属开发区", "引资方名称", "投资方名称",
                       "国别（地区）", "省（自治区、直辖市、特别行政区）",
                       "市（州、盟、区）", "一级行业（下拉框筛选）", "二级子行业（下拉框筛选）", "总投资额（万元）",
                       "项目建设内容", "项目建设性质", "项目选址详情", "用地情况（亩）", "其中新增用地（亩）",
                       "项目立项情况", "项目进展", "签约时间", "开工时间", "竣工时间", "固资产投资项目（是、否）",
                       "资金到位本年累计（万元）", "资金到位历史累计（万元）", "项目跟踪", "项目跟踪说明"
                       ]}

        excel = xlwt.Workbook(encoding='utf-8')
        # 写入表头
        for i in range(len(sheet_name_titles)):
            for k, v in sheet_name_titles.items():
                sheet_name = k
                sheet = excel.add_sheet(sheet_name)
                head_list = v
                print(head_list)
                for j in range(len(head_list)):
                    sheet.write(0, j, head_list[j])
        # 写入数据，从第二行(i+1)
        rows = len(target_data_list)
        cols = len(head_list)
        for i in range(rows):
            for j in range(cols):
                sheet.write(i + 1, j, target_data_list[i][j])
        time_stamp = '{0:%Y%m%d%H%M%S}'.format(datetime.now())
        file_name = "招商引资项目表{}.xlsx".format(time_stamp)
        excel.save(path + file_name)
        return jsonify(code=RET.OK, url=pro_path + file_name, msg="导出/下载成功！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="批量导出操作失败！")


# 批量删除（逻辑删除）
@api_manage.route("/BatchDelete1", methods=["POST"])
def batch_delete1():
    req_dic = request.get_json()
    token = request.headers['token']

    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
        # user_id = user_obj.id
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行批量删除操作时用户信息校验失败，请重新登陆后尝试！")

    delete_id_list = req_dic["delete_id_list"]
    if not delete_id_list:
        return jsonify(code=RET.PARAMERR, msg="参数不能为空！")

    try:
        for select_id in delete_id_list:
            project_obj_list = ProjectManagement.query.filter_by(id=select_id, is_delete=0).all()
            if not project_obj_list:
                return jsonify(code=RET.DBERR, msg="数据不存在！")
            for project_obj in project_obj_list:
                project_obj.is_delete = 1
                db.session.commit()
        return jsonify(code=RET.OK, msg="删除成功！")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="批量删除操作失败！")


# 项目编辑
@api_manage.route("/ProjectEdit1", methods=["POST"])
def project_edit():
    file_list = request.files.getlist('file_list')
    file_del_list = request.form.getlist('file_del_list')

    project_stalker = request.form['project_stalker']
    project_name = request.form['project_name']
    district = request.form['district']
    development_area = request.form['development_area']
    attract_name = request.form['attract_name']
    investor_name = request.form['investor_name']
    industry = request.form['industry']
    investment_volume = request.form['investment_volume']
    construction_content = request.form['construction_content']
    project_address = request.form['project_address']
    project_progress = request.form['project_progress']
    project_problem = request.form['project_problem']
    upload_unity = request.form['upload_unity']
    upload_people = request.form['upload_people']
    project_num = request.form['project_num']
    project_source = request.form['project_source']
    project_unity = request.form['project_unity']
    is_development_project = request.form['is_development_project']
    sign_time = request.form['sign_time']
    project_year = ''
    if sign_time:
        project_year = int(sign_time.split('-')[0])

    start_time = request.form['start_time']
    end_time = request.form['end_time']
    investor_rank = request.form['investor_rank']
    is_transf_project = request.form['is_transf_project']
    country = request.form['country']
    provence = request.form['provence']
    if provence and not country:
        return jsonify(code=RET.PARAMERR, msg="如选择了省份，请完善国别！")

    city = request.form['city']
    job_num = request.form['job_num']
    new_value = request.form['new_value']
    revenue = request.form['revenue']
    use_land = request.form['use_land']
    new_land = request.form['new_land']
    construction_nature = request.form['construction_nature']
    is_fixed_investment = request.form['is_fixed_investment']
    investment_year = request.form['investment_year']
    investment_history = request.form['investment_history']
    cooperation_way = request.form['cooperation_way']
    set_project_status = request.form['set_project_status']
    investor_people = request.form['investor_people']
    investor_mobile = request.form['investor_mobile']
    investor_address = request.form['investor_address']
    project_id = request.form['project_id']

    token = request.headers['token']

    upload_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
        user_id = user_obj.id
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行编辑项目信息操作时用户信息校验失败，请重新登陆后尝试！")

    if '/' in industry:
        industry = industry.split('/')
        industry1 = industry[0]
        industry2 = industry[1]
    else:
        industry1 = industry
        industry2 = ''
    industry_level = get_industry_level(industry1, industry2)

    try:
        project_obj = ProjectManagement.query.filter_by(id=project_id, is_delete=0).first()
        if not project_obj:
            return jsonify(code=RET.NODATA, msg='查无此项目！')
        project_obj.project_stalker = project_stalker
        project_obj.project_name = project_name
        project_obj.district = district
        project_obj.development_area = development_area
        project_obj.attract_name = attract_name
        project_obj.investor_name = investor_name
        project_obj.industry = industry1
        project_obj.industry2 = industry2
        project_obj.industry_level = industry_level
        project_obj.investment_volume = investment_volume
        project_obj.construction_content = construction_content
        project_obj.project_address = project_address
        project_obj.project_progress = project_progress
        project_obj.project_problem = project_problem
        project_obj.upload_unity = upload_unity
        project_obj.upload_people = upload_people
        project_obj.project_num = project_num
        project_obj.project_source = project_source
        project_obj.project_unity = project_unity
        project_obj.is_development_project = is_development_project
        project_obj.sign_time = sign_time
        project_obj.project_year = project_year
        project_obj.start_time = start_time
        project_obj.end_time = end_time
        project_obj.investor_rank = investor_rank
        project_obj.is_transf_project = is_transf_project
        project_obj.country = country
        project_obj.provence = provence
        project_obj.city = city
        project_obj.investor_district = country + provence + city
        project_obj.job_num = job_num
        project_obj.new_value = new_value
        project_obj.revenue = revenue
        project_obj.use_land = use_land
        project_obj.new_land = new_land
        project_obj.construction_nature = construction_nature
        project_obj.is_fixed_investment = is_fixed_investment
        project_obj.investment_year = investment_year
        project_obj.investment_history = investment_history
        project_obj.cooperation_way = cooperation_way
        project_obj.set_project_status = set_project_status
        project_obj.investor_people = investor_people
        project_obj.investor_mobile = investor_mobile
        project_obj.investor_address = investor_address
        # 删除文件和图片
        result = file_delete(file_del_list, project_id)
        if result == 'error':
            return jsonify(code=RET.DBERR, msg="附件删除异常！")

        try:
            # 上传文件
            if file_list:
                for file_obj in file_list:
                    file_name = file_obj.filename
                    file_url = upload_daily_picture(1, file_name, file_obj)

                    # 存入数据库
                    file_obj = ProjectFile(flag=5,
                                           file_type=1,
                                           # project_id=project_id,
                                           file_url=file_url,
                                           file_name=file_name,
                                           upload_time=upload_time,
                                           upload_people=upload_people,
                                           upload_people_id=user_id,
                                           project_manager_id=project_id
                                           )
                    db.session.add(file_obj)
                    db.session.commit()
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="文件上传失败！")
        db.session.commit()
        return jsonify(code=RET.OK, msg="修改成功！")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查询数据库错误！")


"""指标分析 山西指标数据"""


# 下载模板
@api_manage.route("/DownloadProjectTemplate1", methods=["POST"])
def download_project_template1():
    token = request.headers['token']
    req_dic = request.get_json()
    flag = req_dic['flag']  # 1为山西省各市完成情况表,2为晋城市及县区年度目标表,3为晋城市及县区固投到位资金完成情况
    try:
        user_obj = verify_token(token)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")
    project_template = ''
    if flag == 1:
        project_template = "http://39.100.39.50:8008/aaa_statics/template_file/山西省各市完成情况表.xlsx"
    if flag == 2:
        project_template = "http://39.100.39.50:8008/aaa_statics/template_file/晋城市及县区年度目标表.xlsx"
    if flag == 3:
        project_template = "http://39.100.39.50:8008/aaa_statics/template_file/晋城市及县区固投到位资金完成情况.xlsx"
    return jsonify(code=RET.OK, data=project_template, msg="模板下载成功！")


# 上传山西省地市指标
@api_manage.route("/UploadShanxiData", methods=["POST"])
def upload_shanxi_data():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
        user_unity = user_obj.belong_organization
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")
    # 上传的文件
    file = request.files['file']
    print(file.filename)  # 打印文件名
    data_time = request.form['data_time']
    # file_name = file.filename
    upload_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    try:
        f = file.read()  # 文件内容
        data = xlrd.open_workbook(file_contents=f)
        table = data.sheets()[0]
        names = data.sheet_names()  # 返回book中所有工作表的名字
        status = data.sheet_loaded(names[0])  # 检查sheet1是否导入完毕
        print(status)
        nrows = table.nrows  # 获取该sheet中的有效行数
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.THIRDERR, msg="读取文件失败！")

    success_num = 0
    row_list = [table.row_values(i) for i in range(3, nrows)]
    for i in range(0, len(row_list)):
        row_content = row_list[i]
        if not row_content:
            return jsonify(code=RET.NODATA,
                           msg="表格内无有效数据！请尝试 <清空浏览器缓存> 后下载最新模板，根据模板提示信息编辑数据后再次上传。(注：第三行为首行有效数据不能为空、第一行和第二行无法读取。)")
        try:
            district_name = row_content[0]  # 区县名称
            sign_money = row_content[1]  # 签约金额
            sign_target_money = row_content[2]  # 目标金额
            sign_finish_rate = row_content[3]  # 完成率
            plan_invest_money = row_content[4]  # 计划投资额
            plan_target_money = row_content[5]  # 目标计划投资额
            plan_finish_rate = row_content[6]  # 计划投资额完成率
            arrive_money = row_content[7]  # 资金到位
            arrive_target_money = row_content[8]  # 目标资金到位
            arrive_finish_rate = row_content[9]  # 计划投资额完成率
        except Exception as e:
            # 表示操作失败，回滚数据库操作
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据异常！请尝试 <清空浏览器缓存> 后下载最新模板，根据模板提示信息编辑数据后再次上传。")

        if not district_name:
            return jsonify(code=RET.PARAMERR, msg='区县名称不能为空！')

        try:
            target_obj = ShanxiTarget.query.filter_by(district_name=district_name, data_time=data_time,
                                                      is_delete=0).first()
            if target_obj:  # 更新
                target_obj.data_time = data_time
                target_obj.upload_time = upload_time
                target_obj.upload_unit = user_unity
                target_obj.upload_people = user_name
                target_obj.district_name = district_name
                target_obj.sign_money = sign_money
                target_obj.sign_target_money = sign_target_money
                target_obj.sign_finish_rate = sign_finish_rate
                target_obj.plan_invest_money = plan_invest_money
                target_obj.plan_target_money = plan_target_money
                target_obj.plan_finish_rate = plan_finish_rate
                target_obj.arrive_money = arrive_money
                target_obj.arrive_target_money = arrive_target_money
                target_obj.arrive_finish_rate = arrive_finish_rate
                db.session.commit()
                success_num += 1
                continue
            else:
                # 写入数据库
                # file_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
                target_obj = ShanxiTarget(
                    # file_name=file_name,
                    is_delete=0,
                    data_time=data_time,
                    upload_time=upload_time,
                    upload_unit=user_unity,
                    upload_people=user_name,
                    district_name=district_name,
                    sign_money=sign_money,
                    sign_target_money=sign_target_money,
                    sign_finish_rate=sign_finish_rate,
                    plan_invest_money=plan_invest_money,
                    plan_target_money=plan_target_money,
                    plan_finish_rate=plan_finish_rate,
                    arrive_money=arrive_money,
                    arrive_target_money=arrive_target_money,
                    arrive_finish_rate=arrive_finish_rate,
                )
                db.session.add(target_obj)
                db.session.commit()
                success_num += 1
                continue
        except Exception as e:
            # 表示操作失败，回滚数据库操作
            db.session.rollback()
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库异常")

    if success_num > 0:
        return jsonify(code=RET.OK,
                       msg='上传成功！数据上传 {} 条数据'.format(success_num))
    else:
        return jsonify(code=RET.DATAERR, msg='无新数据上传。')


# 概览数据列表(山西指标上传页数据列表展示)
@api_manage.route("/ShanxiDataList", methods=["POST"])
def shanxi_data_list():
    token = request.headers['token']
    req_dic = request.get_json()
    page = req_dic['page']
    per_page = req_dic['per_page']

    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
        user_unity = user_obj.belong_organization
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")
    req_dic = request.get_json()
    year = req_dic['year']
    # current_year = datetime.now().year
    # current_year = 2022
    try:
        target_obj_list = ShanxiTarget.query.filter(
            # ShanxiTarget.data_time.like('%{}%'.format(year) if year else current_year),
            ShanxiTarget.is_delete == 0
        ).all()
        data_time_set = set(target_obj.data_time for target_obj in target_obj_list)

        # 收集上传周期
        data_li = []
        for data_time in list(data_time_set):
            target_obj = ShanxiTarget.query.filter_by(data_time=data_time).first()
            data = {"data_time": target_obj.data_time,
                    "upload_time": target_obj.upload_time,
                    "upload_unit": target_obj.upload_unit,
                    "upload_people": target_obj.upload_people}
            data_li.append(data)
        data_size = len(data_li)

        start = (page - 1) * per_page
        end = page * per_page
        data_li = data_li[start:end]
        return jsonify(code=RET.OK, data={"data_li": data_li, "data_size": data_size}, msg='获取成功！')
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查询数据库错误！")


# 新增/编辑山西指标数据
@api_manage.route("/AddEditShanxiData", methods=["POST"])
def add_shanxi_data():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
        user_unity = user_obj.belong_organization
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")
    req_dic = request.get_json()
    data_list = req_dic["data_list"]
    upload_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")

    for data in data_list:
        data_time = data['data_time']  # 数据年份
        district_name = data['district_name']  # 区县名称
        sign_money = data['sign_money']  # 签约金额
        sign_target_money = data['sign_target_money']  # 目标金额
        sign_finish_rate = data['sign_finish_rate']  # 完成率
        plan_invest_money = data['plan_invest_money']  # 计划投资额
        plan_target_money = data['plan_target_money']  # 目标计划投资额
        plan_finish_rate = data['plan_finish_rate']  # 计划投资额完成率
        arrive_money = data['arrive_money']  # 资金到位
        arrive_target_money = data['arrive_target_money']  # 目标资金到位
        arrive_finish_rate = data['arrive_finish_rate']  # 计划投资额完成率
        add_num = 0
        update_num = 0
        try:
            target_obj = ShanxiTarget.query.filter_by(district_name=district_name, data_time=data_time,
                                                      is_delete=0).first()
            if target_obj:  # 更新
                target_obj.data_time = data_time
                target_obj.upload_time = upload_time
                target_obj.upload_unit = user_unity
                target_obj.upload_people = user_name
                target_obj.district_name = district_name
                target_obj.sign_money = sign_money
                target_obj.sign_target_money = sign_target_money
                target_obj.sign_finish_rate = sign_finish_rate
                target_obj.plan_invest_money = plan_invest_money
                target_obj.plan_target_money = plan_target_money
                target_obj.plan_finish_rate = plan_finish_rate
                target_obj.arrive_money = arrive_money
                target_obj.arrive_target_money = arrive_target_money
                target_obj.arrive_finish_rate = arrive_finish_rate
                db.session.commit()
                update_num += 1
            else:
                target_obj = ShanxiTarget(
                    is_delete=0,
                    data_time=data_time,
                    upload_time=upload_time,
                    upload_unit=user_unity,
                    upload_people=user_name,
                    district_name=district_name,
                    sign_money=sign_money,
                    sign_target_money=sign_target_money,
                    sign_finish_rate=sign_finish_rate,
                    plan_invest_money=plan_invest_money,
                    plan_target_money=plan_target_money,
                    plan_finish_rate=plan_finish_rate,
                    arrive_money=arrive_money,
                    arrive_target_money=arrive_target_money,
                    arrive_finish_rate=arrive_finish_rate
                )
                db.session.add(target_obj)
                db.session.commit()
                add_num += 1
                continue
        except Exception as e:
            # 表示操作失败，回滚数据库操作
            db.session.rollback()
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库异常，新增失败！")
    return jsonify(code=RET.OK, msg='保存成功！')


# 详情数据列表(某周期山西各地市指标数据列表展示)
@api_manage.route("/ShanxiDataDetail", methods=["POST"])
def shanxi_data_detail():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")
    req_dic = request.get_json()
    data_time = req_dic["data_time"]
    try:
        # if not data_time:
        #     # 获取最新的时间周期
        #     data_obj = ShanxiTarget.query.order_by(sqlalchemy.desc(ShanxiTarget.id)).first()
        #     data_time = data_obj.data_time
        #     target_obj_li = ShanxiTarget.query.filter_by(data_time=data_time, is_delete=0).all()
        # else:
        target_obj_li = ShanxiTarget.query.filter_by(data_time=data_time, is_delete=0).all()
        data = [{
            "id": target_obj.id,
            "data_time": target_obj.data_time,
            "upload_time": target_obj.upload_time,
            "upload_unit": target_obj.upload_unit,
            "upload_people": target_obj.upload_people,
            "district_name": target_obj.district_name,
            "sign_money": target_obj.sign_money,
            "sign_target_money": target_obj.sign_target_money,
            "sign_finish_rate": target_obj.sign_finish_rate,
            "plan_invest_money": target_obj.plan_invest_money,
            "plan_target_money": target_obj.plan_target_money,
            "plan_finish_rate": target_obj.plan_finish_rate,
            "arrive_money": target_obj.arrive_money,
            "arrive_target_money": target_obj.arrive_target_money,
            "arrive_finish_rate": target_obj.arrive_finish_rate,
        } for target_obj in target_obj_li]
        return jsonify(code=RET.OK, data=data, msg="获取成功！")
    except Exception as e:
        # 表示操作失败，回滚数据库操作
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库异常")


# 下载数据详情
@api_manage.route("/DownloadShanxiData", methods=["POST"])
def download_shanxi_data():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")

    req_dic = request.get_json()
    data_time = req_dic["data_time"]
    path = './apps/statics/project_file/'
    # pro_path = 'http://39.100.39.50:8008/aaa_statics/project_file/'  # 项目路径
    pro_path = 'http://192.168.1.4:5000/statics/project_file/'  # 项目路径
    if not data_time:
        return jsonify(code=RET.PARAMERR, msg="参数不能为空！")
    target_data_list = []
    try:
        target_obj_li = ShanxiTarget.query.filter_by(data_time=data_time, is_delete=0).all()
        for target_obj in target_obj_li:
            # 提取数据，写入xslx表格
            data_list = []
            district_name = target_obj.district_name
            data_list.append(district_name)  # 区县名称
            sign_money = target_obj.sign_money
            data_list.append(sign_money)  # 签约金额
            sign_target_money = target_obj.sign_target_money
            data_list.append(sign_target_money)  # 目标金额
            sign_finish_rate = target_obj.sign_finish_rate
            data_list.append(sign_finish_rate)  # 完成率
            plan_invest_money = target_obj.plan_invest_money
            data_list.append(plan_invest_money)  # 计划投资额
            plan_target_money = target_obj.plan_target_money
            data_list.append(plan_target_money)  # 目标计划投资额
            plan_finish_rate = target_obj.plan_finish_rate
            data_list.append(plan_finish_rate)  # 计划投资额完成率
            arrive_money = target_obj.arrive_money
            data_list.append(arrive_money)  # 资金到位
            arrive_target_money = target_obj.arrive_target_money
            data_list.append(arrive_target_money)  # 目标资金到位
            arrive_finish_rate = target_obj.arrive_finish_rate
            data_list.append(arrive_finish_rate)  # 计划投资额完成率
            target_data_list.append(data_list)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误！")
    head_list = ''
    sheet = ''
    try:
        sheet_name_titles = {
            "sheet1": ["市", "签约金额（亿元）", "年度目标（亿元）", "完成率（ % ）", "新开工项目计划投资额（亿元）",
                       "年度目标（亿元）", "完成率（ % ）", "固定资产投资项目资金到位额（亿元）", "年度目标（亿元）", "完成率（ % ）"
                       ]}
        excel = xlwt.Workbook(encoding='utf-8')
        # 写入表头
        for i in range(len(sheet_name_titles)):
            for k, v in sheet_name_titles.items():
                sheet_name = k
                sheet = excel.add_sheet(sheet_name)
                head_list = v
                print(head_list)
                for j in range(len(head_list)):
                    sheet.write(0, j, head_list[j])
        # 写入数据，从第二行(i+1)
        rows = len(target_data_list)
        cols = len(head_list)
        for i in range(rows):
            for j in range(cols):
                sheet.write(i + 1, j, target_data_list[i][j])
        time_stamp = '{0:%Y%m%d%H%M%S}'.format(datetime.now())
        file_name = "山西省各地市指标完成情况表{}.xlsx".format(time_stamp)
        excel.save(path + file_name)
        return jsonify(code=RET.OK, url=pro_path + file_name, msg="导出/下载成功！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="批量导出操作失败！")


# 删除某时间周期的数据
@api_manage.route("/DeleteShanxiData", methods=["POST"])
def delete_shanxi_data():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")

    req_dic = request.get_json()
    data_time = req_dic["data_time"]
    try:
        target_obj_li = ShanxiTarget.query.filter_by(data_time=data_time, is_delete=0).all()
        for target_obj in target_obj_li:
            target_obj.is_delete = 1
            db.session.commit()
            continue
        return jsonify(code=RET.OK, msg="删除成功！")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查询数据库错误！")


"""指标分析 晋城指标数据"""


# 上传晋城省地市指标
@api_manage.route("/UploadJcData", methods=["POST"])
def upload_jc_data():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
        user_unity = user_obj.belong_organization
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")
    # 上传的文件
    file = request.files['file']
    year = request.form['year']  # 年份，如'2022年'

    print(file.filename)  # 打印文件名
    upload_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    # current_year = str(datetime.now().year) + '年'

    try:
        f = file.read()  # 文件内容
        data = xlrd.open_workbook(file_contents=f)
        table = data.sheets()[0]
        names = data.sheet_names()  # 返回book中所有工作表的名字
        status = data.sheet_loaded(names[0])  # 检查sheet1是否导入完毕
        print(status)
        nrows = table.nrows  # 获取该sheet中的有效行数
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.THIRDERR, msg="读取文件失败！")

    success_num = 0
    row_list = [table.row_values(i) for i in range(4, nrows)]
    for i in range(0, len(row_list)):
        row_content = row_list[i]
        if not row_content:
            return jsonify(code=RET.NODATA,
                           msg="表格内无有效数据！请尝试 <清空浏览器缓存> 后下载最新模板，根据模板提示信息编辑数据后再次上传。(注：第三行为首行有效数据不能为空、第一行和第二行无法读取。)")
        try:
            district_name = row_content[0]  # 区县名称
            money_sign = row_content[1]  # 签约项目金额
            rate_start = row_content[2]  # 项目开工率
            money_plan_invest = row_content[3]  # 新开工固定资产投资项目计划投资额
            money_arrive_target1 = row_content[4]  # 固定资产投资项目资金到位额
            money_arrive_target0 = row_content[5]  # 非固定资产投资项目资金到位额
        except Exception as e:
            # 表示操作失败，回滚数据库操作
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据异常！请尝试 <清空浏览器缓存> 后下载最新模板，根据模板提示信息编辑数据后再次上传。")

        if not district_name:
            return jsonify(code=RET.PARAMERR, msg='区县名称不能为空！')

        try:
            target_obj = JcTarget.query.filter_by(district_name=district_name, year=year, is_delete=0).first()
            if target_obj:  # 更新
                # target_obj.file_name = year + '年度目标数据'
                # target_obj.year = year
                target_obj.upload_time = upload_time
                target_obj.upload_unit = user_unity
                target_obj.upload_people = user_name
                target_obj.district_name = district_name
                target_obj.money_sign = money_sign
                target_obj.rate_start = rate_start
                target_obj.money_plan_invest = money_plan_invest
                target_obj.money_arrive_target1 = money_arrive_target1
                target_obj.money_arrive_target0 = money_arrive_target0
                db.session.commit()
                success_num += 1
                continue
            else:
                # 写入数据库
                target_obj = JcTarget(
                    file_name=year + '年度目标数据',
                    is_delete=0,
                    year=year,
                    upload_time=upload_time,
                    upload_unit=user_unity,
                    upload_people=user_name,
                    district_name=district_name,
                    money_sign=money_sign,
                    rate_start=rate_start,
                    money_plan_invest=money_plan_invest,
                    money_arrive_target1=money_arrive_target1,
                    money_arrive_target0=money_arrive_target0,
                )
                db.session.add(target_obj)
                db.session.commit()
                success_num += 1
                continue
        except Exception as e:
            # 表示操作失败，回滚数据库操作
            db.session.rollback()
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库异常")

    if success_num > 0:
        return jsonify(code=RET.OK,
                       msg='上传成功！数据上传 {} 条数据'.format(success_num))
    else:
        return jsonify(code=RET.DATAERR, msg='无新数据上传。')


# 新增/编辑晋城指标上传页数据
@api_manage.route("/AddEditJcData", methods=["POST"])
def add_jc_data():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
        user_unity = user_obj.belong_organization
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")
    req_dic = request.get_json()
    data_list = req_dic["data_list"]
    upload_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    for data in data_list:
        year = data['year']  # 所属年份
        district_name = data['district_name']  # 区县名称
        money_sign = data['money_sign']  # 签约项目金额
        rate_start = data['rate_start']  # 项目开工率
        money_plan_invest = data['money_plan_invest']  # 新开工固定资产投资项目计划投资额
        money_arrive_target1 = data['money_arrive_target1']  # 固定资产投资项目资金到位额
        money_arrive_target0 = data['money_arrive_target0']  # 非固定资产投资项目资金到位额

        grade_sign = data['grade_sign']
        grade_start = data['grade_start']
        grade_plan_invest = data['grade_plan_invest']
        grade_arrive_target1 = data['grade_arrive_target1']
        grade_arrive_target0 = data['grade_arrive_target0']
        try:
            target_obj = JcTarget.query.filter_by(district_name=district_name, year=year, is_delete=0).first()
            if target_obj:  # 更新
                target_obj.district_name = district_name
                target_obj.money_sign = money_sign
                target_obj.rate_start = rate_start
                target_obj.money_plan_invest = money_plan_invest
                target_obj.money_arrive_target1 = money_arrive_target1
                target_obj.money_arrive_target0 = money_arrive_target0

                target_obj.grade_sign = grade_sign
                target_obj.grade_start = grade_start
                target_obj.grade_plan_invest = grade_plan_invest
                target_obj.grade_arrive_target1 = grade_arrive_target1
                target_obj.grade_arrive_target0 = grade_arrive_target0
                db.session.commit()
            else:
                target_obj = JcTarget(
                    is_delete=0,
                    file_name=year + '年度目标数据',
                    year=year,
                    upload_time=upload_time,
                    upload_unit=user_unity,
                    upload_people=user_name,
                    district_name=district_name,
                    money_sign=money_sign,
                    rate_start=rate_start,
                    money_plan_invest=money_plan_invest,
                    money_arrive_target1=money_arrive_target1,
                    money_arrive_target0=money_arrive_target0,

                    grade_sign=grade_sign,
                    grade_start=grade_start,
                    grade_plan_invest=grade_plan_invest,
                    grade_arrive_target1=grade_arrive_target1,
                    grade_arrive_target0=grade_arrive_target0,
                )
                db.session.add(target_obj)
                db.session.commit()
                continue
        except Exception as e:
            # 表示操作失败，回滚数据库操作
            db.session.rollback()
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库异常，新增失败！")
    return jsonify(code=RET.OK, msg='保存成功！')


# 概览数据列表(晋城指标上传页数据列表展示)
@api_manage.route("/JcDataList", methods=["POST"])
def jc_data_list():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
        user_unity = user_obj.belong_organization
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")
    req_dic = request.get_json()
    year = req_dic['year']
    page = req_dic["page"]
    per_page = req_dic["per_page"]
    current_year = datetime.now().year
    try:
        target_obj_list = JcTarget.query.filter(
            JcTarget.year.like('%{}%'.format(str(year)) if year else text('')),
            JcTarget.is_delete == 0
        ).all()
        year_set = set(target_obj.year for target_obj in target_obj_list)

        # 收集上传周期
        data_li = []
        data_size = ''
        for year in list(year_set):
            target_obj = JcTarget.query.filter_by(year=year, is_delete=0).first()
            data = {"year": target_obj.year,
                    "file_name": target_obj.file_name,
                    "upload_time": target_obj.upload_time,
                    "upload_unit": target_obj.upload_unit,
                    "upload_people": target_obj.upload_people}
            data_li.append(data)
            data_size = len(data_li)

            start = (page - 1) * per_page
            end = page * per_page
            data_li = data_li[start:end]
        return jsonify(code=RET.OK, data={"data_li": data_li, "data_size": data_size}, msg='获取成功！')
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查询数据库错误！")


# 详情数据列表(某周期晋城各地市指标数据列表展示)
@api_manage.route("/JcDataDetail", methods=["POST"])
def jc_data_detail():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
        user_unity = user_obj.belong_organization
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")
    req_dic = request.get_json()
    year = req_dic["year"]
    try:
        target_obj_li = JcTarget.query.filter_by(year=year, is_delete=0).all()
        data = [{
            "id": target_obj.id,
            "year": target_obj.year,
            "upload_time": target_obj.upload_time,
            "upload_unit": target_obj.upload_unit,
            "upload_people": target_obj.upload_people,
            "grade_sign": target_obj.grade_sign,
            "grade_start": target_obj.grade_start,
            "grade_plan_invest": target_obj.grade_plan_invest,
            "grade_arrive_target1": target_obj.grade_arrive_target1,
            "grade_arrive_target0": target_obj.grade_arrive_target0,
            "district_name": target_obj.district_name,
            "money_sign": target_obj.money_sign,
            "rate_start": target_obj.rate_start,
            "money_plan_invest": target_obj.money_plan_invest,
            "money_arrive_target1": target_obj.money_arrive_target1,
            "money_arrive_target0": target_obj.money_arrive_target0
        } for target_obj in target_obj_li]
        return jsonify(code=RET.OK, data=data, msg="获取成功！")
    except Exception as e:
        # 表示操作失败，回滚数据库操作
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库异常")


# 删除某时间周期的数据
@api_manage.route("/DeleteJcData", methods=["POST"])
def delete_jc_data():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")

    req_dic = request.get_json()
    year = req_dic["year"]
    try:
        target_obj_li = JcTarget.query.filter_by(year=year, is_delete=0).all()
        for target_obj in target_obj_li:
            target_obj.is_delete = 1
            db.session.commit()
            continue
        return jsonify(code=RET.OK, msg="删除成功！")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查询数据库错误！")


# 下载数据详情
@api_manage.route("/DownloadJcData", methods=["POST"])
def download_jc_data():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")

    req_dic = request.get_json()
    year = req_dic["year"]
    path = './apps/statics/project_file/'
    pro_path = 'http://39.100.39.50:8008/aaa_statics/project_file/'  # 项目路径
    # pro_path = 'http://192.168.1.4:5000/statics/project_file/'  # 项目路径
    if not year:
        return jsonify(code=RET.PARAMERR, msg="参数不能为空！")
    target_data_list = []
    try:
        target_obj_li = JcTarget.query.filter_by(year=year, is_delete=0).all()
        for target_obj in target_obj_li:
            # 提取数据，写入xslx表格
            data_list = []
            district_name = target_obj.district_name
            data_list.append(district_name)  # 区县名称
            money_sign = target_obj.money_sign
            data_list.append(money_sign)  # 签约项目金额
            rate_start = target_obj.rate_start
            data_list.append(rate_start)  # 项目开工率
            money_plan_invest = target_obj.money_plan_invest
            data_list.append(money_plan_invest)  # 新开工固定资产投资项目计划投资额
            money_arrive_target1 = target_obj.money_arrive_target1
            data_list.append(money_arrive_target1)  # 固定资产投资项目资金到位额
            money_arrive_target0 = target_obj.money_arrive_target0
            data_list.append(money_arrive_target0)  # 非固定资产投资项目资金到位额
            target_data_list.append(data_list)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误！")
    head_list = ''
    sheet = ''
    try:
        sheet_name_titles = {
            "sheet1": ["县(市、区）、开发区", "年度目标（亿元）", "开工率年度目标",
                       "年度目标（亿元）", "年度目标（亿元）", "年度目标（亿元）"]}

        excel = xlwt.Workbook(encoding='utf-8')
        # 写入表头
        for i in range(len(sheet_name_titles)):
            for k, v in sheet_name_titles.items():
                sheet_name = k
                sheet = excel.add_sheet(sheet_name)
                head_list = v
                print(head_list)
                for j in range(len(head_list)):
                    sheet.write(0, j, head_list[j])
        # 写入数据，从第二行(i+1)
        rows = len(target_data_list)
        cols = len(head_list)
        for i in range(rows):
            for j in range(cols):
                sheet.write(i + 1, j, target_data_list[i][j])
        time_stamp = '{0:%Y%m%d%H%M%S}'.format(datetime.now())
        file_name = "晋城市及县区年度目标表{}.xlsx".format(time_stamp)
        excel.save(path + file_name)
        return jsonify(code=RET.OK, url=pro_path + file_name, msg="导出/下载成功！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="批量导出操作失败！")


"""固定资产投资项目资金到位"""


# 上传固定资产投资项目资金到位
@api_manage.route("/UploadMoneyArrive", methods=["POST"])
def upload_money_arrive():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
        user_unity = user_obj.belong_organization
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")
    # 上传的文件
    file = request.files['file']
    print(file.filename)  # 打印文件名
    data_time = request.form['data_time']
    # file_name = file.filename
    upload_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    try:
        f = file.read()  # 文件内容
        data = xlrd.open_workbook(file_contents=f)
        table = data.sheets()[0]
        names = data.sheet_names()  # 返回book中所有工作表的名字
        status = data.sheet_loaded(names[0])  # 检查sheet1是否导入完毕
        print(status)
        nrows = table.nrows  # 获取该sheet中的有效行数
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.THIRDERR, msg="读取文件失败！")

    success_num = 0
    row_list = [table.row_values(i) for i in range(3, nrows)]
    for i in range(0, len(row_list)):
        row_content = row_list[i]
        if not row_content:
            return jsonify(code=RET.NODATA,
                           msg="表格内无有效数据！请尝试 <清空浏览器缓存> 后下载最新模板，根据模板提示信息编辑数据后再次上传。(注：第三行为首行有效数据不能为空、第一行和第二行无法读取。)")
        try:
            district_name = row_content[0]  # 区县名称
            arrive_money = round(row_content[1], 2)  # 到位金额
        except Exception as e:
            # 表示操作失败，回滚数据库操作
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据异常！请尝试 <清空浏览器缓存> 后下载最新模板，根据模板提示信息编辑数据后再次上传。")

        if not district_name:
            return jsonify(code=RET.PARAMERR, msg='区县名称不能为空！')

        try:
            target_obj = MoneyArrive.query.filter_by(district_name=district_name, data_time=data_time,
                                                     is_delete=0).first()
            if target_obj:  # 更新
                # target_obj.file_name = target_obj.data_time + '固投资金到位情况'
                target_obj.data_time = data_time
                target_obj.upload_time = upload_time
                target_obj.upload_unit = user_unity
                target_obj.upload_people = user_name
                target_obj.district_name = district_name
                target_obj.arrive_money = arrive_money
                db.session.commit()
                success_num += 1
                continue
            else:
                # 写入数据库
                target_obj = MoneyArrive(
                    file_name=data_time + '固投资金到位情况',
                    is_delete=0,
                    data_time=data_time,
                    upload_time=upload_time,
                    upload_unit=user_unity,
                    upload_people=user_name,
                    district_name=district_name,
                    arrive_money=arrive_money
                )
                db.session.add(target_obj)
                db.session.commit()
                success_num += 1
                continue
        except Exception as e:
            # 表示操作失败，回滚数据库操作
            db.session.rollback()
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库异常")

    if success_num > 0:
        return jsonify(code=RET.OK,
                       msg='上传成功！数据上传 {} 条数据'.format(success_num))
    else:
        return jsonify(code=RET.DATAERR, msg='无新数据上传。')


# 概览数据列表(固定资产投资项目资金到位)
@api_manage.route("/MoneyArriveList", methods=["POST"])
def money_arrive_list():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        # user_name = user_obj.real_name
        # user_unity = user_obj.belong_organization
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")
    req_dic = request.get_json()
    year = req_dic['year']
    page = req_dic["page"]
    per_page = req_dic["per_page"]
    current_year = datetime.now().year
    try:
        target_obj_list = MoneyArrive.query.filter(
            MoneyArrive.data_time.like('%{}%'.format(year) if year else current_year), MoneyArrive.is_delete == 0
        ).all()
        data_time_set = set(target_obj.data_time for target_obj in target_obj_list)

        # 收集上传周期
        data_li = []
        data_size = ''
        for data_time in list(data_time_set):
            target_obj = MoneyArrive.query.filter_by(data_time=data_time, is_delete=0).first()
            data = {"file_name": target_obj.file_name,
                    "data_time": target_obj.data_time,
                    "upload_time": target_obj.upload_time,
                    "upload_unit": target_obj.upload_unit,
                    "upload_people": target_obj.upload_people}
            data_li.append(data)
            data_size = len(data_li)

            start = (page - 1) * per_page
            end = page * per_page
            data_li = data_li[start:end]

        return jsonify(code=RET.OK, data={"data_li": data_li, "data_size": data_size}, msg='获取成功！')
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查询数据库错误！")


# 新增/编辑固定资产投资项目资金到位数据
@api_manage.route("/AddEditMoneyArrive", methods=["POST"])
def add_edit_money_arrive():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
        user_unity = user_obj.belong_organization
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")
    req_dic = request.get_json()
    data_list = req_dic["data_list"]
    upload_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    money_arrive_list = []
    for data in data_list:
        data_time = data['data_time']  # 数据年份
        district_name = data['district_name']  # 区县名称
        # money_arrive = float(data['money_arrive'])  # 签约金额
        money_arrive = data['money_arrive']  # 签约金额
        if not money_arrive:
            continue
        money_arrive_list.append(money_arrive)

        try:
            target_obj = MoneyArrive.query.filter_by(district_name=district_name, data_time=data_time,
                                                     is_delete=0).first()
            if target_obj:  # 更新
                target_obj.data_time = data_time
                # target_obj.file_name = data_time + "固投资金到位情况",
                target_obj.upload_time = upload_time
                target_obj.upload_unit = user_unity
                target_obj.upload_people = user_name
                target_obj.district_name = district_name
                target_obj.arrive_money = money_arrive
                db.session.commit()
            else:
                target_obj = MoneyArrive(
                    is_delete=0,
                    data_time=data_time,
                    file_name=data_time + "固投资金到位情况",
                    upload_time=upload_time,
                    upload_unit=user_unity,
                    upload_people=user_name,
                    district_name=district_name,
                    arrive_money=money_arrive,
                )
                db.session.add(target_obj)
                db.session.commit()
                continue
        except Exception as e:
            # 表示操作失败，回滚数据库操作
            db.session.rollback()
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库异常，新增失败！")
    if not money_arrive_list:
        return jsonify(code=RET.DBERR, msg='无有效数据！')
    return jsonify(code=RET.OK, msg='新增成功！')


# 详情数据列表(某周期固定资产投资项目资金到位列表展示)
@api_manage.route("/MoneyArriveDetail", methods=["POST"])
def arrive_money_detail():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
        user_unity = user_obj.belong_organization
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")
    req_dic = request.get_json()
    data_time = req_dic["data_time"]
    try:
        target_obj_li = MoneyArrive.query.filter_by(data_time=data_time, is_delete=0).all()
        data = [{
            "id": target_obj.id,
            "data_time": target_obj.data_time,
            "upload_time": target_obj.upload_time,
            "upload_unit": target_obj.upload_unit,
            "upload_people": target_obj.upload_people,
            "district_name": target_obj.district_name,
            "money_arrive": target_obj.arrive_money,
        } for target_obj in target_obj_li]
        return jsonify(code=RET.OK, data=data, msg="获取成功！")
    except Exception as e:
        # 表示操作失败，回滚数据库操作
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库异常")


# 下载数据详情(固定资产投资项目资金到位)
@api_manage.route("/DownloadMoneyArrive", methods=["POST"])
def download_money_arrive():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")

    req_dic = request.get_json()
    data_time = req_dic["data_time"]
    path = './apps/statics/project_file/'
    pro_path = 'http://39.100.39.50:8008/aaa_statics/project_file/'  # 项目路径
    # pro_path = 'http://192.168.1.4:5000/statics/project_file/'  # 项目路径
    if not data_time:
        return jsonify(code=RET.PARAMERR, msg="参数不能为空！")
    target_data_list = []
    try:
        target_obj_li = MoneyArrive.query.filter_by(data_time=data_time, is_delete=0).all()
        for target_obj in target_obj_li:
            # 提取数据，写入xslx表格
            data_list = []
            district_name = target_obj.district_name
            data_list.append(district_name)  # 区县名称
            arrive_money = target_obj.arrive_money
            data_list.append(arrive_money)  # 签约金额
            target_data_list.append(data_list)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误！")
    head_list = ''
    sheet = ''
    try:
        sheet_name_titles = {
            "sheet1": ["县(市、区）、开发区", "固定资产投资项目资金到位额（亿元）"]}
        excel = xlwt.Workbook(encoding='utf-8')
        # 写入表头
        for i in range(len(sheet_name_titles)):
            for k, v in sheet_name_titles.items():
                sheet_name = k
                sheet = excel.add_sheet(sheet_name)
                head_list = v
                print(head_list)
                for j in range(len(head_list)):
                    sheet.write(0, j, head_list[j])
        # 写入数据，从第二行(i+1)
        rows = len(target_data_list)
        cols = len(head_list)
        for i in range(rows):
            for j in range(cols):
                sheet.write(i + 1, j, target_data_list[i][j])
        time_stamp = '{0:%Y%m%d%H%M%S}'.format(datetime.now())
        file_name = "晋城市及县区固投到位资金完成情况{}.xlsx".format(time_stamp)
        excel.save(path + file_name)
        return jsonify(code=RET.OK, url=pro_path + file_name, msg="导出/下载成功！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="批量导出操作失败！")


# 删除某时间周期的数据(固定资产投资项目资金到位)
@api_manage.route("/DeleteMoneyArrive", methods=["POST"])
def delete_money_arrive():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")

    req_dic = request.get_json()
    data_time = req_dic["data_time"]
    try:
        target_obj_li = MoneyArrive.query.filter_by(data_time=data_time, is_delete=0).all()
        for target_obj in target_obj_li:
            target_obj.is_delete = 1
            db.session.commit()
            continue
        return jsonify(code=RET.OK, msg="删除成功！")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查询数据库错误！")
