import json
import requests
import math
from flask import current_app, request, jsonify
from apps.view_radar import api_radar
from apps.models import *
from sqlalchemy import extract, or_, and_
from sqlalchemy.sql import func
from apps.util import login_required
from apps.utils.response_code import RET
from datetime import datetime
import datetime
from apps import db, constants, redis_store
from apps.utils.neo4j_conn import conn_neo4j

'''
1055 Expression #1 of SELECT list is not in GROUP BY clause and contains nonaggregated
解决办法：删除ONLY_FULL_GROUP_BY

SET GLOBAL sql_mode=(SELECT REPLACE(@@sql_mode,'ONLY_FULL_GROUP_BY',''));


/*
修改my.ini:
sql_mode=NO_ENGINE_SUBSTITUTION
*/
SELECT @@GLOBAL.SQL_mode;
SET @@GLOBAL.sql_mode=
'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';	
SET @@GLOBAL.sql_mode="NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION";

'''

graph = conn_neo4j()


# 产业分析-趋势预判
@api_radar.route('/IdusTendency', methods=['POST'])
# @login_required
def tendency():
    '''雷达监测页企业数量统计'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    select_time = req_dict.get("select_time")  # 选择2， 1年度，2季度，3月度
    select_method = req_dict.get("select_method")  # 选择3， 1新增量，2累积量

    # 校验参数完整性
    # if not all([area, sone, select_time, select_method]):
    #     return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        # name_query = "tendency" + str(inid) + str("".join(area)) + str(product) + str(sone) + str(select_time) + str(select_method)
        # if redis_store.get(name_query) is not None:
        #     data = json.loads(redis_store.get(name_query))
        #     return jsonify(code=RET.OK, msg="获取成功", data=data)

        if inid:
            enterprise = Enterprise.query.filter_by(c_type=inid)
        else:
            enterprise = Enterprise.query.filter_by()

        yearn = 2021  # 现在年份 固定成21
        scope = [i for i in range(1980, yearn)]  # 年份范围
        months = [(1, 3), (4, 6), (7, 9), (10, 12)]  # 季度
        company_num_data = list()
        register_capital_data = list()
        company_num_name = ''
        register_capital_name = ''

        if select_method == 1:  # 新增量
            if select_time == 1:  # 年度，1980-2020
                company_num_name = '新增量年度企业个数'
                register_capital_name = '新增量年度注册资本'
                for year in scope:
                    result = enterprise.filter(extract("year", Enterprise.build_date) == year)
                    # 企业个数
                    nums = result.count()
                    company_num_data.append({"label": year, "value": nums})

                    # 注册资本
                    cnums = result.with_entities(func.sum(Enterprise.capital_nums)).scalar()
                    register_capital_data.append({"label": year, "value": round(cnums, 2) if cnums else 0})
            elif select_time == 2:  # 2020年季度(修改为5年季度)
                company_num_name = '新增量季度企业个数'
                register_capital_name = '新增量季度注册资本'
                for yea in range(2016, 2021):
                    for jd in range(len(months)):
                        result = enterprise.filter(and_(extract("year", Enterprise.build_date) == yea,
                                                        extract("month", Enterprise.build_date).between(months[jd][0],
                                                                                                        months[jd][1])))
                        # 企业个数
                        nums = result.count()
                        company_num_data.append({"label": str(yea) + "-" + str(jd + 1), "value": nums})
                        # 注册资本
                        cnums = result.with_entities(func.sum(Enterprise.capital_nums)).scalar()
                        register_capital_data.append(
                            {"label": str(yea) + "-" + str(jd + 1), "value": round(cnums, 2) if cnums else 0})
            elif select_time == 3:  # 2020年月度（改为3年月度）
                company_num_name = '新增量月度企业个数'
                register_capital_name = '新增量月度注册资本'
                for yea in range(2018, 2021):
                    for m in range(2, 14, 2):
                        result = enterprise.filter(and_(extract("year", Enterprise.build_date) == yea,
                                                        extract("month", Enterprise.build_date) == m))
                        # 企业个数
                        nums = result.count()
                        # data[m] = nums
                        company_num_data.append({"label": str(yea) + "-" + str(m).rjust(2, "0"), "value": nums})
                        # 注册资本
                        cnums = result.with_entities(func.sum(Enterprise.capital_nums)).scalar()
                        # data[m] = round(cnums, 2) if cnums else 0
                        register_capital_data.append({"label": str(yea) + "-" + str(m).rjust(2, "0"),
                                                      "value": round(cnums, 2) if cnums else 0})

        elif select_method == 2:  # 累积量
            if select_time == 1:  # 年度，1980-2020
                company_num_name = '累积量年度企业个数'
                register_capital_name = '累积量年度注册资本'
                for year in scope:
                    result = enterprise.filter(extract("year", Enterprise.build_date) <= year)
                    # 企业个数
                    nums = result.count()
                    # data[year] = nums
                    company_num_data.append({"label": year, "value": nums})
                    # 注册资本
                    cnums = result.with_entities(func.sum(Enterprise.capital_nums)).scalar()
                    # data[year] = round(cnums, 2) if cnums else 0
                    register_capital_data.append({"label": year, "value": round(cnums, 2) if cnums else 0})
            elif select_time == 2:  # 2020年季度
                company_num_name = '累积量季度企业个数'
                register_capital_name = '累积量季度注册资本'
                for yea in range(2016, 2021):
                    for jd in range(len(months)):
                        result = enterprise.filter(and_(extract("year", Enterprise.build_date) == yea,
                                                        extract("month", Enterprise.build_date) <= months[jd][1]))
                        # 企业个数
                        nums = result.count()
                        # data[(jd + 1)] = nums
                        company_num_data.append({"label": str(yea) + "-" + str(jd + 1), "value": nums})
                        # 注册资本
                        cnums = result.with_entities(func.sum(Enterprise.capital_nums)).scalar()
                        # data[(jd + 1)] = round(cnums, 2) if cnums else 0
                        register_capital_data.append(
                            {"label": str(yea) + "-" + str(jd + 1), "value": round(cnums, 2) if cnums else 0})
            elif select_time == 3:  # 2020年月度
                company_num_name = '累积量月度企业个数'
                register_capital_name = '累积量月度注册资本'
                for yea in range(2018, 2021):
                    for m in range(2, 14, 2):
                        result = enterprise.filter(and_(extract("year", Enterprise.build_date) == yea,
                                                        extract("month", Enterprise.build_date) <= m))
                        # 企业个数
                        nums = result.count()
                        # data[m] = nums
                        company_num_data.append({"label": str(yea) + "-" + str(m).rjust(2, "0"), "value": nums})
                        # 注册资本
                        cnums = result.with_entities(func.sum(Enterprise.capital_nums)).scalar()
                        register_capital_data.append({"label": str(yea) + "-" + str(m).rjust(2, "0"),
                                                      "value": round(cnums, 2) if cnums else 0})
        else:
            return jsonify(code=RET.DATAERR, msg="参数错误")
        # redis缓存
        # redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(data))
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")

    # data_dic = {
    #     "company_num": company_num_data.insert(0, company_num_name),
    #     "register_capital": register_capital_data.insert(0, register_capital_name),
    # }
    data_dic = {
        "company_num": company_num_data,
        "company_num_name": company_num_name,

        "register_capital": register_capital_data,
        "register_capital_name": register_capital_name,

    }
    return jsonify(code=RET.OK, msg="获取成功", data=data_dic)


# 产业分析-top10榜单数据接口
@api_radar.route('/IdusTopTen', methods=['POST'])
# @login_required
def topt():
    '''雷达监测页企业top10'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    product = req_dict.get("product")  # 企业产品
    select = req_dict.get("select")  # 1--上市  2--专利数量  3--500强

    # 校验参数完整性
    if not all([inid]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        enterprise = Enterprise.query.filter_by(c_type=inid)
        if product:
            # 有可能会变成模糊查询
            enterprise = enterprise.filter(Enterprise.product_all.like("%{}%".format(product)))

        if select == 1:  # 上市
            company = enterprise.filter_by(quoted_company=1).group_by(Enterprise.company_name,
                                                                      Enterprise.takingn).order_by(
                Enterprise.takingn.desc()).limit(10).all()
            print(company)
            if company:
                sums = float(company[0].takingn if company[0].takingn else 1)
                data = [
                    {
                        "id": item.id,
                        "company_name": item.company_name,
                        "sum_money": str(int((float(item.takingn) if item.takingn else 0) / 10)) + '万元',
                        "h_sum": str((int(float(item.takingn) if item.takingn else 0) / sums) * 100)[:5] + "%"
                    } for item in company]
                return jsonify(code=RET.OK, msg="获取成功", data=data)
            else:
                return jsonify(code=RET.OK, msg="获取成功", data=[])
        elif select == 2:  # 专利数量
            company = enterprise.group_by(Enterprise.company_name, Enterprise.num_patent).order_by(
                Enterprise.num_patent.desc()).limit(10).all()
            if company:
                sums = float(company[0].num_patent if company[0].num_patent else 1)
                print(sums)
                data = [
                    {
                        "id": item.id,
                        "company_name": item.company_name,
                        "sum_money": str(int(int(item.num_patent if item.num_patent else 0) / 10)) + '个',
                        "h_sum": str((int(float(item.num_patent if item.num_patent else 0)) / sums) * 100)[
                                 :5] + "%"
                    } for item in company
                ]
                return jsonify(code=RET.OK, msg="获取成功", data=data)
            else:
                return jsonify(code=RET.OK, msg="获取成功", data=[])
        elif select == 3:  # 500强
            company = enterprise.filter_by(isfive=1).group_by(Enterprise.company_name, Enterprise.takingn).order_by(
                Enterprise.takingn.desc()).limit(10).all()
            if company:
                sums = float(company[0].takingn if company[0].takingn else 1)
                data = [
                    {
                        "id": item.id,
                        "company_name": item.company_name,
                        "sum_money": str(int((float(item.takingn) if item.takingn else 0) / 10)) + '万元',
                        "h_sum": str((int(float(item.takingn) if item.takingn else 0) / sums) * 100)[:5] + "%"
                    } for item in company]
                return jsonify(code=RET.OK, msg="获取成功", data=data)
            else:
                return jsonify(code=RET.OK, msg="获取成功", data=[])
        else:
            return jsonify(code=RET.DATAERR, msg="参数错误", data=[])

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 产业评估-优势薄弱缺失三环节
@api_radar.route('/ThreeLink', methods=['POST'])
# @login_required
def prolink():
    '''雷达监测页企业属性分布统计'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    # area = req_dict.get("area")  # [省，市，区]
    # province = area[0]
    # city = area[1]
    # district = area[2]

    link_type = req_dict.get("link_type")  # 缺失环节1，薄弱环节2，优势环节3
    page = req_dict.get("page")  # page
    perpage = req_dict.get("perpage")  # perpage

    # 校验参数完整性
    if not all([inid, page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        edata = EvaluationNodeData.query.filter_by(c_type=inid)
        edata = edata.filter_by(province="山西省", city="晋城市")
        edata = edata.all()

        if edata:
            num = [math.ceil(i.score) if i.score else 0 for i in edata]
            num.sort()
            num = [i for i in num if i > 0]
            cent = num[int(len(num) * 0.5)]

            deletion = len([item for item in edata if item.score == 0])  # 缺失环节
            bedness = len([item for item in edata if item.score > 0 and item.score <= cent])  # 薄弱环节
            goodness = len([item for item in edata if item.score > cent])  # 优势环节

            res = {
                "deletion": deletion,
                "goodness": goodness,
                "bedness": bedness
            }
            if link_type == 1:  # "缺失环节":
                result_bylink = [item.product for item in edata if item.score == 0]
            elif link_type == 2:  # "薄弱环节":
                result_bylink = [item.product for item in edata if item.score > 0 and item.score <= cent]
            elif link_type == 3:  # "优势环节":
                result_bylink = [item.product for item in edata if item.score > cent]
            else:
                return jsonify(code=RET.DATAERR, msg="参数错误")
            df = result_bylink[(page - 1) * perpage:page * perpage]

            data = {"df": df, "size": res}
            return jsonify(code=RET.OK, msg="获取成功", data=data)
        else:
            data = []
            return jsonify(code=RET.NODATA, msg="产业评估三环节暂无数据", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 产业评估-根据具体环节的细分产业获取相关企业
@api_radar.route('/GetLinkEnterprise', methods=['POST'])
# @login_required
def recommond():
    '''
    产品描述及企业推荐
    :return:
    '''
    req_dict = request.get_json()
    name = req_dict.get("name")  # 产品名
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")
    # select = req_dict.get("select")  # 企业地址选择

    # 校验参数完整性
    # if not all([name]):
    #     return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        enterprise = Enterprise.query.filter(Enterprise.product_all.like("%{}%".format(name)))
        size = enterprise.count()
        enterprise = enterprise.order_by(Enterprise.c_type, Enterprise.hots.desc()).paginate(page,
                                                                                             perpage).items  # # 企业热度倒序
        ent_data = []
        for com in enterprise:
            if com.city == '晋城市':
                continue
            ent_data.append({"id": com.id,
                             "company_name": com.company_name,
                             "city": com.city,
                             "district": com.district,
                             "build_date": str(com.build_date)[:10] if com.build_date else "-",  # 时间
                             "legal": com.legal,
                             "capital_nums": com.capital_nums,
                             "entype": com.entype,

                             "high_new": "高新企业" if com.high_new == "1" else "",
                             "tbe": "科技型中小企业" if com.tbe == "1" else "",
                             "fianacing": "融资企业" if com.fianacing == "1" else "",
                             "quoted_company": "上市企业" if com.quoted_company == "1" else "",
                             "dengl": "瞪羚企业" if com.dengl == "1" else "",
                             "unicorn": "独角兽企业" if com.unicorn == "1" else "",
                             "isfive": "500强企业" if com.isfive == "1" else "",

                             "tbe_sjmy": "省级民营科技企业" if com.tbe_sjmy == "1" else "",
                             "zjtg_gjjxjr": "国家级专精特新小巨人企业" if com.zjtg_gjjxjr == "1" else "",
                             "zjtg_sjxjr": "省级专精特新小巨人企业" if com.zjtg_sjxjr == "1" else "",
                             "zjtg": "专精特新企业" if com.zjtg == "1" else "",

                             "address": com.address,
                             "telephone": com.telephone
                             })
        data = {"ent_data": ent_data, "size": size}
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 优质企业-各资质企业数量
@api_radar.route('/GoodEnterpriseNum', methods=['POST'])
# @login_required
def radar_enums():
    '''雷达监测页企业数量统计'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id

    # 校验参数完整性
    if not all([inid]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        # name_query = "radar" + str(inid) + str("".join(area)) + str(product)
        # if redis_store.get(name_query) is not None:
        #     data = json.loads(redis_store.get(name_query))
        #     return jsonify(code=RET.OK, msg="获取成功", data=data)

        enterprise = Enterprise.query.filter_by(c_type=inid)
        num_all = enterprise.count()
        #  企业列表选择 1234567 500强企业-上市企业-高新技术企业-专精特新企业-独角兽企业--瞪羚企业-科技型中小企业
        num_isfive = enterprise.filter_by(isfive="1").count()  # 500强企业
        nums_quoted = enterprise.filter_by(quoted_company="1").count()  # 上市企业
        nums_hignew = enterprise.filter_by(high_new="1").count()  # 高新技术企业
        nums_zjtg = enterprise.filter_by(zjtg="1").count()  # 专精特新企业
        nums_unicorn = enterprise.filter_by(unicorn="1").count()  # 独角兽企业
        nums_dengl = enterprise.filter_by(dengl="1").count()  # 瞪羚企业
        nums_tbe = enterprise.filter_by(tbe="1").count()  # 科技型中小企业

        data = {
            "num_all": num_all,
            "num_isfive": num_isfive,
            "nums_quoted": nums_quoted,
            "nums_hignew": nums_hignew,
            "nums_zjtg": nums_zjtg,
            "nums_unicorn": nums_unicorn,  # "info": info
            "nums_dengl": nums_dengl,
            "nums_tbe": nums_tbe,
        }
        # redis缓存
        # redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(data))
        # redis_store.set(name_query, json.dumps(data))
        # redis_store.expire(name_query, 30 * 24 * 3600)
        # print("redis")

        return jsonify(code=RET.OK, msg="获取成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 优质企业-具体资质企业列表查询
@api_radar.route("/ZizhiEnterList", methods=["POST"])
def newList():
    '''查看企业列表——外加详情'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    select = req_dict.get("select")  # 企业列表选择 1234567 500强企业-上市企业-高新技术企业-专精特新企业-独角兽企业--瞪羚企业-科技型中小企业
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")

    if not all([inid, page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数错误")

    try:
        enterprise = Enterprise.query.filter_by(c_type=inid)
        remind = ''
        if select == 0:
            remind = '各资质的全部企业'
            enterprise = enterprise
        elif select == 1:
            remind = "500强企业"
            enterprise = enterprise.filter_by(isfive="1")
        elif select == 2:  # 上市
            remind = "上市企业"
            enterprise = enterprise.filter_by(quoted_company="1")
        elif select == 3:  # 高新
            remind = "高新技术企业"
            enterprise = enterprise.filter_by(high_new="1")
        elif select == 4:  # 专精特新企业
            remind = "专精特新企业"
            enterprise = enterprise.filter_by(zjtg="1")
        elif select == 5:  # 独角兽
            remind = "独角兽企业"
            enterprise = enterprise.filter_by(unicorn="1")
        elif select == 6:  # 瞪羚
            remind = "瞪羚企业"
            enterprise = enterprise.filter_by(dengl="1")
        elif select == 7:  # 科技型中小企业
            remind = "科技型中小企业"
            enterprise = enterprise.filter_by(tbe="1")

        size = enterprise.count()
        enters = enterprise.paginate(page, perpage).items

        data_list = []
        for i in enters:
            zizhi_list = {
                "high_new": "高新企业" if i.high_new == "1" else "",
                "tbe": "科技型中小企业" if i.tbe == "1" else "",
                "fianacing": "融资企业" if i.fianacing == "1" else "",
                "quoted_ipany": "上市企业" if i.quoted_company == "1" else "",
                "dengl": "瞪羚企业" if i.dengl == "1" else "",
                "unicorn": "独角兽企业" if i.unicorn == "1" else "",
                "isfive": "500强企业" if i.isfive == "1" else "",

                "tbe_sjmy": "省级民营科技企业" if i.tbe_sjmy == "1" else "",
                "zjtg_gjjxjr": "国家级专精特新小巨人企业" if i.zjtg_gjjxjr == "1" else "",
                "zjtg_sjxjr": "省级专精特新小巨人企业" if i.zjtg_sjxjr == "1" else "",
                "zjtg": "专精特新企业" if i.zjtg == "1" else "",
            }

            enter = {
                "id": i.id,
                "company_name": i.company_name,
                "city": i.city,
                "district": i.district,
                "build_date": str(i.build_date)[:10] if i.build_date else "-",  # 时间
                "legal": i.legal,
                "capital_nums": i.capital_nums,
                "entype": i.entype,
                "zizhi": zizhi_list,
                "address": i.address,
                "telephone": i.telephone
            }
            data_list.append(enter)
        data = {"remind": remind, "enter": data_list, "size": size}

        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")






# # 产品描述及推荐
# @api_radar.route('/randerSelect', methods=['GET'])
# # @login_required
# def rander_select():
#     data = [{"label": "太原", "value": "太原"}, {"label": "其它", "value": "其它"}]
#     return jsonify(code=RET.OK, msg="查询成功", data=data)


# # 创建body
# def create_body(args_query, args_term):
#     body = {
#         "query": {
#             "bool": {
#                 "must": [{"multi_match": {"query": "{}".format(args_query["query"]),  # match_phrase来实现完全匹配查询。
#                                           "type": "phrase",
#                                           "fields": [
#                                               "product"
#                                           ],
#                                           "slop": 0,
#                                           }
#                           },
#                          ]
#             }
#         },
#         "from": 0,
#         "size": 10,
#         "sort": [],
#         "aggs": {},
#         "_source": ['company_name'],
#
#     }
#
#     for k, v in args_term.items():
#         body["query"]["bool"]["must"].append({"term": {"{}".format(k): "{}".format(v)}})
#
#     return body
#
#
# # 通过节点判断优势薄弱和缺失，1优势、2薄弱、3缺失
# def get_waa(pname_two, inid, area):
#     province = area[0]
#     city = area[1]
#     district = area[2]
#
#     try:
#         edata = EvaluationNodeData.query.filter_by(c_type=inid)
#         if not province:
#             edata = edata.filter(EvaluationNodeData.province.is_(None)).filter(
#                 EvaluationNodeData.city.is_(None)).filter(EvaluationNodeData.district.is_(None))
#         if province and not city:
#             edata = edata.filter_by(province=province).filter(EvaluationNodeData.city.is_(None)).filter(
#                 EvaluationNodeData.district.is_(None))
#         if province and city and not district:
#             edata = edata.filter_by(province=province, city=city).filter(EvaluationNodeData.district.is_(None))
#         if province and city and district:
#             edata = edata.filter_by(province=province, city=city, district=district)
#         edata = edata.all()
#
#         if edata:
#             num = [math.ceil(i.score) if i.score else 0 for i in edata]
#             num.sort()
#             num = [i for i in num if i > 0]
#             cent = num[int(len(num) * 0.5)]
#             youshi = [item.product for item in edata if item.score > cent]  # 优势
#             queshi = [item.product for item in edata if item.score == 0]  # 缺失
#             weak = [item.product for item in edata if item.score > 0 and item.score <= cent]  # 薄弱
#         else:
#             youshi = []  # 优势
#             queshi = []  # 缺失
#             weak = []  # 薄弱
#         if pname_two in youshi:
#             return 1
#         if pname_two in weak:
#             return 2
#         if pname_two in queshi:
#             return 3
#     except Exception as e:
#         current_app.logger.error(e)
#         return 2
#
#
# # 通过es全匹配查询三级
# def find_thr_by_es(inid, name_query, relation, area):
#     if relation == "中游行业":
#         relation_c = "下位产品"
#     else:
#         relation_c = relation
#
#     args_term = dict()  # 省市区条件
#     if area[0]:
#         args_term['province'] = area[0]
#     if area[1]:
#         args_term['city'] = area[1]
#     if area[2]:
#         args_term['district'] = area[2]
#     args_term['c_type'] = inid  # 指定二级企业分类
#     url = "http://127.0.0.1:9200/ty_cur/_search"
#
#     sql_01 = "match (n) -[r:`{}`]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(relation_c, name_query)
#     res_zero = graph.run(sql_01).data()
#     res_one = list(set([i["m.name"] for i in list(res_zero)]))  # 不重复的一级节点
#     data = {"clickable": False,
#             "node": "{}".format(relation[:2]),
#             "level": 1,
#             "subNodeList": [],
#             # "count": cnums
#             }
#
#     for it in res_one:
#         pname_one = it
#
#         # es全匹配查询企业数量
#         args_query = dict()  # 产品
#         args_query["query"] = pname_one
#         body = create_body(args_query, args_term)
#         result_es = json.loads(requests.post(url=url, json=body).text)
#         erjicount = int(result_es["hits"]["total"])
#
#         node_one = {"clickable": True,
#                     "node": "{}".format(pname_one),
#                     "level": 2,
#                     "count": erjicount,
#                     "subNodeList": []
#                     }
#         sql_02 = "match (n) -[r]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(pname_one)
#         result = graph.run(sql_02).data()
#         result = list(set([i["m.name"] for i in list(result)]))  # 不重复的二级节点
#         for item in result:
#             pname_two = item
#             # es全匹配查询企业数量
#             args_query = dict()  # 产品
#             args_query["query"] = pname_two
#             body = create_body(args_query, args_term)
#             result_es = json.loads(requests.post(url=url, json=body).text)
#             count2 = int(result_es["hits"]["total"])
#             # 二级节点
#             node_two = {"clickable": True,
#                         "node": "{}".format(pname_two),
#                         "level": 3,
#                         "count": count2,
#                         "subNodeList": [],
#                         "waa": get_waa(pname_two, inid, area)  # 1优势、2薄弱、3缺失
#                         }
#             sql_03 = "match (n) -[r]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(pname_two)
#             result3 = graph.run(sql_03).data()
#             result3 = list(set([i["m.name"] for i in list(result3)]))  # 不重复的三级节点
#             for itm in result3:
#                 pname_thr = itm
#                 args_query = dict()  # 产品
#                 args_query["query"] = pname_thr
#                 body = create_body(args_query, args_term)
#                 result_es = json.loads(requests.post(url=url, json=body).text)
#                 count3 = int(result_es["hits"]["total"])
#                 # 三级
#                 node_thr = {"clickable": True,
#                             "node": "{}".format(pname_thr),
#                             "level": 4,
#                             "count": count3,
#                             "subNodeList": []
#                             }
#                 node_two["subNodeList"].append(node_thr)
#             node_one["subNodeList"].append(node_two)
#         data["subNodeList"].append(node_one)
#
#     return data
#
#
# # 行业产品公司数量(链图)
# @api_radar.route('/map/chain', methods=['POST'])
# # @login_required
# def attract_chain():
#     '''行业id->行业链标题-》上中下游-》查询数值'''
#     req_dict = request.get_json()
#     inid = req_dict.get("inid")  # 二级行业id（二级行业显示链图）
#     area = req_dict.get("area")  # ["","",""] 省市区
#
#     # 校验参数完整性
#     if not all([inid]):
#         return jsonify(code=RET.PARAMERR, msg="参数不完整")
#
#     try:
#         name_query = "radar" + str(inid) + str("".join(area))
#         if redis_store.get(name_query) is not None:
#             data = json.loads(redis_store.get(name_query))
#             return jsonify(code=RET.OK, msg="获取成功", data=data)
#
#         # 行业使用名
#         industryName = Industry.query.filter_by(nid=inid).first().oname
#         ptp = {"轨道交通": "轨道交通装备",
#                "新能源汽车": "新能源汽车整车制造",
#                "智能煤机": "智能煤机",
#                "数控机床及机器人": "数控机床及机器人",
#
#                "通用航空": "通用航空",
#                "智能电网": "智能电网",
#                "氢能": "氢能",
#                "碳基新材料": "碳基新材料",
#
#                "金属新材料": "金属新材料",
#                "煤化工新材料": "煤化工新材料",
#                "生物基新材料": "生物基新材料",
#                "信息技术应用创新": "信息创新技术",
#
#                "网络安全": "网络安全",
#                "云计算": "云计算产业",
#                "大数据及人工智能": "大数据及人工智能",
#                "物联网": "物联网",
#
#                "康养产业": "康养产业",
#                "生物制药": "生物制药",
#                "现代物流": "现代物流",
#                "现代金融": "现代金融",
#
#                "半导体及光电子": "半导体",
#                "节能环保": "节能环保"
#                }
#         if industryName in ptp:
#             industryName = ptp[industryName]
#         result = {
#             "industryChain": industryName,
#             "nodeList": [find_thr_by_es(inid, industryName, "上游行业", area),
#                          find_thr_by_es(inid, industryName, "中游行业", area),
#                          find_thr_by_es(inid, industryName, "下游行业", area)]
#         }
#         # redis缓存
#         redis_store.set(name_query, json.dumps(result))
#         redis_store.expire(name_query, 30 * 24 * 3600)
#         print("redis")
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据异常")
#
#     return jsonify(code=RET.OK, msg="获取成功", data=result)
#
#
# # 雷达监测页企业属性分布统计
# @api_radar.route('/radar/distribute', methods=['POST'])
# # @login_required
# def distribute():
#     '''雷达监测页企业属性分布统计'''
#     req_dict = request.get_json()
#     inid = req_dict.get("inid")  # 行业id
#     area = req_dict.get("area")  # [省，市，区]
#     province = area[0]
#     city = area[1]
#     district = area[2]
#     product = req_dict.get("product")  # 企业产品
#
#     # 校验参数完整性
#     if not all([area]):
#         return jsonify(code=RET.PARAMERR, msg="参数不完整")
#
#     try:
#         if inid:
#             enterprise = Enterprise.query.filter_by(c_type=inid)
#         else:
#             enterprise = Enterprise.query.filter_by()
#
#         if province:
#             enterprise = enterprise.filter_by(province=province)
#             if city:
#                 enterprise = enterprise.filter_by(city=city)
#                 if district:
#                     enterprise = enterprise.filter_by(district=district)
#
#         if product:
#             # 有可能会变成模糊查询
#             enterprise = enterprise.filter(Enterprise.product_all.like("%{}%".format(product)))
#
#         # 企业类型
#
#         types = enterprise.with_entities(Enterprise.entype).distinct().all()
#         types = [item[0] for item in types if item[0]]
#         data_1 = list()
#         for i in types:
#             c_num = enterprise.filter_by(entype=i).count()
#             data_1.append({"name": i, "value": c_num})
#         # data_1 = {k: round(v / sum(data_1.values()), 2) for k, v in data_1.items()}
#
#         # 币种,不能为空
#         types = enterprise.with_entities(Enterprise.money_type).distinct().all()
#         types = [item[0] for item in types if item[0]]
#         data_2 = list()
#         for i in types:
#             c_num = enterprise.filter_by(money_type=i).count()
#             data_2.append({"name": i, "value": c_num})
#         # data_2 = {k: round(v / sum(data_2.values()), 2) for k, v in data_2.items()}
#         # data_2 = {'人民币': 0.02, "None": 0.97, '美元': 0.01}  # 正式数据不能为空，None不能以变量出现
#
#         # 成立时间分布yearid
#         types = enterprise.with_entities(Enterprise.yearid).distinct().all()
#         types = [item[0] for item in types if item[0]]
#         data_3 = list()
#         dic_year = {1: "1-3年", 2: "3-5年", 3: "5-8年", 4: "8-10年", 5: "10-15年", 6: "15年以上"}
#         for i in types:
#             if i in dic_year:
#                 c_num = enterprise.filter_by(yearid=i).count()
#                 data_3.append({"name": dic_year[i], "value": c_num})
#         # data_3 = {k: round(v / sum(data_3.values()), 2) for k, v in data_3.items()}
#
#         # 注册资本大小分布
#         types = enterprise.with_entities(Enterprise.capital_id).distinct().all()
#         types = [item[0] for item in types if item[0]]
#         data_4 = list()
#         dic_capital = {1: "100万以内", 2: "100-500万", 3: "500-1000万", 4: "1000-5000万", 5: "5000万-1亿", 6: "1亿以上"}
#         for i in types:
#             if i in dic_capital:
#                 c_num = enterprise.filter_by(capital_id=i).count()
#                 data_4.append({"name": dic_capital[i], "value": c_num})
#         # data_4 = {k: round(v / sum(data_4.values()), 2) for k, v in data_4.items()}
#
#         # 上市板块
#         plates = enterprise.with_entities(Enterprise.public_sector).distinct().all()
#         # types = [item[0] for item in types if item[0]]
#         data_5 = list()
#         for i in plates:
#             if i[0] == "空" or i[0] is None:
#                 continue
#             c_num = enterprise.filter_by(public_sector=i[0]).count()
#             data_5.append({"name": i[0], "value": c_num})
#         # data_5 = {k: round(v / sum(data_5.values()), 2) for k, v in data_5.items()}
#
#         # 融资轮次分布（按融资轮次）
#         rounds = enterprise.with_entities(Enterprise.fianacing_rounds).distinct().all()
#         data_6 = list()
#         for i in rounds:
#             if i[0] == "空" or i[0] is None:
#                 continue
#             c_num = enterprise.filter_by(fianacing_rounds=i[0]).count()
#             data_6.append({"name": i[0], "value": c_num})
#         # data_6 = {k: round(v / sum(data_6.values()), 2) for k, v in data_6.items()}
#
#         data = {"entype": data_1,  # 企业类型
#                 "currency": data_2,  # 币种
#                 "time_distribute": data_3,  # 成立时间分布
#                 "capital": data_4,  # 注册资本分部
#                 "sector": data_5,  # 上市板块
#                 "rounds": data_6}  # 融资轮次
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库查询错误")
#
#     return jsonify(code=RET.OK, msg="获取成功", data=data)
#
#
# # 雷达评估页行业地区分数评估
# @api_radar.route('/radar/evaluation', methods=['POST'])
# # @login_required
# def evaluation():
#     '''雷达监测页企业属性分布统计'''
#     req_dict = request.get_json()
#     inid = req_dict.get("inid")  # 二级行业id
#     area = req_dict.get("area")  # [省，市，区]
#     province = area[0]
#     city = area[1]
#     district = area[2]
#
#     # 校验参数完整性
#     if not all([inid, area]):
#         return jsonify(code=RET.PARAMERR, msg="参数不完整")
#
#     try:
#         edata = EvaluationData.query.filter_by(c_type=inid)
#         if province and not city:
#             edata = edata.filter_by(province=province).filter(EvaluationData.city.is_(None))
#         if province and city and not district:
#             edata = edata.filter_by(province=province, city=city).filter(EvaluationData.district.is_(None))
#         if province and city and district:
#             edata = edata.filter_by(province=province, city=city, district=district)
#         edata = edata.first()
#         if edata:
#             data = {"development": edata.development,  # 发育度
#                     "contribute": edata.contribute,  # 贡献度
#                     "innovate": edata.innovate,  # 创新力
#                     "growup": edata.growup,  # 成长性
#                     "capital": edata.capital,  # 资本力
#                     "general": edata.general}  # 综合分
#             return jsonify(code=RET.OK, msg="获取成功", data=data)
#         else:
#             data = {"development": 0,
#                     "contribute": 0,
#                     "innovate": 0,
#                     "growup": 0,
#                     "capital": 0,
#                     "general": 0}
#             return jsonify(code=RET.NODATA, msg="无数据", data=data)
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库查询错误")
