from flask import current_app, request, jsonify
from apps.view_mobile import api_mobile
from sqlalchemy import extract, or_, and_
from sqlalchemy.sql import func
from apps.models import *
from apps.util import login_required, verify_token
from apps.utils.response_code import RET
from datetime import datetime, timedelta
import re
from apps import db, constants, redis_store


# 手机端个人中心信息获取
@api_mobile.route('/userInfo', methods=['GET'])
@login_required
def user_info():
    # 获取用户id
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id  # 用户id
    # user_id = 5  # 用户id

    try:
        user = User.query.get(user_id)
        if user:
            data = {"id": user.id,
                    "name": user.name if user.name else "-",  # 用户名
                    "mobile": user.mobile,  # 手机号
                    "unit": user.unit if user.unit else "",  # 机构
                    "section": user.section if user.section else "",  # 部门
                    "position": user.position if user.position else "",  # 职务
                    "sex": user.sex if user.sex else "",  # 性别，1男2女
                    "email": user.email if user.email else ""  # 邮箱
                    }
            return jsonify(code=RET.OK, msg="查询成功", data=data)
        return jsonify(code=RET.NODATA, msg="无法获取信息")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="参数错误")


# 手机端个人中心用户名修改
@api_mobile.route('/editName', methods=['POST'])
# @login_required
def edit_name():
    # 获取用户id
    # token = request.headers["token"]
    # user = verify_token(token)
    # user_id = user.id  # 用户id
    # user_id = 5  # 用户id
    req_dict = request.get_json()
    uname = req_dict.get("uname")  # 用户名
    user_id = req_dict.get("id")  # 用户id
    # 校验参数完整性
    if not all([uname]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 用户名唯一(字母开头，长度4-15)
    try:
        patten = "^[a-zA-Z][\w]*[\w]*$"
        if re.match(patten, uname) and re.match(patten, uname).string == uname:
            user = User.query.filter_by(name=uname).filter(User.id != user_id).first()
            if user:
                return jsonify(code=RET.DATAEXIST, msg="用户名已存在")
        else:
            return jsonify(code=RET.DATAERR, msg="用户名格式错误,字母开头")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="用户名格式错误")

    try:
        user = User.query.get(user_id)
        user.name = uname
        db.session.commit()

        return jsonify(code=RET.OK, msg="修改成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="参数错误")


# 修改手机号
@api_mobile.route("/editPhone", methods=["POST"])
# @login_required
def edit_phone():
    # token = request.headers["token"]
    # user = verify_token(token)
    # user_id = user.id
    # user_id = 5

    req_dict = request.get_json()
    user_id = req_dict.get("user_id")
    mobile = req_dict.get("mobile")
    sms_code = req_dict.get("sms_code")
    # 校验参数完整性
    if not all([mobile, mobile]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 校验手机号格式
    if not re.match(r'^1[3456789]\d{9}$', mobile):
        return jsonify(code=RET.PARAMERR, msg="手机号格式错误")

    # 判断短信验证码是否失效
    if not redis_store:
        return jsonify(code=RET.NODATA, msg="短信验证码失效")
    # 获取短信验证码
    try:
        real_sms_code = redis_store.get('sms_code_{}'.format(mobile)).decode()
        # real_sms_code = "123456"
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="redis数据库异常")

    # 判断用户填写短信验证码是否一致
    if real_sms_code != sms_code:
        # if "123456" != sms_code:
        return jsonify(code=RET.DATAERR, msg="短信验证码错误")

    # 删除redis中的短信验证码，防止重复校验
    try:
        redis_store.delete("sms_code_{}".format(mobile))
    except Exception as e:
        current_app.logger.error(e)

    # 获取用户
    try:
        user = User.query.filter_by(mobile=mobile).first()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="获取用户信息失败")

    if user:
        return jsonify(code=RET.DATAEXIST, msg="手机号已被注册")

    # 修改手机号
    try:
        user = User.query.get(user_id)
        user.mobile = mobile
        db.session.commit()
        return jsonify(code=RET.OK, msg="修改成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 手机端个人中心性别修改
@api_mobile.route('/editSex', methods=['POST'])
# @login_required
def edit_sex():
    # 获取用户id
    # token = request.headers["token"]
    # user = verify_token(token)
    # user_id = user.id  # 用户id
    # user_id = 5  # 用户id
    req_dict = request.get_json()
    user_id = req_dict.get("id")  # 用户id
    sex = req_dict.get("sex")  # 男1女2
    # 校验参数完整性
    if not all([sex]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        user = User.query.get(user_id)
        user.sex = sex
        db.session.commit()
        return jsonify(code=RET.OK, msg="修改成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="参数错误")
