from flask import current_app, request, jsonify
from apps.view_atlas import api_atlas
from apps.util import login_required
from apps.utils.response_code import RET
from apps.models import *
from apps.utils.neo4j_conn import conn_neo4j, neo4j_dict
from apps import redis_store
import json

graph = conn_neo4j()

'''行业名转换ptp字典两个  neo4j_dict  line 164/177'''


def deleteDuplicate(li):
    '''列表[字典]去重'''
    temp_list = list(set([str(i) for i in li]))
    li = [eval(i) for i in temp_list]
    return li


def find_up_thr(name_query, relation):
    if relation == "中游行业":
        relation_c = "下位产品"
    else:
        relation_c = relation

    # 零级，上中下三游
    data = {
        "node": "{}".format(relation[:2]),
        "level": 1,
        "subNodeList": [],
    }
    sql_01 = "match (n) -[r:`{}`]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(relation_c, name_query)
    res_zero = graph.run(sql_01).data()
    res_one = list(set([i["m.name"] for i in list(res_zero)]))  # 不重复的一级节点
    for it in res_one:  # 一级节点
        pname_one = it
        # 一级
        node_one = {
            "node": "{}".format(pname_one),
            "level": 2,
            "subNodeList": []
        }
        sql_02 = "match (n) -[r]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(pname_one)
        result = graph.run(sql_02).data()
        result = list(set([i["m.name"] for i in list(result)]))  # 不重复的二级节点
        for item in result:
            pname_two = item
            # 二级
            node_two = {
                "node": "{}".format(pname_two),
                "level": 3,
                "subNodeList": []
            }
            sql_03 = "match (n) -[r]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(pname_two)
            result3 = graph.run(sql_03).data()
            result3 = list(set([i["m.name"] for i in list(result3)]))  # 不重复的三级节点
            for itm in result3:
                pname_thr = itm
                # 三级
                node_thr = {
                    "node": "{}".format(pname_thr),
                    "level": 4,
                    "subNodeList": []
                }
                node_two["subNodeList"].append(node_thr)
            node_one["subNodeList"].append(node_two)
        data["subNodeList"].append(node_one)
    return data


# 获取产业集群名称
@api_atlas.route('/industry/cluster', methods=['GET'])
def get_cluster():
    try:
        cluster_obj = Industry.query.filter_by(fid=0).all()

        data = {
            "cluster": [
                {"id": i.nid, 'industry_level': 1, 'name': i.name,
                 "subNodeList": [{'id': j.nid, 'industry_level': 2, "name": j.name} for j in
                                 Industry.query.filter_by(fid=i.nid)]} for i in
                cluster_obj]

        }
        return jsonify(code=RET.OK, msg='产业集群名称获取成功！', data=data)
    except Exception as e:
        current_app.logger.error(e)


# 返回上中下游产业链数据接口
@api_atlas.route('/industry/chain', methods=['POST'])
# @login_required
def industry_chain():
    '''
    行业id->行业链标题-》上中下游-》查询数值
    :return:
    '''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 二级行业id（二级行业显示链图）

    # 校验参数完整性
    if not all([inid]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        # name_query = "jc" + str(inid) + str(district)
        # if redis_store.get(name_query) is not None:
        #     data = json.loads(redis_store.get(name_query))
        #     return jsonify(code=RET.OK, msg="获取成功", data=data)

        # 行业使用名
        industryName = Industry.query.filter_by(nid=inid).first().oname
        ptp = neo4j_dict()
        if industryName in ptp:
            industryName = ptp[industryName]
        # print(industryName)
        result = {
            "industryChain": industryName,
            "nodeList": [find_up_thr(industryName, "上游行业"),
                         find_up_thr(industryName, "中游行业"),
                         find_up_thr(industryName, "下游行业")]
        }
        # redis缓存
        # redis_store.set(name_query, json.dumps(result))
        # redis_store.expire(name_query, 30 * 24 * 3600)
        # print("redis")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")
    return jsonify(code=RET.OK, msg="获取成功", data=result)


# 点击产业联动显示企业
@api_atlas.route('/industry/enterprise', methods=['POST'])
# @login_required
def industry_enterprise():
    '''骨干企业数据'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    industry_level = req_dict.get("industry_level")  # 行业等级,（父行个为"1",子行业为"2"）
    product = req_dict.get("product")
    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小
    # sorts = req_dict.get("sorts")  # 排序 sorts "1"按时间降序 ，“2”按热度降序

    # 校验参数完整性
    if not all([industry_level, page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if industry_level == 1:
            company = Company.query.filter_by(f_type=inid, city="晋城市")
        else:
            company = Company.query.filter_by(c_type=inid, city="晋城市")

            if product:
                company = Company.query.filter(Company.product_all.like("%{}%".format(product)))

        size = company.count()
        companys = company.order_by(Company.hots.desc()).paginate(page, perpage).items  # 企业热度倒序

        df = [{"id": i.id,
               "company_name": i.company_name,
               "district": i.district,
               "build_date": (i.build_date).strftime("%Y-%m-%d %H:%M:%S"),
               "legal": i.legal,
               "capital_nums": i.capital_nums,
               "entype": i.entype,
               "address": i.address,
               "telephone": i.telephone,
               "high_new": '高新技术企业' if i.high_new == '1' else '',
               "tbe": '科技型中小企业' if i.tbe == '1' else '',
               "quoted_company": '上市企业' if i.quoted_company == '1' else '',
               "zjtg": '精专特新企业' if i.zjtg == '1' else '',
               "unicorn": '独角兽企业' if i.unicorn == '1' else '',
               "dengl": '瞪羚企业' if i.dengl == '1' else '',
               "isfive": '五百强企业' if i.isfive == '1' else '',
               "scale": '规模以上企业' if i.scale == '1' else ''
               } for i in companys]
        data = {"size": size, "df": df}
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")

    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 点击产业创新资源联动显示 innovation resource
@api_atlas.route('/innovate/resource', methods=['POST'])
def industry_resource():
    '''创新资源机构列表'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    industry_level = req_dict.get("industry_level")  # 行业等级,（父行业高端设备等五个为"1",子行业为"2"）

    select_flag = req_dict.get("select_flag")  # 机构类型id. 高等院校1,科研机构2，创新平台3，产业服务平台4

    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小

    # 校验参数完整性
    if not all([inid, industry_level, select_flag, page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    name = Industry.query.filter_by(nid=inid).first().oname

    if select_flag == 1:  # 高等院校
        try:
            if industry_level == 1:
                college = College.query.filter(College.navigator.like("%{}%".format(name)))
            else:
                college = College.query.filter(College.navigat.like("%{}%".format(name)))
            size = college.count()
            college = college.paginate(page, perpage).items

            data = {"df": [{"id": i.id,
                            "name": i.name,
                            "admin": i.admin,
                            "buildate": i.buildate,
                            "charge": i.charge,
                            "cate": i.category,
                            "nature": i.nature,
                            "ccode": i.ccode,
                            "address": i.address,
                            } for i in college],
                    "size": size}
            return jsonify(code=RET.OK, msg="查询成功", data=data)
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DATAERR, msg="参数错误")
    elif select_flag == 2:  # 科研机构
        if industry_level == 1:
            scientific = Scientific.query.filter(Scientific.navigator.like("%{}%".format(name)))
        else:
            scientific = Scientific.query.filter(Scientific.navigat.like("%{}%".format(name)))
        size = scientific.count()
        scientific = scientific.paginate(page, perpage).items
        data = {"df": [{"id": i.id,
                        "name": i.name,
                        "admin": i.admin,
                        "telephone": i.telephone,
                        "fax": i.fax,
                        "postcode": i.postcode,
                        "address": i.address} for i in scientific],
                "size": size}
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    elif select_flag == 3:  # 创新平台3
        if industry_level == 1:
            lab = Lab.query.filter(Lab.navigator.like("%{}%".format(name)))
        else:
            lab = Lab.query.filter(Lab.navigat.like("%{}%".format(name)))
        size = lab.count()
        lab = lab.paginate(page, perpage).items
        data = {"df": [{"id": i.id,
                        "name": i.name,
                        "admin": i.admin,
                        "cate": i.cate,
                        "fax": i.fax,
                        "postcode": i.postcode,
                        "address": i.address} for i in lab],
                "size": size}
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    else:
        return jsonify(code=RET.PARAMERR, msg="参数错误")


def get_data(name, industry_level, select_flag, page, perpage):
    try:
        if select_flag in [1, 2]:  # 当选择行政区/园区时
            if select_flag == 1 and industry_level == 1:  # 当选择的是父产业的行政区时
                induzone = Induzone.query.filter(Induzone.cate.like('行政区'), Induzone.navigator.like("%{}%".format(name)))
            elif select_flag == 1 and industry_level == 2:  # 当选择的是子产业的行政区时
                induzone = Induzone.query.filter(Induzone.cate.like('行政区'), Induzone.navigat.like("%{}%".format(name)))
            elif select_flag == 2 and industry_level == 1:  # 当选择的是父产业的园区时
                induzone = Induzone.query.filter(Induzone.cate.like('产业园区'), Induzone.navigator.like("%{}%".format(name)))
            elif select_flag == 2 and industry_level == 2:  # 当选择的是子产业的园区时
                induzone = Induzone.query.filter(Induzone.cate.like('产业园区'), Induzone.navigat.like("%{}%".format(name)))

            size = induzone.count()  # 分页总数
            induzone = induzone.paginate(page, perpage).items

            if select_flag == 1:
                # 封装行政区数据
                admin_data = {"admin_data": [{
                    "id": i.id,
                    "image": i.image,
                    # "region": i.region,
                    "region": i.district,
                    "cate": i.cate,  # 园区类型
                    "area": i.area,
                    "address": i.address,
                    "cluster": i.cluster} for i in induzone],
                    "size": size}
                return admin_data

            if select_flag == 2:
                # 封装园区数据
                garden_data = {"garden": [{"id": i.id,
                                           "name": i.name,  # 园区名称
                                           "region": i.region,  # 所属地区
                                           "phone": i.phone,  # 联系电话
                                           "level": i.level,  # 园区级别
                                           "cate": i.cate,  # 园区类型
                                           "address": i.address, } for i in induzone],  # 园区地址
                               "size": size}
                return garden_data

        if select_flag == 3:  # 当选择载体土地时
            if industry_level == 1:  # 当选择的是父产业时
                land = ZaitiLand.query.filter(ZaitiLand.navigator.like("%{}%".format(name)))
            else:
                land = ZaitiLand.query.filter(ZaitiLand.navigat.like("%{}%".format(name)))
            size = land.count()  # 分页总数
            land = land.paginate(page, perpage).items

            # 封装土地数据
            land_data = {"land_data": [{
                "id": i.id,
                "name": i.name,
                "num": i.num,
                "nature": i.nature,
                "acreage": i.acreage,
                "industry_type": i.industry_type,
                "telephone": i.telephone
            } for i in land], "size": size}
            return land_data

        if select_flag == 4:  # 当选择载体楼宇时
            if industry_level == 1:  # 当选择的是父产业时
                build = ZaitiBuild.query.filter(ZaitiBuild.navigator.like("%{}%".format(name)))
            else:
                build = ZaitiBuild.query.filter(ZaitiBuild.navigat.like("%{}%".format(name)))
            size = build.count()  # 分页总数
            build = build.paginate(page, perpage).items

            # 封装楼宇数据
            build_data = {
                "build_data": [{
                    "id": i.id,
                    "name": i.name,
                    "acreage": i.acreage,
                    "buide_type": i.buide_type,
                    "industry_type": i.industry_type,
                    "telephone": i.telephone,
                    "addr": i.addr,
                } for i in build], "size": size
            }
            return build_data

        if select_flag == 5:  # 当选择载体厂房时
            if industry_level == 1:  # 当选择的是父产业时
                factory = ZaitiFactory.query.filter(ZaitiFactory.navigator.like("%{}%".format(name)))
            else:
                factory = ZaitiFactory.query.filter(ZaitiFactory.navigat.like("%{}%".format(name)))
            size = factory.count()  # 分页总数
            factory = factory.paginate(page, perpage).items

            # 封装楼宇数据
            factory_data = {
                "factory_data": [{
                    "id": i.id,
                    "name": i.name,
                    "acreage": i.acreage,
                    "factory_type": i.factory_type,
                    "industry_type": i.industry_type,
                    "telephone": i.telephone,
                    "addr": i.addr,
                } for i in factory], "size": size
            }
            return factory_data
    except Exception as e:
        print(e)
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 产业载体
@api_atlas.route('/carrier/zaiti', methods=['POST'])
def industry_zaiti():
    '''产业载体数据'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    industry_level = req_dict.get("industry_level")  # 行业等级,（父行业高端设备等五个为"1",子行业为"2"）
    select_flag = req_dict.get("select_flag")  # 1为行政区，2为园区，3为产业载体，4为土地，5为楼宇，6为厂房
    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小

    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # if inid:
    name = Industry.query.filter_by(nid=inid).first().oname  # 获取导航对应的真名
    try:
        data = get_data(name, industry_level, select_flag, page, perpage)
        return jsonify(code=RET.OK, msg="数据查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)


#  产业政策
@api_atlas.route('/industry/indus_policy', methods=['POST'])
def industry_policy():
    """产业政策数据"""
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    industry_level = req_dict.get("industry_level")  # 行业等级,（父行业高端设备等五个为1,子行业为2）
    policy_level = req_dict.get("policy_level")  # 政策等级，（国家级为1，省级为2，市级为3，区县为4，开发区为5）
    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小

    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        indu_policy = ''
        size = ''
        name = Industry.query.filter_by(nid=inid).first().oname  # 获取导航对应的真名
        print(name)
        if industry_level == 1:
            if policy_level == 1:  # 国家级
                indu_policy = InduPolicy.query.filter(InduPolicy.navigator.like("%{}%".format(name)), InduPolicy.level=="国家级")
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            if policy_level == 2:  # 省级
                indu_policy = InduPolicy.query.filter(InduPolicy.navigator.like("%{}%".format(name)), InduPolicy.level=="省级")
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            if policy_level == 3:  # 市级
                indu_policy = InduPolicy.query.filter(InduPolicy.navigator.like("%{}%".format(name)), InduPolicy.level=="市级")
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            if policy_level == 4:  # 区县
                indu_policy = InduPolicy.query.filter(InduPolicy.navigator.like("%{}%".format(name)), InduPolicy.level=="区县")
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            if policy_level == 5:  # 开发区
                indu_policy = InduPolicy.query.filter(InduPolicy.navigator.like("%{}%".format(name)), InduPolicy.level=="开发区")
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
        if industry_level == 2:
            if policy_level == 1:  # 国家级
                indu_policy = InduPolicy.query.filter(InduPolicy.navigat.like("%{}%".format(name)), InduPolicy.level=="国家级")
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            if policy_level == 2:  # 省级
                indu_policy = InduPolicy.query.filter(InduPolicy.navigat.like("%{}%".format(name)), InduPolicy.level=="省级")
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            if policy_level == 3:  # 市级
                indu_policy = InduPolicy.query.filter(InduPolicy.navigat.like("%{}%".format(name)), InduPolicy.level=="市级")
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            if policy_level == 4:  # 区县
                indu_policy = InduPolicy.query.filter(InduPolicy.navigat.like("%{}%".format(name)), InduPolicy.level=="区县")
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            if policy_level == 5:  # 开发区
                indu_policy = InduPolicy.query.filter(InduPolicy.navigat.like("%{}%".format(name)), InduPolicy.level=="开发区")
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    # 封装政策数据
    policy_data = {
        "policy_data": [{
            "id": i.id,
            "name": i.name,
            "org": i.org,
            "pubdate": (i.pubdate).strftime("%Y-%m-%d")
        } for i in indu_policy],
        "size": size
    }
    return jsonify(code=RET.OK, msg="政策数据查询成功", data=policy_data)


# 产业政策详情信息-复用招商驾驶舱政策详情接口


# 骨干企业详情信息


# 创新资源-高等院校详情
@api_atlas.route('/innovate/college_detail', methods=['POST'])
def get_college_detail():
    req_dict = request.get_json()
    college_id = req_dict.get('id')
    try:
        college = College.query.filter_by(id=college_id).first()
        # 封装院校数据
        data = {
            "name": college.name,  # 校名
            "charge": college.charge,  # 主管部门
            "buildate": college.buildate,  # 创办时间
            "nature": college.nature,  # 办学性质
            "clas": college.clas,  # 学校类别
            "address": college.address,  # 校址
            "introduct": college.introduct,  # 简介
            "ccode": college.ccode,  # 学校代码
            "feature": college.feature,  # 学校特色
            "research": college.research,  # 研究方向
            "major": college.major,
            "faculty": college.faculty,
            "lng": college.lng,  # 经度
            "lat": college.lat  # 纬度
        }
        return jsonify(code=RET.OK, msg='院校详情查询成功！', data=data)

    except Exception as e:
        current_app.logger.error(e)


# 创新资源-科研机构详情
@api_atlas.route('/innovate/scientific_detail', methods=['POST'])
def get_scientific_detail():
    req_dict = request.get_json()
    scientific_id = req_dict.get('id')
    try:
        scientific = Scientific.query.filter_by(id=scientific_id).first()
        # 封装科研机构数据
        data = {
            "name": scientific.name,  # 名称
            "admin": scientific.admin,  # 行政区
            "telephone": scientific.telephone,  # 联系电话
            "fax": scientific.fax,  # 传真
            "postcode": scientific.postcode,  # 邮编
            "address": scientific.address,  # 地址
            "introduct": scientific.introduct,  # 简介
            "lng": scientific.lng,  # 经度
            "lat": scientific.lat  # 纬度
        }
        return jsonify(code=RET.OK, msg='科研机构详情查询成功！', data=data)
    except Exception as e:
        current_app.logger.error(e)


# 创新资源-创新平台详情
@api_atlas.route('/innovate/Lab_detail', methods=['POST'])
def get_lab_detail():
    req_dict = request.get_json()
    lab_id = req_dict.get('id')
    try:
        lab = Lab.query.filter_by(id=lab_id).first()
        # 封装创新平台数据
        data = {
            "name": lab.name,  # 名称
            "address": lab.address,  # 地址
            "introduct": lab.introduct,  # 简介
            "lng": lab.lng,  # 经度
            "lat": lab.lat  # 纬度
        }
        return jsonify(code=RET.OK, msg='创新平台详情查询成功！', data=data)
    except Exception as e:
        current_app.logger.error(e)


# 产业载体-各类型详情信息
@api_atlas.route('/carrier/zaiti_detail', methods=['POST'])
def get_zaiti_detail_data():
    req_dict = request.get_json()
    id = req_dict.get('id')
    cate_id = req_dict.get('cate_id')  # 1为行政区，2为园区，3为土地，4为楼宇，5为厂房
    print(cate_id)

    if cate_id in [1, 2]:
        try:
            induzone = Induzone.query.filter_by(id=id).first()
            data = {
                "district": induzone.district,
                "cate": induzone.cate,
                "area": induzone.area,
                # "address": induzone.address,
                "address": induzone.region,
                "cluster": induzone.cluster,
                "name": induzone.name,  # 名称
                # "district": induzone.district,  # 所属地区
                "phone": induzone.phone,  # 电话
                "email": induzone.email,
                # "address": induzone.address,  # 园区地址
                "industry_position": induzone.industry_position,  # 产业定位
                # "cate": induzone.cate,  # 园区类型
                "gdp": induzone.gdp,  # GDP
                "represent": induzone.represent,  # 代表企业
                "introduct": induzone.introduct,  # 简介
                "level": induzone.level,  # 等级
                "charge": induzone.charge,  # 园区负责人
                "site": induzone.site,  # 园区所在地
                "industry_type": induzone.industry_type,  # 产业类型
                # "area": induzone.area,  # 面积
                "out_power": induzone.out_power,  # 产出强度（万元/亩）

                "invest_power": induzone.invest_power,  # 亩均投资强度（万元/亩）
                "value_product": induzone.value_product,  # 亩均年产值（万元/亩）
                "tax": induzone.tax,  # 亩均年税收（万元/亩）
                "indu_land": induzone.indu_land,  # 工业土地均价（万元/亩）
                "comm_land": induzone.comm_land,  # 商办土地均价（万元/亩）
                "highmag": induzone.highmag,  # 高层管理人员（元/月）
                "middlemag": induzone.middlemag,  # 中级管理人员（元/月）
                "worker": induzone.worker,  # 普通员工（元/月）
                "trans_facility": induzone.trans_facility,  # 交通配套
                "goods_trans": induzone.goods_trans,  # 货物运输
                "live_facility": induzone.live_facility,  # 园区生活配套
                "market": induzone.market,  # 百货商场
                "hotel_bus": induzone.hotel_bus,  # 酒店商务
                "medical": induzone.medical,  # 医疗机构
                "education": induzone.education,  # 教育教育
            }
            return jsonify(code=RET.OK, msg='详情数据查询成功！', data=data)
        except Exception as e:
            current_app.logger.error(e)

    if cate_id == 3:
        try:
            land = ZaitiLand.query.filter_by(id=id).first()
            data = {
                "num": land.num,  # 编号
                "name": land.name,  # 地块名称
                "addr": land.addr,  # 地址
                "nature": land.nature,  # 土地性质
                "acreage": land.acreage,  # 面积
                "target": land.target,  # 规划指标
                "age_limit": land.age_limit,  # 出让年限
                "industry_type": land.industry_type,  # 产业类型
                "telephone": land.telephone  # 电话
            }
            return jsonify(code=RET.OK, msg='土地详情查询成功！', data=data)
        except Exception as e:
            current_app.logger.error(e)

    if cate_id == 4:
        try:
            build = ZaitiBuild.query.filter_by(id=id).first()
            data = {
                "name": build.name,  # 楼宇名称
                "addr": build.addr,  # 地址
                "acreage": build.acreage,  # 面积
                "buide_type": build.buide_type,  # 楼宇类型
                "industry_type": build.industry_type,  # 产业类型
                "rate": build.rate,  # 出租率
                "telephone": build.telephone  # 电话
            }
            return jsonify(code=RET.OK, msg='楼宇详情查询成功！', data=data)
        except Exception as e:
            current_app.logger.error(e)

    if cate_id == 5:
        try:
            factory = ZaitiFactory.query.filter_by(id=id).first()
            data = {
                "name": factory.name,  # 厂房名称
                "addr": factory.addr,  # 地址
                "acreage": factory.acreage,  # 面积
                "structure": factory.structure,  # 简介
                "height": factory.height,  # 高度
                "bearing": factory.bearing,  # 承重
                "new_level": factory.new_level,  # 新旧程度
                "other": factory.other,  # 其他
                "industry_type": factory.industry_type,  # 产业类型
                "factory_type": factory.factory_type,  # 厂房类型
                "telephone": factory.telephone,  # 电话
            }
            return jsonify(code=RET.OK, msg='厂房详情查询成功！', data=data)
        except Exception as e:
            current_app.logger.error(e)
