# # -*- coding:utf-8 -*-
import threading
from apps.models import IndustryChain, Enterprise
from manager import app
from apps import db


"""
IndustryChain或者Enterprise数据表更新后，
计算产业环节相关企业的数量并填充到IndustryChain的enterprise_num字段中。
"""

def handle():
    with app.app_context():
        industry_obj_list = IndustryChain.query.all()
        print(industry_obj_list)
        # 读取industry_chain数据表的产业名称
        for industry_obj in industry_obj_list:
            industry_name = industry_obj.industry_name
            chain_id = industry_obj.chain_id
            # 读取全国企业表，模糊匹配product_all字段
            if industry_name in ["钢铁", "光机电", "煤层气", "装备制造", "铸造",
                                 "煤化工", "新材料", "绿色建材", "医药", "丝麻纺织服装",
                                 "现代服务业", "数字经济", "文化旅游"]:
                continue

            else:
                print("正在查询【{}】的相关企业......".format(industry_name))
                enterprise_num1 = Enterprise.query.filter(
                    Enterprise.c_type == chain_id,
                    Enterprise.product_all.like("%{}%".format(industry_name))
                ).count()

                enterprise_num2 = Enterprise.query.filter(
                    Enterprise.c_type1 == chain_id,
                    Enterprise.product_all1.like("%{}%".format(industry_name))
                ).count()

                enterprise_num3 = Enterprise.query.filter(
                    Enterprise.c_type2 == chain_id,
                    Enterprise.product_all2.like("%{}%".format(industry_name))
                ).count()
                enterprise_num = enterprise_num1 + enterprise_num2 + enterprise_num3
                industry_obj.enterprise_num = enterprise_num
                db.session.commit()
                print("产品【{}】已完成, 共有{}家相关企业。".format(industry_name, enterprise_num))


if __name__ == '__main__':
    t = threading.Thread(target=handle)
    t.start()
