import time

import oss2
from flask import current_app, request, jsonify
from apps.manage import api_power
from apps.models import *
from apps.util import login_required, verify_btoken
from apps.utils.response_code import RET


def upload_daily_picture(file_name, file):
    try:
        access_key_id = "LTAI4Fkgi7DUf6jCVW3KNGwT"
        access_key_secret = "ynr6TWWNOnpALn3YUICUaXwpp9w4er"
        auth = oss2.Auth(access_key_id, access_key_secret)
        bucket_name = "zysf-store"
        endpoint = "oss-cn-beijing.aliyuncs.com"
        bucket = oss2.Bucket(auth, endpoint, bucket_name)
        bucket.put_object('晋城招商图谱平台/产业大类图标/' + file_name, file)
        icon_url = "https://{}.{}/{}".format(bucket_name, endpoint, '/晋城招商图谱平台/产业大类图标/' + file_name)
        time.sleep(1)
        return icon_url
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.THIRDERR, msg='第三方系统(阿里云oss存储)出错！')


# 产业名称列表
@api_power.route('/ChainList', methods=['GET'])
@login_required
def chain_list():
    try:
        field = IndustryChain.query.filter_by(industry_type=0).all()
        data = [{"id": i.id,
                 "name": i.industry_name,
                 "status": i.status,  # 启用状态1启用，2禁用
                 "icon": i.icon_url,
                 "icon1": i.icon_url1
                 } for i in field]
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")
    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 产业详情信息
@api_power.route('/ChainDetail', methods=['POST'])
@login_required
def chain_detail():
    req_dict = request.get_json()
    _id = req_dict.get('id')  # 行业id
    try:
        chain_obj = IndustryChain.query.get(_id)
        data = {"id": chain_obj.id,
                 "name": chain_obj.industry_name,
                 "status": chain_obj.status,  # 启用状态1启用，2禁用
                 "icon": chain_obj.icon_url,
                 "icon1": chain_obj.icon_url1
                 }
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")
    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 产业名称新增或修改
@api_power.route('/AddEditChain', methods=['POST'])
@login_required
def add_edit_chain():
    _id = request.form['id']
    industry_name = request.form['industry_name']
    icon_url = ''
    icon_url1 = ''
    try:
        icon = request.files['icon']
        file_name = icon.filename
        icon_url = upload_daily_picture(file_name, icon)
    except Exception as e:
        pass

    try:
        icon1 = request.files['icon1']
        file_name1 = icon1.filename
        icon_url1 = upload_daily_picture(file_name1, icon1)
    except Exception as e:
        pass

    try:
        chain_obj = IndustryChain.query.get(_id)
        if chain_obj:
            chain_obj.industry_name = industry_name
            if icon_url:
                chain_obj.icon_url = icon_url
            if icon_url1:
                chain_obj.icon_url1 = icon_url1
            db.session.commit()
            return jsonify(code=RET.OK, msg="修改成功")
        else:
            chain_obj = IndustryChain(industry_name=industry_name,
                                      icon_url=icon_url,
                                      icon_url1=icon_url1,
                                      status=1,
                                      industry_type=0)
            db.session.add(chain_obj)
            db.session.commit()
            return jsonify(code=RET.OK, msg="新增成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")


# 产业状态修改
@api_power.route('/ChainStatus', methods=['POST'])
@login_required
def chain_status():
    req_dict = request.get_json()
    _id = req_dict.get('id')  # 行业id
    status = req_dict.get("status")  # 状态值1启用，2禁用

    try:
        field = IndustryChain.query.get(_id)
        field.status = status
        db.session.commit()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")
    return jsonify(code=RET.OK, msg="修改成功")


# '''导航一'''
#
#
# # 产业发展图谱目录列表
# @api_power.route('/listPropertyty', methods=['GET'])
# @login_required
# def list_propertyty():
#     '''产业发展图谱目录列表'''
#     try:
#         field = Propertyty.query.all()
#         data = [{"id": i.id,
#                  "name": i.name,
#                  "statu": i.statu,  # 状态 1启动，2禁用
#                  "cate": "企业类型" if i.sid == 1 else "企业资质" if i.sid == 2 else "上市状态" if i.sid == 3
#                  else "融资轮次"} for i in field]
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据异常")
#
#     return jsonify(code=RET.OK, msg="获取成功", data=data)
#
#
# # 产业发展图谱目录信息编辑
# @api_power.route('/modifyPropertyty', methods=['POST'])
# @login_required
# def modify_propertyty():
#     '''产业发展图谱目录信息编辑'''
#     token = request.headers["token"]
#     user = verify_btoken(token)
#     user_role = user.role  # 用户角色
#     if user_role != 1:
#         return jsonify(code=RET.ROLEERR, msg="暂无权限")
#
#     req_dict = request.get_json()
#     _id = req_dict.get('id')  # 行业id
#     name = req_dict.get("newname")  # 行业新名字
#
#     try:
#         propertyty = Propertyty.query.get(_id)
#         propertyty.name = name
#         db.session.commit()
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据异常")
#
#     return jsonify(code=RET.OK, msg="修改成功")
#
#
# # 产业发展图谱导航状态修改
# @api_power.route('/propertytyStatu', methods=['POST'])
# @login_required
# def propertyty_statu():
#     '''产业发展图谱导航状态修改'''
#     token = request.headers["token"]
#     user = verify_btoken(token)
#     user_role = user.role  # 用户角色
#     if user_role != 1:
#         return jsonify(code=RET.ROLEERR, msg="暂无权限")
#     req_dict = request.get_json()
#     _id = req_dict.get('id')  # 行业id
#     statu = req_dict.get("statu")  # 状态值1启用，2禁用
#
#     try:
#         propertyty = Propertyty.query.get(_id)
#         if statu == 1:
#             propertyty.statu = 2
#         else:
#             propertyty.statu = 1
#         db.session.commit()
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据异常")
#
#     return jsonify(code=RET.OK, msg="修改成功")
#
#
# '''导航二'''
#
#
# # 产业招商地图360企业画像目录列表
# @api_power.route('/listProperty', methods=['GET'])
# @login_required
# def list_property():
#     '''产业发展图谱目录列表'''
#     try:
#         propert = Property.query.all()
#         data = [{"id": i.id,
#                  "name": i.name,
#                  "statu": i.statu,  # 状态 1启动，2禁用
#                  "cate": "企业类型" if i.sid == 1 else "企业资质" if i.sid == 2 else "上市状态" if i.sid == 3
#                  else "融资轮次"} for i in propert]
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据异常")
#
#     return jsonify(code=RET.OK, msg="获取成功", data=data)
#
#
# # 产业招商地图360企业画像目录信息编辑
# @api_power.route('/modifyProperty', methods=['POST'])
# @login_required
# def modify_property():
#     '''产业招商地图360企业画像目录信息编辑'''
#     token = request.headers["token"]
#     user = verify_btoken(token)
#     user_role = user.role  # 用户角色
#     if user_role != 1:
#         return jsonify(code=RET.ROLEERR, msg="暂无权限")
#
#     req_dict = request.get_json()
#     _id = req_dict.get('id')  # 行业id
#     name = req_dict.get("newname")  # 行业新名字
#
#     try:
#         propert = Property.query.get(_id)
#         propert.name = name
#         db.session.commit()
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据异常")
#
#     return jsonify(code=RET.OK, msg="修改成功")
#
#
# # 产业招商地图360企业画像目录状态修改
# @api_power.route('/propertyStatu', methods=['POST'])
# @login_required
# def property_statu():
#     '''产业招商地图360企业画像目录状态修改'''
#     token = request.headers["token"]
#     user = verify_btoken(token)
#     user_role = user.role  # 用户角色
#     if user_role != 1:
#         return jsonify(code=RET.ROLEERR, msg="暂无权限")
#
#     req_dict = request.get_json()
#     _id = req_dict.get('id')  # 行业id
#     statu = req_dict.get("statu")  # 状态值1启用，2禁用
#
#     try:
#         propert = Property.query.get(_id)
#         if statu == 1:
#             propert.statu = 2
#         else:
#             propert.statu = 1
#         db.session.commit()
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据异常")
#
#     return jsonify(code=RET.OK, msg="修改成功")
#
#
# '''导航三'''
#
#
# # 招商资源管理目录列表
# @api_power.route('/listAttract', methods=['GET'])
# @login_required
# def list_atract():
#     '''招商资源管理目录列表'''
#     try:
#         attract = Attract.query.all()
#         data = [{"id": i.id,
#                  "name": i.name,
#                  "statu": i.statu,  # 状态 1启动，2禁用
#                  "cate": "行业选择" if i.sid == 1 else "项目阶段" if i.sid == 2 else "项目级别"} for i in attract]
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据异常")
#
#     return jsonify(code=RET.OK, msg="获取成功", data=data)
#
#
# # 招商资源管理目录信息编辑
# @api_power.route('/modifyAttract', methods=['POST'])
# @login_required
# def modify_attract():
#     '''招商资源管理目录信息编辑'''
#     token = request.headers["token"]
#     user = verify_btoken(token)
#     user_role = user.role  # 用户角色
#     if user_role != 1:
#         return jsonify(code=RET.ROLEERR, msg="暂无权限")
#     req_dict = request.get_json()
#     _id = req_dict.get('id')  # 行业id
#     name = req_dict.get("newname")  # 行业新名字
#
#     try:
#         attract = Attract.query.get(_id)
#         attract.name = name
#         db.session.commit()
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据异常")
#
#     return jsonify(code=RET.OK, msg="修改成功")
#
#
# # 招商资源管理目录状态修改
# @api_power.route('/attractStatu', methods=['POST'])
# @login_required
# def attract_statu():
#     '''产业发展图谱导航状态修改'''
#     token = request.headers["token"]
#     user = verify_btoken(token)
#     user_role = user.role  # 用户角色
#     if user_role != 1:
#         return jsonify(code=RET.ROLEERR, msg="暂无权限")
#     req_dict = request.get_json()
#     _id = req_dict.get('id')  # 行业id
#     statu = req_dict.get("statu")  # 状态值1启用，2禁用
#
#     try:
#         attract = Attract.query.get(_id)
#         if statu == 1:
#             attract.statu = 2
#         else:
#             attract.statu = 1
#         db.session.commit()
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据异常")
#
#     return jsonify(code=RET.OK, msg="修改成功")
#
#
# '''导航四'''
#
#
# # 园区信息目录列表
# @api_power.route('/listZone', methods=['GET'])
# @login_required
# def list_zone():
#     '''招商资源管理目录列表'''
#     try:
#         zone = Zone.query.all()
#         data = [{"id": i.id,
#                  "name": i.name,
#                  "statu": i.statu,  # 状态 1启动，2禁用
#                  "cate": "园区类别" if i.sid == 1 else "园区级别"} for i in zone]
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据异常")
#
#     return jsonify(code=RET.OK, msg="获取成功", data=data)
#
#
# # 园区信息目录信息编辑
# @api_power.route('/modifyZone', methods=['POST'])
# @login_required
# def modify_zone():
#     '''园区信息目录信息编辑'''
#     token = request.headers["token"]
#     user = verify_btoken(token)
#     user_role = user.role  # 用户角色
#     if user_role != 1:
#         return jsonify(code=RET.ROLEERR, msg="暂无权限")
#     req_dict = request.get_json()
#     _id = req_dict.get('id')  # 行业id
#     name = req_dict.get("newname")  # 行业新名字
#
#     try:
#         zone = Zone.query.get(_id)
#         zone.name = name
#         db.session.commit()
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据异常")
#
#     return jsonify(code=RET.OK, msg="修改成功")
#
#
# # 园区信息目录状态修改
# @api_power.route('/zoneStatu', methods=['POST'])
# @login_required
# def zone_statu():
#     '''园区信息目录状态修改'''
#     token = request.headers["token"]
#     user = verify_btoken(token)
#     user_role = user.role  # 用户角色
#     if user_role != 1:
#         return jsonify(code=RET.ROLEERR, msg="暂无权限")
#     req_dict = request.get_json()
#     _id = req_dict.get('id')  # 行业id
#     statu = req_dict.get("statu")  # 状态值1启用，2禁用
#
#     try:
#         zone = Zone.query.get(_id)
#         if statu == 1:
#             zone.statu = 2
#         else:
#             zone.statu = 1
#         db.session.commit()
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据异常")
#
#     return jsonify(code=RET.OK, msg="修改成功")
