from flask import request, jsonify, current_app
from apps.manage import api_power
from apps.models import *
from apps.util import login_required, verify_btoken
from apps.utils.response_code import RET


# 获取角色列表
@api_power.route("/GetFixedRole", methods=["GET"])
@login_required
def get_fixed_role():
    try:
        chart_obj_list = OrganizationChart.query.all()
        data = [{
            "id": chart_obj.id,
            # "one_org": chart_obj.one_org,
            # "two_department": chart_obj.two_department,
            "three_role": chart_obj.three_role,
        } for chart_obj in chart_obj_list]
        return jsonify(code=RET.OK, data=data, msg="查询成功！")

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 获取角色权限详情
@api_power.route("/GetFixedRoleDetail", methods=["POST"])
@login_required
def get_fixed_role_detail():
    req_dic = request.get_json()
    role_id = req_dic['role_id']

    try:
        chart_obj = OrganizationChart.query.get(role_id)
        # print(chart_obj)
        data = {
            "three_role": chart_obj.three_role,
            "page_permission_id": eval(chart_obj.page_permission_id),
            "fun_permission_id": eval(chart_obj.fun_permission_id)}
        return jsonify(code=RET.OK, data=data, msg="查询成功！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 新增/修改角色并且赋予权限
@api_power.route("/AddEditRole", methods=["POST"])
@login_required
def add_edit_role():
    # token = request.headers["token"]
    # user = verify_btoken(token)
    # user_role = user.role  # 用户角色
    # if user_role != 1:
    #     return jsonify(code=RET.ROLEERR, msg="暂无权限，请联系管理员")

    req_dict = request.get_json()
    flag = req_dict.get("flag")  # 1为新增，2为修改编辑
    role_id = req_dict.get("role_id")  # 为修改编辑时填写，新增不填
    role_name = req_dict.get("role_name")  # 职位名称（角色）
    page_id_list = req_dict.get("page_id_list")
    fun_id_list = req_dict.get("fun_id_list")

    # 校验参数完整性
    if not all([role_name, page_id_list, fun_id_list]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整, 权限勾选不能为空！")

    try:
        if flag == 1:  # 新增
            role_obj = OrganizationChart.query.filter_by(three_role=role_name).first()
            if role_obj:
                return jsonify(code=RET.DATAEXIST, msg="角色名已存在！")
            else:
                role_obj = OrganizationChart(three_role=role_name, page_permission_id=str(page_id_list),
                                             fun_permission_id=str(fun_id_list)
                                             )
                db.session.add(role_obj)
                db.session.commit()
                return jsonify(code=RET.OK, msg="添加成功")
        elif flag == 2:  # 编辑修改
            role_obj = OrganizationChart.query.get(role_id)
            # role_obj.one_org = org_name
            # role_obj.two_department = department_name
            role_obj.three_role = role_name
            role_obj.page_permission_id = str(page_id_list)
            role_obj.fun_permission_id = str(fun_id_list)
            db.session.commit()
            return jsonify(code=RET.OK, msg="修改成功")
        else:
            return jsonify(code=RET.OK, msg="参数错误")
    except Exception as e:
        current_app.logger.error(e)
        db.session.rollback()
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 删除角色
@api_power.route("/deleteRole", methods=["POST"])
@login_required
def delete_role():
    # token = request.headers["token"]
    # user = verify_btoken(token)
    # user_role = user.role  # 用户角色
    # if user_role != 1:
    #     return jsonify(code=RET.ROLEERR, msg="暂无权限，请联系管理员")
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 角色id

    # 校验参数完整性
    if not all([_id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    if _id < 9:
        return jsonify(code=RET.PARAMERR, msg="固定角色不能删除！")

    try:
        user_obj = User.query.filter_by(org_id=_id).all()
        if len(user_obj):
            return jsonify(code=RET.DATAEXIST, msg="当前角色存在用户使用,请查证并清除后再操作")
        org_obj = OrganizationChart.query.get(_id)
        db.session.delete(org_obj)
        db.session.commit()
        return jsonify(code=RET.OK, msg="删除成功")
    except Exception as e:
        current_app.logger.error(e)
        db.session.rollback()
        return jsonify(code=RET.DBERR, msg="删除出错！")
