import { createRouter, createWebHistory } from 'vue-router'
// import HomeView from '../views/HomeView.vue'
import login from "../views/login/index.vue"
import home from "../views/home/home.vue"
import index from "../views/home/index.vue"
//企业页面
import company from "../views/company/index.vue"
//专利页面
import patent from "../views/patent/index.vue"
import patentDetails from "../views/patent/patentDetails.vue"
//历史记录
import history from "../views/history/index.vue"
//我的关注
import follow from "../views/follow/index.vue"
//管理员登录
import AdminLogin from "../views/login/admin.vue"
//忘记密码
import forget from "../views/login/forget.vue"
//个人设置
import usersetting from "../views/userset/index.vue"
import personalSetting from "../views/userset/personalSetting.vue"
import securitySetting from "../views/userset/securitySetting.vue"


const routes = [
  {
    path: '/',
    redirect: '/login'
    // component: AdminLogin,
  },
  {
    path: '/login',
    name: 'login',
    component: login,
  },
  {
    path: '/adminLogin',
    name: 'AdminLogin',
    component: AdminLogin,
  },
  {
    path: '/forget',
    name: 'forget',
    component: forget,
  },
  {
    path: '/index',
    name: 'index',
    component: index,
    redirect: '/home',
    children: [
      {
        path: '/home',
        name: 'home',
        component: home
      },
      {
        path: '/company',
        name: 'company',
        component: company
      },
      {
        path: '/patent',
        name: 'patent',
        component: patent,
      },
      {
        path: '/history',
        name: 'history',
        component: history
      },
      {
        path: '/follow',
        name: 'follow',
        component: follow
      },
      {
        path: '/patentDetails',
        name: 'patentDetails',
        component: patentDetails
      },
    ]
  },
  {
    path:'/usersetting',
    name:'usersetting',
    component:usersetting,
    redirect:'/personalSetting',
    children:[
      {
        path:'/personalSetting',
        name:'personalSetting',
        component:personalSetting,
      },
      {
        path:'/securitySetting',
        name:'securitySetting',
        component:securitySetting,
      }
      
    ]
  }
 
  //   path: '/about',
  //   name: 'about',
  //   // route level code-splitting
  //   // this generates a separate chunk (about.[hash].js) for this route
  //   // which is lazy-loaded when the route is visited.
  //   // component: () => import(/* webpackChunkName: "about" */ '../views/AboutView.vue')
  // }
]

const router = createRouter({
  history: createWebHistory(process.env.BASE_URL),
  routes
})

export default router
